/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.core.json;

import ee.jakarta.tck.core.common.Utils;
import ee.jakarta.tck.core.json.CustomJsonProvider;
import ee.jakarta.tck.core.json.JsonProviderProducer;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.spi.JsonProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestReporter;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class ApplicationJsonpIT {
    private static final String EXPECTED_JSON_PROVIDER = CustomJsonProvider.class.getName();
    @Inject
    JsonProvider customProvider;

    @Deployment(testable=true)
    public static WebArchive createTestArchive() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ApplicationJsonpIT.class.getSimpleName() + ".war"));
        ((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)archive.addClass(ApplicationJsonpIT.class)).addClass(CustomJsonProvider.class)).addClass(JsonProviderProducer.class)).addClass(Utils.class)).addAsServiceProvider(JsonProvider.class, new Class[]{CustomJsonProvider.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.printf("test archive: %s\n", archive.toString(true));
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File("/tmp/" + archive.getName()), true);
        return archive;
    }

    @Test
    public void testCustomProvider(TestReporter reporter) {
        JsonProvider provider = JsonProvider.provider();
        String providerClass = provider.getClass().getName();
        reporter.publishEntry("provider class=" + providerClass);
        if (providerClass.equals(EXPECTED_JSON_PROVIDER)) {
            reporter.publishEntry("Current provider does matches " + EXPECTED_JSON_PROVIDER);
        } else {
            reporter.publishEntry("Current provider does NOT matches " + EXPECTED_JSON_PROVIDER);
            ServiceLoader<JsonProvider> loader = ServiceLoader.load(JsonProvider.class);
            Iterator<JsonProvider> it = loader.iterator();
            ArrayList<JsonProvider> providers = new ArrayList<JsonProvider>();
            while (it.hasNext()) {
                providers.add(it.next());
            }
            reporter.publishEntry("Providers: " + providers);
            Assertions.fail((String)("Failed to find JsonProvider: " + EXPECTED_JSON_PROVIDER));
        }
    }

    @Test
    public void testInjectCustomProvider(TestReporter reporter) {
        reporter.publishEntry("customProvider: " + this.customProvider);
        Assertions.assertNotNull((Object)this.customProvider, (String)"Injected JsonProvider");
    }

    @Test
    public void testUseCustomProvider(TestReporter reporter) {
        System.out.printf("testUseCustomProvider\n", new Object[0]);
        JsonArrayBuilder arrayBuilder = this.customProvider.createArrayBuilder();
        String method = Utils.popStack();
        Assertions.assertEquals((Object)"createArrayBuilder()Ljakarta/json/JsonArrayBuilder;", (Object)method);
        this.customProvider.createBuilderFactory(null);
        method = Utils.popStack();
        Assertions.assertEquals((Object)"createBuilderFactory(Ljava/util/Map;)Ljakarta/json/JsonBuilderFactory;", (Object)method);
    }

    @Test
    public void testUseJsonWithCustomProvider(TestReporter reporter) {
        System.out.printf("testUseJsonWithCustomProvider\n", new Object[0]);
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        String method = Utils.popStack();
        Assertions.assertEquals((Object)"createArrayBuilder()Ljakarta/json/JsonArrayBuilder;", (Object)method);
        Json.createBuilderFactory(null);
        method = Utils.popStack();
        Assertions.assertEquals((Object)"createBuilderFactory(Ljava/util/Map;)Ljakarta/json/JsonBuilderFactory;", (Object)method);
    }
}

