/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.tx;

import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Order;

@Web
@RunAsClient
@Common(value={Common.PACKAGE.TRANSACTION})
public class TransactionTests
extends TestClient {
    @ArquillianResource
    private URL baseURL;

    @Deployment(name="TransactionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{TransactionTests.class.getPackage()});
    }

    @Order(value=1)
    @Assertion(id="SPEC:63 SPEC:64 SPEC:65 SPEC:66 SPEC:67 SPEC:69 SPEC:71 SPEC:72", strategy="Get UserTransaction inside one task submitted by ManagedScheduledExecutorService. Test rollback function in the submitted task.")
    public void testRollbackTransactionWithManagedScheduledExecutorService() {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=false").withTestName("transactionTest"));
    }

    @Order(value=2)
    @Assertion(id="SPEC:63 SPEC:64 SPEC:65 SPEC:66 SPEC:67 SPEC:69 SPEC:8.1 SPEC:9 SPEC:71 SPEC:72", strategy="Get UserTransaction inside one task submitted by ManagedScheduledExecutorService. It support user-managed global transaction demarcation using the jakarta.transaction.UserTransaction interface.")
    public void testCommitTransactionWithManagedScheduledExecutorService() {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=true").withTestName("transactionTest"));
    }

    @Order(value=3)
    @Assertion(id="SPEC:42.1 SPEC:42.3 SPEC:63 SPEC:64 SPEC:65 SPEC:66 SPEC:67 SPEC:69 SPEC:71 SPEC:72", strategy="Get UserTransaction inside one task submitted by ManagedScheduledExecutorService.cancel the task after submit one task.")
    public void testCancelTransactionWithManagedScheduledExecutorService() {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=cancel").withTestName("cancelTest"));
    }
}

