/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.common.tasks;

import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import java.time.Duration;
import java.util.concurrent.Callable;

public final class CommonTasks {
    private CommonTasks() {
    }

    public static class SimpleArgCallable
    implements Callable<Integer> {
        private int value = -1;

        public SimpleArgCallable(int arg) {
            this.value = arg;
        }

        @Override
        public Integer call() {
            try {
                Wait.sleep(TestConstants.pollInterval);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this.value;
        }
    }

    public static class SimpleRunnable
    implements Runnable {
        @Override
        public void run() {
            try {
                Wait.sleep(TestConstants.pollInterval);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class SimpleCallable
    implements Callable<String> {
        private Duration waitTime = Duration.ZERO;

        public SimpleCallable() {
        }

        public SimpleCallable(Duration waitTime) {
            this.waitTime = waitTime;
        }

        @Override
        public String call() {
            try {
                if (!this.waitTime.isZero()) {
                    Wait.sleep(this.waitTime);
                } else {
                    Wait.sleep(TestConstants.pollInterval);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return "ok";
        }
    }
}

