/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ManagedExecutors;

import ee.jakarta.tck.concurrent.common.managed.task.listener.ListenerEvent;
import ee.jakarta.tck.concurrent.common.managed.task.listener.ManagedTaskListenerImpl;
import ee.jakarta.tck.concurrent.common.tasks.CallableTask;
import ee.jakarta.tck.concurrent.common.tasks.RunnableTask;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;

@Web
@Common(value={Common.PACKAGE.MANAGED_TASK_LISTENER, Common.PACKAGE.TASKS})
public class ManagedExecutorsTests {
    private static final String ENV_ENTRY_JNDI_NAME = "java:comp/env/StringValue";
    private static final String ENV_ENTRY_VALUE = "something";
    private ManagedTaskListenerImpl managedTaskListener = new ManagedTaskListenerImpl();
    private boolean shutdown = true;
    @Resource(lookup="java:comp/DefaultManagedThreadFactory")
    private ManagedThreadFactory threadFactory;
    @Resource(lookup="java:comp/DefaultManagedExecutorService")
    private ManagedExecutorService executor;

    @Deployment(name="ManagedExecutorsTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource(ManagedExecutorsTests.class.getPackage(), "web.xml", "web.xml");
    }

    @AfterEach
    public void after() {
        this.managedTaskListener.clearEvents();
    }

    private RunnableTask createRunnableTask() {
        return new RunnableTask(ENV_ENTRY_JNDI_NAME, ENV_ENTRY_VALUE, this.getClass().getName());
    }

    private CallableTask<String> createCallableTask(String expectedReturnValue) {
        return new CallableTask<String>(ENV_ENTRY_JNDI_NAME, ENV_ENTRY_VALUE, this.getClass().getName(), expectedReturnValue);
    }

    private void assertTaskAndListenerComplete(Future<?> future, RunnableTask runnableTask) {
        Wait.waitForTaskComplete(future);
        this.assertListenerComplete(runnableTask);
    }

    private void assertTaskAndListenerComplete(String expectedResult, Future<String> future, CallableTask<?> callableTask) {
        String result = Wait.waitForTaskComplete(future);
        Assertions.assertTrue((boolean)expectedResult.endsWith(result));
        this.assertListenerComplete(callableTask);
    }

    private void assertListenerComplete(RunnableTask task) {
        Wait.waitForListenerComplete(this.managedTaskListener);
        Assertions.assertTrue((boolean)this.managedTaskListener.eventCalled(ListenerEvent.SUBMITTED));
        Assertions.assertTrue((boolean)this.managedTaskListener.eventCalled(ListenerEvent.STARTING));
        Assertions.assertTrue((boolean)this.managedTaskListener.eventCalled(ListenerEvent.DONE));
    }

    @Assertion(id="JAVADOC:21", strategy="Use a regular thread(non-Manageable thread) and verify isCurrentThreadShutdown() returns false")
    public void isCurrentThreadShutdown() {
        Thread createdThread = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                ManagedExecutorsTests.this.shutdown = ManagedExecutors.isCurrentThreadShutdown();
            }
        });
        Future<?> future = Executors.newSingleThreadExecutor().submit(createdThread);
        Wait.waitForTaskComplete(future);
        Assertions.assertFalse((boolean)this.shutdown, (String)"Failed because shutdown is set to be true when running job");
    }

    @Assertion(id="JAVADOC:21", strategy="Create a ManageableThread from ManagedThreadFactory and check the shutdown status.")
    public void isCurrentThreadShutdownManageableThread() {
        Thread createdThread = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                ManagedExecutorsTests.this.shutdown = ManagedExecutors.isCurrentThreadShutdown();
            }
        });
        Future<?> future = Executors.newSingleThreadExecutor((ThreadFactory)this.threadFactory).submit(createdThread);
        Wait.waitForTaskComplete(future);
        Assertions.assertFalse((boolean)this.shutdown, (String)"Failed because shutdown is set to be true when running job");
    }

    @Assertion(id="JAVADOC:22 SPEC:7 SPEC:7.1 SPEC:7.2 SPEC:4 SPEC:4.2 SPEC:18", strategy="Returns a Runnable object that also implements ManagedTask interface so it can receive notification of life cycle events with the provided ManagedTaskListener when the task is submitted to a ManagedExecutorService or a ManagedScheduledExecutorService.")
    public void manageRunnableTaskWithTaskListener() {
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = this.executor.submit(taskWithListener);
        this.assertTaskAndListenerComplete(futureResult, runnableTask);
    }

    @Assertion(id="JAVADOC:23", strategy="Catch IllegalArgumentException when get the manage task with null runnable task.")
    public void manageRunnableTaskWithNullArg() {
        Runnable nullTask = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ManagedExecutors.managedTask((Runnable)nullTask, (ManagedTaskListener)this.managedTaskListener));
    }

    @Assertion(id="JAVADOC:24 SPEC:13", strategy="Returns a Runnable object that also implements ManagedTask interface so it can receive notification of life cycle events with the provided ManagedTaskListener and to provide additional execution properties when the task is submitted to a ManagedExecutorService")
    public void manageRunnableTaskWithTaskListenerAndMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable task = ManagedExecutors.managedTask((Runnable)runnableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        Assertions.assertTrue((boolean)(task instanceof ManagedTask));
        ManagedTask managedTask = (ManagedTask)task;
        Assertions.assertEquals((Object)"value", managedTask.getExecutionProperties().get("key"));
        this.assertTaskAndListenerComplete(this.executor.submit(task), runnableTask);
    }

    @Assertion(id="JAVADOC:25", strategy="Catch IllegalArgumentException when get the manage task with null runnable task and additional execution properties.")
    public void manageRunnableTaskWithMapAndNullArg() {
        Runnable nullTask = null;
        HashMap properties = new HashMap();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ManagedExecutors.managedTask((Runnable)nullTask, (Map)properties, (ManagedTaskListener)this.managedTaskListener));
    }

    @Assertion(id="JAVADOC:26", strategy="Returns a Callable object that also implements ManagedTask interface so it can receive notification of life cycle events with the provided ManagedTaskListener when the task is submitted to a ManagedExecutorService")
    public void manageCallableTaskWithTaskListener() {
        String expectedResultStr = "expected something";
        CallableTask<String> callableTask = this.createCallableTask(expectedResultStr);
        Callable taskWithListener = ManagedExecutors.managedTask(callableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = this.executor.submit(taskWithListener);
        this.assertTaskAndListenerComplete(expectedResultStr, futureResult, callableTask);
    }

    @Assertion(id="JAVADOC:27", strategy="Catch IllegalArgumentException when get the manage task with null Callable task.")
    public void manageCallableTaskWithNullArg() {
        Callable nullTask = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ManagedExecutors.managedTask((Callable)nullTask, (ManagedTaskListener)this.managedTaskListener));
    }

    @Assertion(id="JAVADOC:28 SPEC:13.1 SPEC:45 SPEC:45.1", strategy="Returns a Callable object that also implements ManagedTask interface so it can receive notification of life cycle events with the provided ManagedTaskListener and to provide additional execution properties when the task is submitted to a ManagedExecutorService")
    public void manageCallableTaskWithTaskListenerAndMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        properties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", "id");
        String expectedResultStr = "expected something";
        CallableTask<String> callableTask = this.createCallableTask(expectedResultStr);
        Callable task = ManagedExecutors.managedTask(callableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        Assertions.assertTrue((boolean)(task instanceof ManagedTask));
        ManagedTask managedTask = (ManagedTask)task;
        Assertions.assertEquals((Object)"value", managedTask.getExecutionProperties().get("key"));
        this.assertTaskAndListenerComplete(expectedResultStr, this.executor.submit(task), callableTask);
    }

    @Assertion(id="JAVADOC:29", strategy="Catch IllegalArgumentException when get the manage task with null Callable task and additional execution properties.")
    public void manageCallableTaskWithMapAndNullArg() {
        Callable nullTask = null;
        HashMap properties = new HashMap();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ManagedExecutors.managedTask((Callable)nullTask, (Map)properties, (ManagedTaskListener)this.managedTaskListener));
    }
}

