/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.AbortedException;

import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import jakarta.enterprise.concurrent.AbortedException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

@Web
public class AbortedExceptionTests {
    @Deployment(name="AbortedExceptionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{AbortedExceptionTests.class.getPackage()});
    }

    @Assertion(id="JAVADOC:1", strategy="Constructs an AbortedException")
    public void abortedExceptionNoArgTest() {
        AbortedException thrown = (AbortedException)Assertions.assertThrows(AbortedException.class, () -> {
            throw new AbortedException();
        });
        Assertions.assertNull((Object)thrown.getMessage());
    }

    @Assertion(id="JAVADOC:3", strategy="Constructs an AbortedException")
    public void abortedExceptionStringTest() {
        String expected = "thisisthedetailmessage";
        AbortedException thrown = (AbortedException)Assertions.assertThrows(AbortedException.class, () -> {
            throw new AbortedException("thisisthedetailmessage");
        });
        Assertions.assertNotNull((Object)thrown.getMessage());
        Assertions.assertEquals((Object)"thisisthedetailmessage", (Object)thrown.getMessage());
    }

    @Assertion(id="JAVADOC:4", strategy="Constructs an AbortedException")
    public void abortedExceptionThrowableTest() {
        Throwable expected = new Throwable("thisisthethrowable");
        AbortedException thrown = (AbortedException)Assertions.assertThrows(AbortedException.class, () -> {
            throw new AbortedException(expected);
        });
        Assertions.assertNotNull((Object)thrown.getCause());
        Assertions.assertEquals((Object)expected, (Object)thrown.getCause());
        Throwable expectedNull = null;
        thrown = (AbortedException)Assertions.assertThrows(AbortedException.class, () -> {
            throw new AbortedException(expectedNull);
        });
        Assertions.assertNull((Object)thrown.getCause());
    }

    @Assertion(id="JAVADOC:2", strategy="Constructs an AbortedException")
    public void abortedExceptionStringThrowableTest() {
        String sExpected = "thisisthedetailmessage";
        String sExpectedNull = null;
        Throwable tExpected = new Throwable("thisisthethrowable");
        Throwable tExpectedNull = null;
        AbortedException thrown = (AbortedException)Assertions.assertThrows(AbortedException.class, () -> {
            throw new AbortedException(sExpected, tExpected);
        });
        Assertions.assertNotNull((Object)thrown.getMessage());
        Assertions.assertNotNull((Object)thrown.getCause());
        Assertions.assertEquals((Object)sExpected, (Object)thrown.getMessage());
        Assertions.assertEquals((Object)tExpected, (Object)thrown.getCause());
        thrown = (AbortedException)Assertions.assertThrows(AbortedException.class, () -> {
            throw new AbortedException(sExpected, tExpectedNull);
        });
        Assertions.assertNotNull((Object)thrown.getMessage());
        Assertions.assertNull((Object)thrown.getCause());
        Assertions.assertEquals((Object)sExpected, (Object)thrown.getMessage());
        thrown = (AbortedException)Assertions.assertThrows(AbortedException.class, () -> {
            throw new AbortedException(sExpectedNull, tExpected);
        });
        Assertions.assertNull((Object)thrown.getMessage());
        Assertions.assertNotNull((Object)thrown.getCause());
        Assertions.assertEquals((Object)tExpected, (Object)thrown.getCause());
        thrown = (AbortedException)Assertions.assertThrows(AbortedException.class, () -> {
            throw new AbortedException(sExpectedNull, tExpectedNull);
        });
        Assertions.assertNull((Object)thrown.getMessage());
        Assertions.assertNull((Object)thrown.getCause());
    }
}

