/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.context;

import ee.jakarta.tck.concurrent.common.RunnableTask;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.context.SecurityTestInterface;
import jakarta.ejb.EJB;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.naming.InitialContext;
import org.testng.Assert;

@WebServlet(value={"/SecurityServlet"})
public class SecurityServlet
extends TestServlet {
    @EJB
    private SecurityTestInterface str;
    private static final String TEST_JNDI_EVN_ENTRY_VALUE = "hello";
    private static final String TEST_JNDI_EVN_ENTRY_JNDI_NAME = "java:comp/env/ManagedThreadFactory_test_string";
    private static final String TEST_CLASSLOADER_CLASS_NAME = SecurityServlet.class.getCanonicalName();

    public void jndiClassloaderPropagationTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        InitialContext context = new InitialContext();
        ManagedThreadFactory factory = (ManagedThreadFactory)context.lookup("java:comp/DefaultManagedThreadFactory");
        CounterRunnableWithContext task = new CounterRunnableWithContext();
        Thread thread = factory.newThread((Runnable)task);
        thread.start();
        TestUtil.waitTillThreadFinish(thread);
        Assert.assertEquals((int)task.getCount(), (int)1);
    }

    public void jndiClassloaderPropagationWithSecurityTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        req.login("javajoe", "javajoe");
        InitialContext context = new InitialContext();
        ManagedThreadFactory factory = (ManagedThreadFactory)context.lookup("java:comp/DefaultManagedThreadFactory");
        CounterRunnableWithSecurityCheck task = new CounterRunnableWithSecurityCheck(this.str);
        Thread thread = factory.newThread((Runnable)task);
        thread.start();
        TestUtil.waitTillThreadFinish(thread);
        Assert.assertEquals((int)task.getCount(), (int)1);
    }

    public static class CounterRunnableWithContext
    extends RunnableTask {
        private volatile int count = 0;

        public int getCount() {
            return this.count;
        }

        public CounterRunnableWithContext() {
            super(SecurityServlet.TEST_JNDI_EVN_ENTRY_JNDI_NAME, SecurityServlet.TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME);
        }

        @Override
        public void run() {
            super.run();
            ++this.count;
        }
    }

    public static class CounterRunnableWithSecurityCheck
    implements Runnable {
        private volatile int count = 0;
        private SecurityTestInterface str;

        CounterRunnableWithSecurityCheck(SecurityTestInterface str) {
            this.str = str;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void run() {
            try {
                Assert.assertEquals((String)this.str.managerMethod1(), (String)"ok");
            }
            catch (Exception e) {
                return;
            }
            ++this.count;
        }
    }
}

