/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework;

import ee.jakarta.tck.concurrent.common.CommonTasks;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.common.fixed.counter.CounterCallableTask;
import ee.jakarta.tck.concurrent.common.managedTaskListener.ManagedTaskListenerImpl;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.signaturetest.SigTestEE;
import ee.jakarta.tck.concurrent.spi.context.IntContextProvider;
import java.lang.reflect.Method;
import org.jboss.arquillian.testng.Arquillian;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class ArquillianTests
extends Arquillian {
    private static final TestLogger log = TestLogger.get(ArquillianTests.class);
    protected String testName;

    protected static final Package getFrameworkPackage() {
        return ArquillianTests.class.getPackage();
    }

    protected static final Package getCommonPackage() {
        return CommonTasks.class.getPackage();
    }

    protected static final Package getCommonCounterPackage() {
        return ee.jakarta.tck.concurrent.common.counter.CounterCallableTask.class.getPackage();
    }

    protected static final Package getCommonFixedCounterPackage() {
        return CounterCallableTask.class.getPackage();
    }

    protected static final Package getCommonManagedTaskListener() {
        return ManagedTaskListenerImpl.class.getPackage();
    }

    protected static final Package getContextPackage() {
        return StringContext.class.getPackage();
    }

    protected static final Package getContextProvidersPackage() {
        return IntContextProvider.class.getPackage();
    }

    protected static final Package getSignaturePackage() {
        return SigTestEE.class.getPackage();
    }

    protected void setupFailure(Throwable t) {
        Assert.fail((String)"Failed during setup due to an exception", (Throwable)t);
    }

    protected void cleanupFailure(Throwable t) {
        Assert.fail((String)"Failed during cleanup due to an exception", (Throwable)t);
    }

    @BeforeMethod(groups={"arquillian"}, inheritGroups=true)
    public void testServerTestEntry(Method testMethod) throws Exception {
        this.testName = testMethod.getName();
        log.enter(testMethod, this.testName);
    }

    @AfterMethod(groups={"arquillian"}, inheritGroups=true, alwaysRun=true)
    public void testServerTestExit(Method testMethod) throws Exception {
        this.testName = null;
        log.exit(testMethod, this.testName);
    }

    protected void assertTrue(boolean isTrue) {
        Assert.assertTrue((boolean)isTrue, (String)(this.testName + " failed"));
    }

    protected void assertTrue(String message, boolean isTrue) {
        Assert.assertTrue((boolean)isTrue, (String)message);
    }

    protected void assertFalse(boolean isFalse) {
        Assert.assertFalse((boolean)isFalse, (String)(this.testName + " failed"));
    }

    protected void assertFalse(String message, boolean isFalse) {
        Assert.assertFalse((boolean)isFalse, (String)message);
    }

    protected void assertEquals(String message, int expected, int actual) {
        Assert.assertEquals((int)actual, (int)expected, (String)message);
    }

    protected void assertEquals(String message, String expected, String actual) {
        Assert.assertEquals((String)actual, (String)expected, (String)message);
    }

    protected void assertNull(Object obj) {
        Assert.assertNull((Object)obj, (String)(this.testName + " failed the task should return null result, actual result=" + obj));
    }

    protected void assertNull(String message, Object obj) {
        Assert.assertNull((Object)obj, (String)message);
    }

    protected void assertNotNull(Object obj) {
        Assert.assertNotNull((Object)obj, (String)(this.testName + " failed the task should return not null result, actual result=" + obj));
    }

    protected void assertNotNull(String message, Object obj) {
        Assert.assertNotNull((Object)obj, (String)message);
    }

    protected void fail(String message) {
        Assert.fail((String)message);
    }

    protected void fail(String message, Throwable t) {
        Assert.fail((String)message, (Throwable)t);
    }

    protected void fail(Throwable t) {
        Assert.fail((String)(this.testName + " failed due to an exception"), (Throwable)t);
    }

    protected void assertInRange(int value, int min, int max) {
        this.assertTrue("Expected " + value + " to be in the exclusive range ( " + min + " - " + max + " )", value > min && value < max);
    }
}

