/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.PropertiesQuestion;
import com.sun.interview.wizard.FileQuestionRenderer;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.SwingFileFilter;
import com.sun.javatest.tool.UIFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class RenderingUtilities {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    static class YesNoBox
    extends JPanel {
        private JRadioButton yesButton;
        private JRadioButton noButton;
        private ButtonGroup bgroup;

        public YesNoBox() {
            this.setLayout(new BoxLayout(this, 0));
            this.bgroup = new ButtonGroup();
            this.yesButton = new JRadioButton("Yes");
            this.noButton = new JRadioButton("No");
            this.bgroup.add(this.yesButton);
            this.bgroup.add(this.noButton);
            this.add(this.yesButton);
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.add(this.noButton);
        }

        public String getValue() {
            if (this.yesButton.isSelected()) {
                return "Yes";
            }
            return "No";
        }

        public void selectYes(boolean value) {
            this.yesButton.setSelected(value);
            this.noButton.setSelected(!value);
        }
    }

    public static class PropCellRenderer
    extends DefaultTableCellRenderer {
        PropertiesQuestion q;
        JCheckBox jCheckBox;
        YesNoBox yesNoBox;
        JComboBox jComboBox;

        PropCellRenderer(PropertiesQuestion q) {
            this.q = q;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1) {
                String keyName = this.q.getKeyPropertyName((String)table.getValueAt(row, 0));
                PropertiesQuestion.ValueConstraints constraints = this.q.getConstraints(keyName);
                if (constraints instanceof PropertiesQuestion.BooleanConstraints) {
                    if (((PropertiesQuestion.BooleanConstraints)constraints).isYesNo()) {
                        this.yesNoBox = new YesNoBox();
                        this.yesNoBox.selectYes("Yes".equals(value));
                        return this.yesNoBox;
                    }
                    this.jCheckBox = new JCheckBox();
                    this.jCheckBox.setSelected("True".equals(value));
                    return this.jCheckBox;
                }
                this.jComboBox = new JComboBox();
                this.jComboBox.addItem(value);
                this.jComboBox.setEditable(true);
                if (this.q.isValueValid(this.q.getKeyPropertyName((String)table.getValueAt(row, 0))) != null) {
                    this.jComboBox.setBorder(new LineBorder(Color.RED, 2));
                }
                return this.jComboBox;
            }
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setBackground(UIFactory.Colors.WINDOW_BACKGROUND.getValue());
            ((DefaultTableCellRenderer)c).setHorizontalAlignment(4);
            return c;
        }

        public PropertiesQuestion getQuestion() {
            return this.q;
        }
    }

    public static class PropCellEditor
    extends DefaultCellEditor {
        private PropertiesQuestion question;
        private PropertiesQuestion.ValueConstraints rules;
        private JCheckBox jCheckBox;
        private YesNoBox yesNoBox;

        protected PropCellEditor(JComboBox box) {
            super(box);
        }

        PropCellEditor(JComboBox box, PropertiesQuestion q) {
            this(box);
            this.question = q;
        }

        PropCellEditor(JComboBox box, PropertiesQuestion.ValueConstraints rules) {
            this(box);
            this.rules = rules;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.rules != null && this.rules instanceof PropertiesQuestion.BooleanConstraints) {
                if (((PropertiesQuestion.BooleanConstraints)this.rules).isYesNo()) {
                    return this.yesNoBox.getValue();
                }
                return this.jCheckBox.isSelected() ? "True" : "False";
            }
            return super.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, final int row, final int column) {
            String valid;
            int columns = table.getColumnCount();
            Object[] values = new Object[columns];
            for (int i = 0; i < columns; ++i) {
                values[i] = table.getValueAt(row, i);
            }
            String key = this.question.getConstraintKeyFromRow(values);
            this.rules = this.question.getConstraints(key);
            if (this.rules instanceof PropertiesQuestion.BooleanConstraints) {
                if (((PropertiesQuestion.BooleanConstraints)this.rules).isYesNo()) {
                    if (this.yesNoBox == null) {
                        this.yesNoBox = new YesNoBox();
                    }
                    this.yesNoBox.selectYes("Yes".equals(value));
                    return this.yesNoBox;
                }
                if (this.jCheckBox == null) {
                    this.jCheckBox = new JCheckBox();
                }
                this.jCheckBox.setSelected("True".equals(value));
                return this.jCheckBox;
            }
            final JComboBox cb = (JComboBox)this.getComponent();
            cb.setEditable(true);
            cb.removeAllItems();
            cb.addItem(value);
            cb.setSelectedIndex(0);
            if (this.rules != null) {
                this.setConstraints(cb, this.rules);
            }
            if ((valid = this.question.isValueValid(key)) != null) {
                cb.setToolTipText(valid);
            } else {
                cb.setBackground(Color.WHITE);
            }
            if (!(this.rules instanceof PropertiesQuestion.FilenameConstraints)) {
                return cb;
            }
            final PropertiesQuestion.FilenameConstraints fc = (PropertiesQuestion.FilenameConstraints)this.rules;
            JPanel p = new JPanel();
            p.setName("filename field");
            p.setFocusable(false);
            p.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 21;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridy = 0;
            p.add((Component)cb, gbc);
            gbc.fill = 0;
            final JButton browseBtn = new JButton("...");
            final JFileChooser chooser = FileQuestionRenderer.createChooser(key, fc.getFilters());
            File f = new File((String)cb.getSelectedItem());
            if (!f.exists()) {
                File dir = fc.getBaseDirectory();
                if (dir == null) {
                    dir = new File(System.getProperty("user.dir"));
                }
                chooser.setCurrentDirectory(dir);
            } else {
                chooser.setSelectedFile(f);
            }
            browseBtn.setName("file.browse.btn");
            browseBtn.setMnemonic(i18n.getString("file.browse.mne").charAt(0));
            browseBtn.setToolTipText(i18n.getString("file.browse.tip"));
            browseBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int opt;
                    String s = (String)cb.getSelectedItem();
                    if (s != null && s.length() > 0) {
                        File f = new File(s);
                        File baseDir = fc.getBaseDirectory();
                        if (!f.isAbsolute() && baseDir != null) {
                            f = new File(baseDir, s);
                        }
                        chooser.setSelectedFile(f);
                    }
                    if ((opt = chooser.showDialog(browseBtn, "Select")) == 0) {
                        String bp;
                        File baseDir;
                        String path = chooser.getSelectedFile().getPath();
                        FileFilter ff = SwingFileFilter.unwrap(chooser.getFileFilter());
                        if (ff != null && ff instanceof ExtensionFileFilter) {
                            ExtensionFileFilter eff = (ExtensionFileFilter)ff;
                            path = eff.ensureExtension(path);
                        }
                        if ((baseDir = fc.getBaseDirectory()) != null && path.startsWith((bp = baseDir.getPath()) + File.separatorChar)) {
                            path = path.substring(bp.length() + 1);
                        }
                        if (cb.getSelectedIndex() != -1) {
                            cb.removeItemAt(cb.getSelectedIndex());
                        }
                        cb.addItem(path);
                        cb.setSelectedItem(path);
                        table.getModel().setValueAt(path, row, column);
                    }
                }
            });
            p.add((Component)browseBtn, gbc);
            return p;
        }

        private void setConstraints(JComboBox cb, PropertiesQuestion.ValueConstraints rules) {
            if (rules instanceof PropertiesQuestion.IntConstraints) {
                PropertiesQuestion.IntConstraints intRules = (PropertiesQuestion.IntConstraints)rules;
                cb.setEditable(intRules.isCustomValuesAllowed());
                int[] sugs = intRules.getSuggestions();
                if (sugs != null) {
                    for (int i = 0; i < sugs.length; ++i) {
                        if (Integer.toString(sugs[i]).equals(cb.getItemAt(0))) continue;
                        cb.addItem(Integer.toString(sugs[i]));
                    }
                }
            } else if (rules instanceof PropertiesQuestion.FloatConstraints) {
                PropertiesQuestion.FloatConstraints fltRules = (PropertiesQuestion.FloatConstraints)rules;
                float[] sugs = fltRules.getSuggestions();
                cb.setEditable(fltRules.isCustomValuesAllowed());
                if (sugs != null) {
                    for (int i = 0; i < sugs.length; ++i) {
                        if (Float.toString(sugs[i]).equals(cb.getItemAt(0))) continue;
                        cb.addItem(Float.toString(sugs[i]));
                    }
                }
            } else if (rules instanceof PropertiesQuestion.StringConstraints) {
                PropertiesQuestion.StringConstraints strRules = (PropertiesQuestion.StringConstraints)rules;
                cb.setEditable(strRules.isCustomValuesAllowed());
                String[] sugs = strRules.getSuggestions();
                if (sugs != null) {
                    if (strRules.isCustomValuesAllowed()) {
                        for (int i = 0; i < sugs.length; ++i) {
                            if (sugs[i].equals(cb.getItemAt(0))) continue;
                            cb.addItem(sugs[i]);
                        }
                    } else {
                        this.configureSet(cb, sugs, true, strRules.isUnsetAllowed());
                    }
                }
            } else if (rules instanceof PropertiesQuestion.FilenameConstraints) {
                PropertiesQuestion.FilenameConstraints strRules = (PropertiesQuestion.FilenameConstraints)rules;
                cb.setEditable(true);
                File[] sugs = strRules.getSuggestions();
                if (sugs != null) {
                    for (int i = 0; i < sugs.length; ++i) {
                        if (sugs[i].getPath().equalsIgnoreCase((String)cb.getItemAt(0))) continue;
                        cb.addItem(sugs[i].getPath());
                    }
                }
            } else {
                PropertiesQuestion.ValueConstraints valueConstraints = rules;
            }
        }

        private void configureSet(JComboBox cb, String[] possible, boolean ignoreCase, boolean isUnsetAllowed) {
            int i;
            String curr = (String)cb.getItemAt(0);
            if (isUnsetAllowed) {
                cb.addItem("");
            }
            for (i = 0; i < possible.length; ++i) {
                cb.addItem(possible[i]);
            }
            for (i = 0; i < possible.length; ++i) {
                if (!this.compareStr(curr, possible[i], ignoreCase)) continue;
                cb.removeItemAt(0);
                cb.setSelectedIndex(i + (isUnsetAllowed ? 1 : 0));
                return;
            }
            cb.removeItemAt(0);
            cb.setSelectedIndex(0);
        }

        private boolean compareStr(String s1, String s2, boolean ignoreCase) {
            if (ignoreCase) {
                return s1.equalsIgnoreCase(s2);
            }
            return s1.equals(s2);
        }
    }

    static class RestrainedCellEditor
    extends DefaultCellEditor {
        private PropertiesQuestion q;

        protected RestrainedCellEditor(JTextField tf, PropertiesQuestion q) {
            super(tf);
            this.q = q;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int columns = table.getColumnCount();
            Object[] values = new Object[columns];
            for (int i = 0; i < columns; ++i) {
                values[i] = table.getValueAt(row, i);
            }
            String key = this.q.getConstraintKeyFromRow(values);
            PropertiesQuestion.ValueConstraints vc = this.q.getConstraints(key);
            JTextField tf = (JTextField)this.getComponent();
            tf.setText(value.toString());
            tf.setFocusable(false);
            if (vc instanceof PropertiesQuestion.IntConstraints) {
                PropertiesQuestion.IntConstraints ic = (PropertiesQuestion.IntConstraints)vc;
                tf.setEditable(ic.isCustomValuesAllowed());
            }
            if (vc instanceof PropertiesQuestion.StringConstraints) {
                PropertiesQuestion.StringConstraints sc = (PropertiesQuestion.StringConstraints)vc;
                tf.setEditable(sc.isCustomValuesAllowed());
            }
            if (vc instanceof PropertiesQuestion.FloatConstraints) {
                PropertiesQuestion.FloatConstraints fc = (PropertiesQuestion.FloatConstraints)vc;
                tf.setEditable(fc.isCustomValuesAllowed());
            }
            return tf;
        }
    }

    public static class PCE
    implements TableCellEditor {
        private DefaultCellEditor cbCE;
        private DefaultCellEditor tfCE;
        private DefaultCellEditor delegate;
        private PropertiesQuestion q;

        public PCE(PropertiesQuestion q) {
            this.cbCE = new PropCellEditor(new JComboBox(), q);
            this.tfCE = new RestrainedCellEditor(new JTextField(), q);
            this.q = q;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.assignDelegate(table, row, column);
            return this.delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public static boolean gotChoice(PropertiesQuestion.ValueConstraints vc) {
            PropertiesQuestion.StringConstraints sc;
            PropertiesQuestion.FloatConstraints fc;
            PropertiesQuestion.IntConstraints ic;
            if (vc == null) {
                return false;
            }
            if (vc.isUnsetAllowed()) {
                return true;
            }
            if (vc instanceof PropertiesQuestion.IntConstraints && ((ic = (PropertiesQuestion.IntConstraints)vc).getSuggestions() == null || ic.getSuggestions().length == 0 || ic.getUpperBound() == ic.getLowerBound() || ic.getSuggestions().length == 1 && !ic.isCustomValuesAllowed())) {
                return false;
            }
            if (vc instanceof PropertiesQuestion.FloatConstraints && ((fc = (PropertiesQuestion.FloatConstraints)vc).getSuggestions() == null || fc.getSuggestions().length == 0 || fc.getUpperBound() == fc.getLowerBound() || fc.getSuggestions().length == 1 && !fc.isCustomValuesAllowed())) {
                return false;
            }
            return !(vc instanceof PropertiesQuestion.StringConstraints) || (sc = (PropertiesQuestion.StringConstraints)vc).getSuggestions() != null && sc.getSuggestions().length != 0 && (sc.getSuggestions().length != 1 || sc.isCustomValuesAllowed());
        }

        private void assignDelegate(JTable table, int row, int column) {
            int columns = table.getColumnCount();
            Object[] values = new Object[columns];
            for (int i = 0; i < columns; ++i) {
                values[i] = table.getValueAt(row, i);
            }
            String key = this.q.getConstraintKeyFromRow(values);
            this.delegate = PCE.gotChoice(this.q.getConstraints(key)) ? this.cbCE : this.tfCE;
        }

        @Override
        public Object getCellEditorValue() {
            return this.delegate.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.delegate == null || this.delegate.isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.delegate.shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.delegate.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.delegate.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.delegate.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.delegate.removeCellEditorListener(l);
        }
    }
}

