/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema.parser;

import com.sun.tools.xjc.ConsoleErrorReporter;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.reader.xmlschema.parser.LSInputSAXWrapper;
import com.sun.tools.xjc.reader.xmlschema.parser.Messages;
import com.sun.tools.xjc.util.ErrorReceiverFilter;
import com.sun.xml.bind.v2.util.XmlFactory;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaConstraintChecker {
    public static boolean check(InputSource[] schemas, ErrorReceiver errorHandler, final EntityResolver entityResolver, boolean disableXmlSecurity) {
        ErrorReceiverFilter errorFilter = new ErrorReceiverFilter(errorHandler);
        boolean hadErrors = false;
        SchemaFactory sf = XmlFactory.createSchemaFactory("http://www.w3.org/2001/XMLSchema", disableXmlSecurity);
        sf.setErrorHandler(errorFilter);
        if (entityResolver != null) {
            sf.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    try {
                        InputSource is = entityResolver.resolveEntity(namespaceURI, systemId);
                        if (is == null) {
                            return null;
                        }
                        return new LSInputSAXWrapper(is);
                    }
                    catch (SAXException e) {
                        return null;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
        try {
            sf.newSchema(SchemaConstraintChecker.getSchemaSource(schemas, entityResolver));
        }
        catch (SAXException e) {
            hadErrors = true;
        }
        catch (OutOfMemoryError e) {
            errorHandler.warning(null, Messages.format("SchemaConstraintChecker.UnableToCheckCorrectness", new Object[0]));
        }
        return !hadErrors && !errorFilter.hadError();
    }

    private static Source[] getSchemaSource(InputSource[] schemas, EntityResolver entityResolver) throws SAXException {
        Source[] sources = new SAXSource[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            sources[i] = new SAXSource(schemas[i]);
        }
        return sources;
    }

    public static void main(String[] args) throws IOException {
        InputSource[] sources = new InputSource[args.length];
        for (int i = 0; i < args.length; ++i) {
            sources[i] = new InputSource(new File(args[i]).toURL().toExternalForm());
        }
        SchemaConstraintChecker.check(sources, new ConsoleErrorReporter(), null, true);
    }
}

