/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import greycat.Graph;
import greycat.Node;
import greycat.plugin.NodeState;
import greycat.plugin.Resolver;
import greycat.struct.DoubleArray;
import greycat.struct.IntArray;
import greycat.struct.LongArray;
import greycat.struct.Relation;
import greycat.struct.StringArray;
import greycat.struct.StringIntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.hawk.core.graph.EmptyIGraphIterable;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.greycat.AbstractGreycatDatabase;
import org.eclipse.hawk.greycat.GreycatHeavyEdge;
import org.eclipse.hawk.greycat.GreycatLightEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreycatNode
implements ITimeAwareGraphNode {
    private int nestingLevel = 0;
    private static final String ATTRIBUTE_PREFIX = "a_";
    private static final String JAVATYPE_PROPERTY = "h_javatypes";
    private static final BiMap<String, Integer> javaTypes = HashBiMap.create();
    private static final String EMPTY_STRING_MARKER = "_@_h_empty_@_";
    private static final Logger LOGGER;
    private final AbstractGreycatDatabase db;
    private final long world;
    private final long time;
    private final long id;
    private final NodeProvider nodeProvider;
    private String nodeLabel;

    static {
        int counter = 0;
        for (Class klass : Arrays.asList(Float.class, Double[].class, Float[].class, Long[].class, Integer[].class, Short[].class, Byte[].class, double[].class, float[].class, long[].class, int[].class, short[].class, byte[].class)) {
            javaTypes.put((Object)klass.getSimpleName(), (Object)counter++);
        }
        LOGGER = LoggerFactory.getLogger(GreycatNode.class);
    }

    protected static int getValueType(Object value) {
        if (value == null) {
            return 2;
        }
        switch (value.getClass().getSimpleName()) {
            case "boolean": 
            case "Boolean": {
                return 1;
            }
            case "Integer": 
            case "Byte": 
            case "Short": {
                return 4;
            }
            case "Long": {
                return 3;
            }
            case "Float": 
            case "Double": {
                return 5;
            }
            case "String": {
                return 2;
            }
        }
        LOGGER.warn("Unknown type: {}, returning Type.STRING", (Object)value.getClass().getSimpleName());
        return 2;
    }

    public GreycatNode(AbstractGreycatDatabase db, long world, long time, long id, Node node) {
        this.db = db;
        this.world = world;
        this.time = time;
        this.id = id;
        this.nodeProvider = new NodeProvider(db.getGraph(), node);
    }

    public Long getId() {
        return this.id;
    }

    public long getWorld() {
        return this.world;
    }

    public long getTime() {
        return this.time;
    }

    public void end() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            for (IGraphEdge out : this.travelInTime(this.time + 1L).getOutgoing()) {
                out.delete();
            }
            for (IGraphEdge in : this.travelInTime(this.time + 1L).getIncoming()) {
                in.delete();
            }
            this.db.luceneIndexer.remove(this.travelInTime(this.time + 1L));
            rn.get().end();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public GreycatNode travelInTime(long time) {
        if (time == -1L) {
            return null;
        }
        return this.db.lookup(this.world, time, this.id);
    }

    public String getNodeLabel() {
        if (this.nodeLabel == null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (NodeReader rn = this.getNodeReader();){
                this.nodeLabel = rn.get().get("h_nodeLabel").toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.nodeLabel;
    }

    public Set<String> getPropertyKeys() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            Node n = rn.get();
            Resolver resolver = n.graph().resolver();
            NodeState state = resolver.resolveState(n);
            HashSet<String> results = new HashSet<String>();
            state.each((attributeKey, elemType, elem) -> {
                String resolveName = resolver.hashToString(attributeKey);
                if (resolveName != null && resolveName.startsWith(ATTRIBUTE_PREFIX)) {
                    results.add(resolveName.substring(ATTRIBUTE_PREFIX.length()));
                }
            });
            return results;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected NodeReader getNodeReader() {
        return new NodeReader();
    }

    public boolean isAlive() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            boolean bl = rn.get() != null;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object getProperty(String name) {
        Throwable throwable = null;
        Object var4_4 = null;
        try (NodeReader rn = this.getNodeReader();){
            Object rawValue;
            block74: {
                block72: {
                    rawValue = rn.get().get(ATTRIBUTE_PREFIX + name);
                    if (rawValue instanceof StringArray) {
                        return ((StringArray)rawValue).extract();
                    }
                    if (rawValue instanceof LongArray) {
                        int javaTypeID = this.getJavaTypesMap(rn).getValue(name);
                        String javaType = (String)javaTypes.inverse().get((Object)javaTypeID);
                        LongArray lArray = (LongArray)rawValue;
                        if ("Long[]".equals(javaType)) {
                            Long[] ret = new Long[lArray.size()];
                            int i = 0;
                            while (i < lArray.size()) {
                                ret[i] = lArray.get(i);
                                ++i;
                            }
                            return ret;
                        }
                        return lArray.extract();
                    }
                    if (!(rawValue instanceof DoubleArray)) break block72;
                    int javaTypeID = this.getJavaTypesMap(rn).getValue(name);
                    String javaType = (String)javaTypes.inverse().get((Object)javaTypeID);
                    DoubleArray dArray = (DoubleArray)rawValue;
                    switch (javaType) {
                        case "Double[]": {
                            Double[] ret = new Double[dArray.size()];
                            int i = 0;
                            while (i < dArray.size()) {
                                ret[i] = dArray.get(i);
                                ++i;
                            }
                            return ret;
                        }
                        case "Float[]": {
                            Float[] ret = new Float[dArray.size()];
                            int i = 0;
                            while (i < dArray.size()) {
                                ret[i] = Float.valueOf((float)dArray.get(i));
                                ++i;
                            }
                            return ret;
                        }
                        case "float[]": {
                            float[] ret = new float[dArray.size()];
                            int i = 0;
                            while (i < dArray.size()) {
                                ret[i] = (float)dArray.get(i);
                                ++i;
                            }
                            return ret;
                        }
                    }
                    return dArray.extract();
                }
                if (!(rawValue instanceof IntArray)) break block74;
                int javaTypeID = this.getJavaTypesMap(rn).getValue(name);
                String javaType = (String)javaTypes.inverse().get((Object)javaTypeID);
                IntArray iArray = (IntArray)rawValue;
                switch (javaType) {
                    case "Integer[]": {
                        Integer[] ret = new Integer[iArray.size()];
                        int i = 0;
                        while (i < iArray.size()) {
                            ret[i] = iArray.get(i);
                            ++i;
                        }
                        return ret;
                    }
                    case "Short[]": {
                        Short[] ret = new Short[iArray.size()];
                        int i = 0;
                        while (i < iArray.size()) {
                            ret[i] = (short)iArray.get(i);
                            ++i;
                        }
                        return ret;
                    }
                    case "short[]": {
                        short[] ret = new short[iArray.size()];
                        int i = 0;
                        while (i < iArray.size()) {
                            ret[i] = (short)iArray.get(i);
                            ++i;
                        }
                        return ret;
                    }
                    case "Byte[]": {
                        Byte[] ret = new Byte[iArray.size()];
                        int i = 0;
                        while (i < iArray.size()) {
                            ret[i] = (byte)iArray.get(i);
                            ++i;
                        }
                        return ret;
                    }
                    case "byte[]": {
                        byte[] ret = new byte[iArray.size()];
                        int i = 0;
                        while (i < iArray.size()) {
                            ret[i] = (byte)iArray.get(i);
                            ++i;
                        }
                        return ret;
                    }
                }
                return iArray.extract();
            }
            if (rawValue instanceof Double) {
                int javaTypeID = this.getJavaTypesMap(rn).getValue(name);
                String javaType = (String)javaTypes.inverse().get((Object)javaTypeID);
                if ("Float".equals(javaType)) {
                    return Float.valueOf(((Double)rawValue).floatValue());
                }
            } else if (EMPTY_STRING_MARKER.equals(rawValue)) {
                return "";
            }
            return rawValue;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setProperty(String name, Object value) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (NodeReader rn = this.getNodeReader();){
            this.setPropertyRaw(rn, name, value);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setProperties(Map<String, Object> props) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (NodeReader rn = this.getNodeReader();){
            this.setPropertiesRaw(rn, props);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void setPropertiesRaw(NodeReader rn, Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            this.setPropertyRaw(rn, entry.getKey(), entry.getValue());
        }
    }

    protected void setPropertyRaw(NodeReader rn, String name, Object value) {
        if (value != null && value.getClass().isArray()) {
            this.setArrayPropertyRaw(rn, name, value);
        } else if (value instanceof Float) {
            this.getJavaTypesMap(rn).put(name, ((Integer)javaTypes.get((Object)value.getClass().getSimpleName())).intValue());
            rn.get().set(ATTRIBUTE_PREFIX + name, 5, value);
        } else {
            this.getJavaTypesMap(rn).remove(name);
            if ("".equals(value)) {
                value = EMPTY_STRING_MARKER;
            }
            rn.get().set(ATTRIBUTE_PREFIX + name, GreycatNode.getValueType(value), value);
        }
        rn.markDirty();
    }

    protected void setArrayPropertyRaw(NodeReader rn, String name, Object value) {
        String javaType = value.getClass().getSimpleName();
        Integer javaTypeID = (Integer)javaTypes.get((Object)javaType);
        if (javaTypeID != null) {
            StringIntMap arrayTypes = this.getJavaTypesMap(rn);
            arrayTypes.put(name, javaTypeID.intValue());
        }
        Node n = rn.get();
        block15 : switch (javaType) {
            case "float[]": 
            case "Float[]": 
            case "double[]": 
            case "Double[]": {
                DoubleArray dArray = (DoubleArray)n.getOrCreate(ATTRIBUTE_PREFIX + name, 6);
                dArray.clear();
                switch (javaType) {
                    case "Double[]": {
                        Double[] doubleArray = (Double[])value;
                        int n2 = doubleArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Double d = doubleArray[n3];
                            if (d != null) {
                                dArray.addElement(d.doubleValue());
                            }
                            ++n3;
                        }
                        break block15;
                    }
                    case "double[]": {
                        double[] dArray2 = (double[])value;
                        int n4 = dArray2.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            double d = dArray2[n5];
                            dArray.addElement(d);
                            ++n5;
                        }
                        break block15;
                    }
                    case "Float[]": {
                        Float[] floatArray = (Float[])value;
                        int n6 = floatArray.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            Float f = floatArray[n7];
                            if (f != null) {
                                dArray.addElement((double)f.floatValue());
                            }
                            ++n7;
                        }
                        break block15;
                    }
                    case "float[]": {
                        float[] fArray = (float[])value;
                        int n8 = fArray.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            float f = fArray[n9];
                            dArray.addElement((double)f);
                            ++n9;
                        }
                        break block27;
                    }
                }
                break;
            }
            case "Long[]": 
            case "long[]": {
                LongArray lArray = (LongArray)n.getOrCreate(ATTRIBUTE_PREFIX + name, 7);
                lArray.clear();
                if ("Long".equals(javaType)) {
                    Long[] longArray = (Long[])value;
                    int n10 = longArray.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        long l = longArray[n11];
                        lArray.addElement(l);
                        ++n11;
                    }
                } else {
                    long[] lArray2 = (long[])value;
                    int n12 = lArray2.length;
                    int n13 = 0;
                    while (n13 < n12) {
                        long l = lArray2[n13];
                        lArray.addElement(l);
                        ++n13;
                    }
                }
                break;
            }
            case "Integer[]": 
            case "byte[]": 
            case "Short[]": 
            case "int[]": 
            case "Byte[]": 
            case "short[]": {
                IntArray iArray = (IntArray)n.getOrCreate(ATTRIBUTE_PREFIX + name, 8);
                iArray.clear();
                switch (javaType) {
                    case "Integer[]": {
                        Integer[] integerArray = (Integer[])value;
                        int n14 = integerArray.length;
                        int n15 = 0;
                        while (n15 < n14) {
                            Integer i = integerArray[n15];
                            if (i != null) {
                                iArray.addElement(i.intValue());
                            }
                            ++n15;
                        }
                        break block15;
                    }
                    case "int[]": {
                        int[] nArray = (int[])value;
                        int n16 = nArray.length;
                        int n17 = 0;
                        while (n17 < n16) {
                            int i = nArray[n17];
                            iArray.addElement(i);
                            ++n17;
                        }
                        break block15;
                    }
                    case "Short[]": {
                        Short[] shortArray = (Short[])value;
                        int n18 = shortArray.length;
                        int n19 = 0;
                        while (n19 < n18) {
                            Short i = shortArray[n19];
                            if (i != null) {
                                iArray.addElement((int)i.shortValue());
                            }
                            ++n19;
                        }
                        break block15;
                    }
                    case "short[]": {
                        short[] sArray = (short[])value;
                        int n20 = sArray.length;
                        int n21 = 0;
                        while (n21 < n20) {
                            short i = sArray[n21];
                            iArray.addElement((int)i);
                            ++n21;
                        }
                        break block15;
                    }
                    case "Byte[]": {
                        Byte[] byteArray = (Byte[])value;
                        int n22 = byteArray.length;
                        int n23 = 0;
                        while (n23 < n22) {
                            Byte i = byteArray[n23];
                            if (i != null) {
                                iArray.addElement((int)i.byteValue());
                            }
                            ++n23;
                        }
                        break block15;
                    }
                    case "byte[]": {
                        byte[] byArray = (byte[])value;
                        int n24 = byArray.length;
                        int n25 = 0;
                        while (n25 < n24) {
                            byte i = byArray[n25];
                            iArray.addElement((int)i);
                            ++n25;
                        }
                        break block41;
                    }
                }
                break;
            }
            case "String[]": {
                StringArray sArray = (StringArray)n.getOrCreate(ATTRIBUTE_PREFIX + name, 9);
                sArray.clear();
                sArray.addAll((String[])value);
            }
        }
    }

    protected StringIntMap getJavaTypesMap(NodeReader rn) {
        StringIntMap value = (StringIntMap)rn.get().get(JAVATYPE_PROPERTY);
        if (value == null) {
            value = (StringIntMap)rn.get().getOrCreate(JAVATYPE_PROPERTY, 12);
            rn.markDirty();
        }
        return value;
    }

    public Iterable<IGraphEdge> getEdges() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            return this.getAllEdges(rn, this.getAllEdges(rn, new ArrayList<IGraphEdge>(), Direction.OUT), Direction.IN);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IGraphIterable<IGraphEdge> getEdgesWithType(String type) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (NodeReader rn = this.getNodeReader();){
            final IGraphIterable<IGraphEdge> inEdges = this.getEdgesWithType(rn, Direction.IN, type);
            final IGraphIterable<IGraphEdge> outEdges = this.getEdgesWithType(rn, Direction.OUT, type);
            return new IGraphIterable<IGraphEdge>(){

                public Iterator<IGraphEdge> iterator() {
                    return Iterators.concat((Iterator)inEdges.iterator(), (Iterator)outEdges.iterator());
                }

                public int size() {
                    return inEdges.size() + outEdges.size();
                }

                public IGraphEdge getSingle() {
                    if (inEdges.size() > 0) {
                        return (IGraphEdge)inEdges.getSingle();
                    }
                    return (IGraphEdge)outEdges.getSingle();
                }
            };
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IGraphIterable<IGraphEdge> getOutgoingWithType(String type) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (NodeReader rn = this.getNodeReader();){
            return this.getEdgesWithType(rn, Direction.OUT, type);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IGraphIterable<IGraphEdge> getIncomingWithType(String type) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (NodeReader rn = this.getNodeReader();){
            return this.getEdgesWithType(rn, Direction.IN, type);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected IGraphIterable<IGraphEdge> getEdgesWithType(NodeReader rn, final Direction dir, final String type) {
        int relationPosition = this.db.getGraph().resolver().stringToHash(String.valueOf(dir.getPrefix()) + type, false);
        final Relation relation = (Relation)rn.get().getAt(relationPosition);
        if (relation == null) {
            return new EmptyIGraphIterable();
        }
        final int nEdges = relation.size();
        return new IGraphIterable<IGraphEdge>(){

            public Iterator<IGraphEdge> iterator() {
                return Iterators.transform((Iterator)IntStream.range(0, nEdges).iterator(), i -> {
                    long nodeId = relation.get(i.intValue());
                    GreycatNode target = GreycatNode.this.db.lookup(GreycatNode.this.world, GreycatNode.this.time, nodeId);
                    return dir.convertToEdge(type, GreycatNode.this, target);
                });
            }

            public int size() {
                return relation.size();
            }

            public IGraphEdge getSingle() {
                long nodeId = relation.get(0);
                GreycatNode target = GreycatNode.this.db.lookup(GreycatNode.this.world, GreycatNode.this.time, nodeId);
                return dir.convertToEdge(type, GreycatNode.this, target);
            }
        };
    }

    public Iterable<IGraphEdge> getIncoming() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            return this.getAllEdges(rn, new ArrayList<IGraphEdge>(), Direction.IN);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Iterable<IGraphEdge> getOutgoing() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            return this.getAllEdges(rn, new ArrayList<IGraphEdge>(), Direction.OUT);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected List<IGraphEdge> getAllEdges(NodeReader rn, List<IGraphEdge> results, Direction dir) {
        Node n = rn.get();
        Resolver resolver = n.graph().resolver();
        NodeState state = resolver.resolveState(n);
        String prefix = dir.getPrefix();
        state.each((attributeKey, elemType, elem) -> {
            String resolveName;
            if (elemType == 13 && (resolveName = resolver.hashToString(attributeKey)).startsWith(prefix)) {
                String edgeType = resolveName.substring(prefix.length());
                Relation castedRelArr = (Relation)elem;
                int j = 0;
                while (j < castedRelArr.size()) {
                    GreycatNode targetNode = this.db.lookup(this.world, this.time, castedRelArr.get(j));
                    results.add(dir.convertToEdge(edgeType, this, targetNode));
                    ++j;
                }
            }
        });
        return results;
    }

    public void delete() {
        if (this.db.currentMode() == IGraphDatabase.Mode.NO_TX_MODE) {
            CompletableFuture cSaved = new CompletableFuture();
            this.db.hardDelete(this, dropped -> {
                boolean bl = cSaved.complete(true);
            });
            cSaved.join();
        } else {
            this.db.softDelete(this);
        }
    }

    public AbstractGreycatDatabase getGraph() {
        return this.db;
    }

    public void removeProperty(String name) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (NodeReader rn = this.getNodeReader();){
            rn.get().remove(ATTRIBUTE_PREFIX + name);
            rn.markDirty();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.nodeProvider.free();
    }

    protected boolean isSoftDeleted() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            Boolean softDeleted = (Boolean)rn.get().get("h_softDeleted");
            boolean bl = softDeleted == Boolean.TRUE;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected IGraphEdge addEdge(String type, GreycatNode end, Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return GreycatLightEdge.create(type, this, end);
        }
        return GreycatHeavyEdge.create(type, this, end, props);
    }

    protected static void addOutgoing(String type, NodeReader rn, NodeReader ro) {
        rn.get().addToRelation(String.valueOf(Direction.OUT.getPrefix()) + type, ro.get());
        rn.markDirty();
    }

    protected static void addIncoming(String type, NodeReader rn, NodeReader ro) {
        rn.get().addToRelation(String.valueOf(Direction.IN.getPrefix()) + type, ro.get());
        rn.markDirty();
    }

    protected static void removeOutgoing(String type, NodeReader rn, NodeReader ro) {
        rn.get().removeFromRelation(String.valueOf(Direction.OUT.getPrefix()) + type, ro.get());
        rn.markDirty();
    }

    protected static void removeIncoming(String type, NodeReader rn, NodeReader ro) {
        rn.get().removeFromRelation(String.valueOf(Direction.IN.getPrefix()) + type, ro.get());
        rn.markDirty();
    }

    public String toString() {
        return "GreycatNode [world=" + this.world + ", time=" + this.time + ", id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (int)(this.world ^ this.world >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GreycatNode other = (GreycatNode)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        return this.world == other.world;
    }

    public long getLatestInstant() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            Node n = rn.get();
            CompletableFuture result = new CompletableFuture();
            n.timepoints(-9007199254740990L, 0x1FFFFFFFFFFFFEL, value -> result.complete(value));
            long latest = -9007199254740990L;
            long[] lArray = (long[])result.get();
            int n2 = lArray.length;
            int n3 = 0;
            while (n3 < n2) {
                long timepoint = lArray[n3];
                latest = Math.max(latest, timepoint);
                ++n3;
            }
            return latest;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<Long> getInstantsBetween(long fromInclusive, long toInclusive) {
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (NodeReader rn = this.getNodeReader();){
                Node n = rn.get();
                CompletableFuture result = new CompletableFuture();
                n.timepoints(fromInclusive, toInclusive < 0x1FFFFFFFFFFFFEL ? toInclusive + 1L : toInclusive, value -> result.complete(value));
                ArrayList<Long> instants = new ArrayList<Long>();
                long[] lArray = (long[])result.get();
                int n2 = lArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    long instant = lArray[n3];
                    instants.add(instant);
                    ++n3;
                }
                return instants;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public long getEarliestInstant() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            Node n = rn.get();
            CompletableFuture result = new CompletableFuture();
            n.timepoints(-9007199254740990L, 0x1FFFFFFFFFFFFEL, value -> result.complete(value));
            long earliest = 0x1FFFFFFFFFFFFEL;
            long[] lArray = (long[])result.get();
            int n2 = lArray.length;
            int n3 = 0;
            while (n3 < n2) {
                long timepoint = lArray[n3];
                earliest = Math.min(earliest, timepoint);
                ++n3;
            }
            return earliest;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getPreviousInstant() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            Node n = rn.get();
            CompletableFuture result = new CompletableFuture();
            n.timepoints(-9007199254740990L, this.getTime(), value -> {
                boolean bl = result.complete(value);
            });
            long[] instants = (long[])result.get();
            if (instants.length != 0) return instants[0];
            return -1L;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getNextInstant() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (NodeReader rn = this.getNodeReader();){
            Node n = rn.get();
            CompletableFuture result = new CompletableFuture();
            n.timepoints(this.getTime() + 1L, 0x1FFFFFFFFFFFFEL, value -> result.complete(value));
            long[] instants = (long[])result.get();
            if (instants.length != 0) return instants[instants.length - 1];
            return -1L;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public List<Long> getInstantsFrom(long fromInclusive) {
        return this.getInstantsBetween(fromInclusive, 0x1FFFFFFFFFFFFEL);
    }

    public List<Long> getInstantsUpTo(long toInclusive) {
        return this.getInstantsBetween(-9007199254740990L, toInclusive);
    }

    public List<Long> getAllInstants() throws Exception {
        return this.getInstantsBetween(-9007199254740990L, 0x1FFFFFFFFFFFFEL);
    }

    private static enum Direction {
        IN{

            @Override
            public String getPrefix() {
                return "in_";
            }

            @Override
            public IGraphEdge convertToEdge(String type, GreycatNode current, GreycatNode other) {
                if ("h_heavyEdge".equals(other.getNodeLabel())) {
                    return new GreycatHeavyEdge(other, type);
                }
                return new GreycatLightEdge(other, current, type);
            }
        }
        ,
        OUT{

            @Override
            public String getPrefix() {
                return "out_";
            }

            @Override
            public IGraphEdge convertToEdge(String type, GreycatNode current, GreycatNode other) {
                if ("h_heavyEdge".equals(other.getNodeLabel())) {
                    return new GreycatHeavyEdge(other, type);
                }
                return new GreycatLightEdge(current, other, type);
            }
        };


        public abstract String getPrefix();

        public abstract IGraphEdge convertToEdge(String var1, GreycatNode var2, GreycatNode var3);
    }

    private final class NodeProvider {
        private Graph _graph;
        private Node _node;

        public NodeProvider(Graph graph, Node node) {
            this._graph = graph;
            this._node = node;
        }

        public Node get() {
            if (GreycatNode.this.db.getGraph() == this._graph) {
                return this._node;
            }
            this._node.free();
            CompletableFuture result = new CompletableFuture();
            GreycatNode.this.db.getGraph().lookup(GreycatNode.this.world, GreycatNode.this.time, GreycatNode.this.id, node -> {
                boolean bl = result.complete(node);
            });
            try {
                this._node = (Node)result.get();
                this._graph = GreycatNode.this.db.getGraph();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error(String.format("Could not refetch node %d:%d:%d", GreycatNode.this.world, GreycatNode.this.time, GreycatNode.this.id), (Throwable)e);
            }
            return this._node;
        }

        public void markDirty() {
            GreycatNode.this.db.markDirty(GreycatNode.this);
        }

        public void free() {
            if (this._node != null) {
                this._node.free();
                this._node = null;
                this._graph = null;
            }
        }
    }

    protected final class NodeReader
    implements AutoCloseable,
    Supplier<Node> {
        private NodeReader() {
            GreycatNode greycatNode2 = GreycatNode.this;
            greycatNode2.nestingLevel = greycatNode2.nestingLevel + 1;
            GreycatNode.this.db.markOpen(GreycatNode.this);
        }

        @Override
        public Node get() {
            return GreycatNode.this.nodeProvider.get();
        }

        public void markDirty() {
            GreycatNode.this.nodeProvider.markDirty();
        }

        @Override
        public void close() {
            GreycatNode greycatNode = GreycatNode.this;
            int n = greycatNode.nestingLevel - 1;
            greycatNode.nestingLevel = n;
            if (n <= 0) {
                GreycatNode.this.db.markClosed(GreycatNode.this);
            }
        }
    }

    protected static class StreamIterable<T>
    implements Iterable<T> {
        private Stream<T> stream;

        protected StreamIterable(Stream<T> stream) {
            this.stream = stream;
        }

        @Override
        public Iterator<T> iterator() {
            return this.stream.iterator();
        }
    }
}

