/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui.localfolder;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.localfolder.LocalFile;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.dialog.HVCSDialog;
import org.eclipse.hawk.ui2.vcs.IVcsConfigurationBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LocalFileConfigurationBlock
implements IVcsConfigurationBlock {
    private HVCSDialog dialog;
    private Text txtVCSLocation;
    private Button btnVCSBrowse;

    public boolean isApplicableTo(IVcsManager manager) {
        return manager instanceof LocalFile;
    }

    public void createBlock(final Composite container, HVCSDialog dialog) {
        this.dialog = dialog;
        IVcsManager managerToEdit = dialog.getManagerToEdit();
        GridLayout containerLayout = new GridLayout();
        containerLayout.numColumns = 3;
        container.setLayout((Layout)containerLayout);
        Label lblLocation = new Label(container, 0);
        lblLocation.setText("Location:");
        this.txtVCSLocation = new Text(container, 2048);
        GridData txtVCSLocationLayoutData = new GridData(4, 0x1000000, true, false);
        txtVCSLocationLayoutData.widthHint = 300;
        this.txtVCSLocation.setLayoutData((Object)txtVCSLocationLayoutData);
        if (managerToEdit != null) {
            this.txtVCSLocation.setText(managerToEdit.getLocation());
            this.txtVCSLocation.setEnabled(false);
        } else {
            this.txtVCSLocation.setText(dialog.getSelectedVCSManager().getDefaultLocation());
        }
        this.txtVCSLocation.addModifyListener(e -> this.updateDialog());
        this.btnVCSBrowse = new Button(container, 8);
        GridData gridDataB = new GridData();
        this.btnVCSBrowse.setLayoutData((Object)gridDataB);
        this.btnVCSBrowse.setText("Browse...");
        this.btnVCSBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(container.getShell(), 4096);
                fd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                fd.setText("Select a file");
                String result = fd.open();
                if (result != null) {
                    LocalFileConfigurationBlock.this.txtVCSLocation.setText(result);
                }
            }
        });
        this.btnVCSBrowse.setEnabled(false);
        this.updateDialog();
    }

    public void okPressed(HModel hawkModel, boolean isFrozen) {
        String vcsType = this.dialog.getSelectedVCSManager().getClass().getName();
        String location = this.txtVCSLocation.getText();
        IVcsManager managerToEdit = this.dialog.getManagerToEdit();
        if (managerToEdit == null) {
            hawkModel.addVCS(location, vcsType, "", "", isFrozen);
        } else {
            managerToEdit.setFrozen(isFrozen);
        }
    }

    private void updateDialog() {
        if (this.dialog.getManagerToEdit() == null) {
            IVcsManager vcsManager = this.dialog.getSelectedVCSManager();
            this.btnVCSBrowse.setEnabled(vcsManager != null && vcsManager.isPathLocationAccepted());
        }
        if (!this.isLocationValid()) {
            this.dialog.setErrorMessage("The location is not valid");
        } else if (this.dialog.getSelectedVCSManager() == null) {
            this.dialog.setErrorMessage("No VCS manager type has been selected");
        } else {
            this.dialog.setErrorMessage(null);
        }
    }

    private boolean isLocationValidPath() {
        File file = new File(this.txtVCSLocation.getText());
        return file.exists() && file.isFile() && file.canRead();
    }

    private boolean isLocationValid() {
        IVcsManager vcsManager = this.dialog.getSelectedVCSManager();
        return vcsManager.isPathLocationAccepted() && this.isLocationValidPath() || vcsManager.isURLLocationAccepted() && this.isLocationValidURI();
    }

    private boolean isLocationValidURI() {
        try {
            URI uri = new URI(this.txtVCSLocation.getText());
            return uri.getScheme() != null && uri.getPath() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

