/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.remote.thrift;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.auth.Credentials;
import org.apache.thrift.transport.TTransportException;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IHawk;
import org.eclipse.hawk.core.IHawkFactory;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.HawkInstance;
import org.eclipse.hawk.service.api.HawkPlugin;
import org.eclipse.hawk.service.api.dt.http.LazyCredentials;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.remote.thrift.ThriftRemoteHawk;

public class ThriftRemoteHawkFactory
implements IHawkFactory {
    public IHawk create(String name, File parentFolder, String location, ICredentialsStore credStore, IConsole console, List<String> enabledPlugins) throws Exception {
        return new ThriftRemoteHawk(name, location, this, parentFolder, credStore, console, APIUtils.ThriftProtocol.guessFromURL((String)location), enabledPlugins);
    }

    protected String getFactoryName() {
        return null;
    }

    public boolean instancesAreExtensible() {
        return false;
    }

    public boolean instancesCreateGraph() {
        return false;
    }

    public boolean instancesUseLocation() {
        return true;
    }

    public IHawkFactory.InstanceInfo[] listInstances(String location) throws Exception {
        Hawk.Client client = this.getClient(location);
        List instances = client.listInstances();
        IHawkFactory.InstanceInfo[] infos = new IHawkFactory.InstanceInfo[instances.size()];
        int iInfo = 0;
        while (iInfo < instances.size()) {
            HawkInstance instance = (HawkInstance)instances.get(iInfo);
            IStateListener.HawkState hawkState = IStateListener.HawkState.STOPPED;
            switch (instance.state) {
                case RUNNING: {
                    hawkState = IStateListener.HawkState.RUNNING;
                    break;
                }
                case STOPPED: {
                    hawkState = IStateListener.HawkState.STOPPED;
                    break;
                }
                case UPDATING: {
                    hawkState = IStateListener.HawkState.UPDATING;
                }
            }
            infos[iInfo] = new IHawkFactory.InstanceInfo(instance.name, null, hawkState);
            ++iInfo;
        }
        return infos;
    }

    protected Hawk.Client getClient(String location) throws TTransportException, URISyntaxException {
        APIUtils.ThriftProtocol proto = APIUtils.ThriftProtocol.guessFromURL((String)location);
        Hawk.Client client = (Hawk.Client)APIUtils.connectTo(Hawk.Client.class, (String)location, (APIUtils.ThriftProtocol)proto, (Credentials)new LazyCredentials(location));
        return client;
    }

    public List<String> listBackends(String location) throws Exception {
        Hawk.Client client = this.getClient(location);
        return client.listBackends();
    }

    public List<IHawkPlugin> listPlugins(String location) throws Exception {
        Hawk.Client client = this.getClient(location);
        List thriftPlugins = client.listPluginDetails();
        ArrayList<IHawkPlugin> plugins = new ArrayList<IHawkPlugin>(thriftPlugins.size());
        for (HawkPlugin tp : thriftPlugins) {
            plugins.add(new IHawkPluginAdapter(tp));
        }
        return plugins;
    }

    public boolean isRemote() {
        return true;
    }

    public String getHumanReadableName() {
        return "Thrift-based remote Hawk";
    }

    protected class IHawkPluginAdapter
    implements IHawkPlugin {
        private final HawkPlugin tp;

        protected IHawkPluginAdapter(HawkPlugin tp) {
            this.tp = tp;
        }

        public String getType() {
            return this.tp.getName();
        }

        public String getHumanReadableName() {
            return this.tp.getDescription();
        }

        public IHawkPlugin.Category getCategory() {
            return IHawkPlugin.Category.valueOf((String)this.tp.getCategory().name());
        }
    }
}

