/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf.dt.editors;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.dt.util.ListContentProvider;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.HawkInstance;
import org.eclipse.hawk.service.api.HawkState;
import org.eclipse.hawk.service.api.Repository;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.emf.HawkModelDescriptor;
import org.eclipse.hawk.service.emf.dt.Activator;
import org.eclipse.hawk.service.emf.dt.editors.HawkMultiPageEditor;
import org.eclipse.hawk.service.emf.dt.editors.HawkMultiPageEditorContributor;
import org.eclipse.hawk.service.emf.dt.editors.Utils;
import org.eclipse.hawk.service.emf.dt.editors.fields.FormCheckBoxField;
import org.eclipse.hawk.service.emf.dt.editors.fields.FormComboBoxField;
import org.eclipse.hawk.service.emf.dt.editors.fields.FormSection;
import org.eclipse.hawk.service.emf.dt.editors.fields.FormTextField;
import org.eclipse.hawk.service.emf.impl.HawkResourceFactoryImpl;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

class DetailsFormPage
extends FormPage {
    private InstanceSection instanceSection;
    private ContentSection contentSection;
    private SubscriptionSection subscriptionSection;

    DetailsFormPage(HawkMultiPageEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
    }

    public HawkMultiPageEditor getEditor() {
        return (HawkMultiPageEditor)super.getEditor();
    }

    public boolean isEditor() {
        return true;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().setText("Remote Hawk Descriptor");
        FormToolkit toolkit = managedForm.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        Composite formBody = managedForm.getForm().getBody();
        formBody.setLayout((Layout)layout);
        final FormText formText = toolkit.createFormText(formBody, true);
        formText.setText("<form><p><a href=\"reopenEcore\">Open with Exeed</a> <a href=\"copyShortURL\">Copy short URL to clipboard</a> <a href=\"copyLongURL\">Copy long URL to clipboard</a></p></form>", true, true);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String href;
                switch (href = e.getHref().toString()) {
                    case "reopenEcore": {
                        HawkMultiPageEditorContributor.reopenWithExeed((IEditorPart)DetailsFormPage.this.getEditor());
                        break;
                    }
                    case "copyLongURL": 
                    case "copyShortURL": {
                        try {
                            String url = HawkResourceFactoryImpl.generateHawkURL((HawkModelDescriptor)DetailsFormPage.this.getEditor().buildDescriptor(), (boolean)"copyShortURL".equals(href));
                            Clipboard cb = new Clipboard(DetailsFormPage.this.getSite().getShell().getDisplay());
                            cb.setContents(new Object[]{url}, new Transfer[]{TextTransfer.getInstance()});
                            cb.dispose();
                            break;
                        }
                        catch (UnsupportedEncodingException ex) {
                            Activator.getDefault().logError(ex);
                        }
                    }
                }
            }
        });
        this.instanceSection = new InstanceSection(toolkit, formBody){

            @Override
            protected void instanceNameChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void serverURLChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void thriftProtocolChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void usernameChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void passwordChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void selectInstance() {
                HawkModelDescriptor d = DetailsFormPage.this.getEditor().buildDescriptor();
                try {
                    Object[] selected;
                    Hawk.Client client = DetailsFormPage.this.getEditor().connectToHawk(d);
                    List instances = client.listInstances();
                    Collections.sort(instances);
                    client.getInputProtocol().getTransport().close();
                    Shell shell = formText.getShell();
                    ListDialog dlg = new ListDialog(shell);
                    dlg.setInput((Object)instances);
                    dlg.setContentProvider((IStructuredContentProvider)new ListContentProvider());
                    dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

                        public String getText(Object o) {
                            if (o instanceof HawkInstance) {
                                HawkInstance hi = (HawkInstance)o;
                                return hi.name;
                            }
                            return super.getText(o);
                        }

                        public Image getImage(Object o) {
                            if (o instanceof HawkInstance) {
                                HawkInstance hi = (HawkInstance)o;
                                return Activator.getImageDescriptor(hi.state != HawkState.STOPPED ? "/icons/nav_go.gif" : "/icons/nav_stop.gif").createImage();
                            }
                            return super.getImage(o);
                        }
                    });
                    dlg.setMessage("Select a Hawk instance:");
                    dlg.setTitle("Hawk instance selection");
                    if (dlg.open() == 0 && (selected = dlg.getResult()).length > 0) {
                        this.setInstanceName(((HawkInstance)selected[0]).name);
                        this.instanceNameChanged();
                    }
                }
                catch (Exception ex) {
                    Activator.getDefault().logError(ex);
                }
            }
        };
        this.contentSection = new ContentSection(toolkit, formBody){

            @Override
            protected void filePatternsChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void repositoryURLChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void loadingModeChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void queryLanguageChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void queryChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void defaultNamespacesChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void splitChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void pageSizeChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void selectQueryLanguage() {
                HawkModelDescriptor d = DetailsFormPage.this.getEditor().buildDescriptor();
                try {
                    Hawk.Client client = DetailsFormPage.this.getEditor().connectToHawk(d);
                    String[] languages = client.listQueryLanguages(d.getHawkInstance()).toArray(new String[0]);
                    client.getInputProtocol().getTransport().close();
                    Shell shell = formText.getShell();
                    ListDialog dlg = new ListDialog(shell);
                    dlg.setInput((Object)languages);
                    dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    dlg.setLabelProvider((ILabelProvider)new LabelProvider());
                    dlg.setMessage("Select a query language:");
                    dlg.setTitle("Query language selection");
                    dlg.setInitialSelections(new Object[]{d.getHawkQueryLanguage()});
                    if (dlg.open() == 0) {
                        Object[] selected = dlg.getResult();
                        if (selected.length > 0) {
                            this.setQueryLanguage(selected[0].toString());
                        } else {
                            this.setQueryLanguage("");
                        }
                        this.queryLanguageChanged();
                    }
                }
                catch (Exception ex) {
                    Activator.getDefault().logError(ex);
                }
            }

            @Override
            protected void selectRepository() {
                HawkModelDescriptor d = DetailsFormPage.this.getEditor().buildDescriptor();
                try {
                    Hawk.Client client = DetailsFormPage.this.getEditor().connectToHawk(d);
                    List repositories = client.listRepositories(d.getHawkInstance());
                    Object[] repos = new String[1 + repositories.size()];
                    repos[0] = "*";
                    int iRepo = 1;
                    for (Repository r : repositories) {
                        repos[iRepo++] = r.uri;
                    }
                    Arrays.sort(repos);
                    client.getInputProtocol().getTransport().close();
                    Shell shell = formText.getShell();
                    ListDialog dlg = new ListDialog(shell);
                    dlg.setInput((Object)repos);
                    dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    dlg.setLabelProvider((ILabelProvider)new LabelProvider());
                    dlg.setMessage("Select a repository:");
                    dlg.setTitle("Repository selection");
                    dlg.setInitialSelections(new Object[]{d.getHawkRepository()});
                    if (dlg.open() == 0) {
                        Object[] selected = dlg.getResult();
                        if (selected.length > 0) {
                            this.setRepositoryURL(selected[0].toString());
                        } else {
                            this.setRepositoryURL("*");
                        }
                        this.repositoryURLChanged();
                    }
                }
                catch (Exception ex) {
                    Activator.getDefault().logError(ex);
                }
            }

            @Override
            protected void selectFiles() {
                HawkModelDescriptor d = DetailsFormPage.this.getEditor().buildDescriptor();
                try {
                    Hawk.Client client = DetailsFormPage.this.getEditor().connectToHawk(d);
                    Object[] files = client.listFiles(d.getHawkInstance(), Arrays.asList(d.getHawkRepository()), Arrays.asList("*")).toArray(new String[0]);
                    Arrays.sort(files);
                    client.getInputProtocol().getTransport().close();
                    Shell shell = formText.getShell();
                    ListSelectionDialog dlg = new ListSelectionDialog(shell, (Object)files, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(), "Select files (zero files = all files):");
                    dlg.setTitle("File selection");
                    dlg.setInitialSelections((Object[])d.getHawkFilePatterns());
                    if (dlg.open() == 0) {
                        Object[] selected = dlg.getResult();
                        if (selected.length > 0) {
                            String[] sFiles = new String[selected.length];
                            int i = 0;
                            while (i < selected.length) {
                                sFiles[i] = selected[i].toString();
                                ++i;
                            }
                            this.setFilePatterns(sFiles);
                        } else {
                            this.setFilePatterns("*");
                        }
                        this.filePatternsChanged();
                    }
                }
                catch (Exception ex) {
                    Activator.getDefault().logError(ex);
                }
            }
        };
        this.subscriptionSection = new SubscriptionSection(toolkit, formBody){

            @Override
            protected void subscribeChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void clientIDChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }

            @Override
            protected void durabilityChanged() {
                DetailsFormPage.this.getEditor().setDirty(true);
            }
        };
        managedForm.reflow(true);
    }

    public InstanceSection getInstanceSection() {
        return this.instanceSection;
    }

    public ContentSection getContentSection() {
        return this.contentSection;
    }

    public SubscriptionSection getSubscriptionSection() {
        return this.subscriptionSection;
    }

    static abstract class ContentSection
    extends FormSection
    implements ModifyListener,
    SelectionListener {
        private final FormTextField fldFilePatterns;
        private final FormTextField fldRepositoryURL;
        private final FormComboBoxField fldLoadingMode;
        private final FormTextField fldQueryLanguage;
        private final FormTextField fldQuery;
        private final FormTextField fldDefaultNamespaces;
        private final FormCheckBoxField fldSplit;
        private final FormTextField fldPaged;

        public ContentSection(FormToolkit toolkit, Composite parent) {
            super(toolkit, parent, "Contents", "Filters on the contents of the index to be read as a model");
            this.cContents.setLayout((Layout)Utils.createTableWrapLayout(2));
            this.fldRepositoryURL = new FormTextField(toolkit, this.cContents, "<a href=\"selectRepository\">Repository URL</a>:", "*");
            this.fldFilePatterns = new FormTextField(toolkit, this.cContents, "<a href=\"selectFiles\">File pattern(s)</a>:", "*");
            this.fldLoadingMode = new FormComboBoxField(toolkit, this.cContents, "Loading mode:", HawkModelDescriptor.LoadingMode.strings());
            this.fldQueryLanguage = new FormTextField(toolkit, this.cContents, "<a href=\"selectQueryLanguage\">Query language</a>:", "");
            this.fldQuery = new FormTextField(toolkit, this.cContents, "Query:", "");
            this.fldDefaultNamespaces = new FormTextField(toolkit, this.cContents, "Default namespaces:", "");
            this.fldSplit = new FormCheckBoxField(toolkit, this.cContents, "Split by file:", true);
            this.fldPaged = new FormTextField(toolkit, this.cContents, "Page size for initial load:", "0");
            this.fldRepositoryURL.getText().setToolTipText("Pattern for the URL repositories to be fetched (* means 0+ arbitrary characters).");
            this.fldFilePatterns.getText().setToolTipText("Comma-separated patterns for the files repositories to be fetched (* means 0+ arbitrary characters).");
            this.fldQueryLanguage.getText().setToolTipText("Language in which the query will be written. If empty, the entire model will be retrieved.");
            this.fldQuery.getText().setToolTipText("Query to be used for the initial contents of the model. If empty, the entire model will be retrieved.");
            this.fldDefaultNamespaces.getText().setToolTipText("Comma-separated list of namespaces used to disambiguate types if multiple matches are found.");
            this.fldSplit.getCheck().setToolTipText("If checked, the contents of the index will be split by file, using surrogate resources. Otherwise, the entire contents of the index will be under this resource (needed for CloudATL).");
            this.fldPaged.getText().setToolTipText("If set to a value > 0, the initial load will be done in two stages: 1 request for the node IDs + N requests for their contents (in batches). Recommended for very large models that cannot be sent in one go.");
            this.fldRepositoryURL.getText().addModifyListener((ModifyListener)this);
            this.fldFilePatterns.getText().addModifyListener((ModifyListener)this);
            this.fldLoadingMode.getCombo().addSelectionListener((SelectionListener)this);
            this.fldQueryLanguage.getText().addModifyListener((ModifyListener)this);
            this.fldQuery.getText().addModifyListener((ModifyListener)this);
            this.fldDefaultNamespaces.getText().addModifyListener((ModifyListener)this);
            this.fldSplit.getCheck().addSelectionListener((SelectionListener)this);
            this.fldPaged.getText().addModifyListener((ModifyListener)this);
            HyperlinkAdapter hyperlinkListener = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    switch (e.getHref().toString()) {
                        case "selectQueryLanguage": {
                            this.selectQueryLanguage();
                            break;
                        }
                        case "selectRepository": {
                            this.selectRepository();
                            break;
                        }
                        case "selectFiles": {
                            this.selectFiles();
                        }
                    }
                }
            };
            this.fldQueryLanguage.getLabel().addHyperlinkListener((IHyperlinkListener)hyperlinkListener);
            this.fldRepositoryURL.getLabel().addHyperlinkListener((IHyperlinkListener)hyperlinkListener);
            this.fldFilePatterns.getLabel().addHyperlinkListener((IHyperlinkListener)hyperlinkListener);
        }

        public String[] getFilePatterns() {
            return this.fldFilePatterns.getText().getText().trim().split(",");
        }

        public String getRepositoryURL() {
            return this.fldRepositoryURL.getText().getText().trim();
        }

        public HawkModelDescriptor.LoadingMode getLoadingMode() {
            return HawkModelDescriptor.LoadingMode.values()[this.fldLoadingMode.getCombo().getSelectionIndex()];
        }

        public String getQueryLanguage() {
            return this.fldQueryLanguage.getText().getText().trim();
        }

        public String getQuery() {
            return this.fldQuery.getText().getText().trim();
        }

        public boolean isSplit() {
            return this.fldSplit.getCheck().getSelection();
        }

        public int getPageSize() {
            try {
                return Integer.valueOf(this.fldPaged.getText().getText());
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }

        public String getDefaultNamespaces() {
            return this.fldDefaultNamespaces.getText().getText().trim();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.fldLoadingMode.getCombo()) {
                this.loadingModeChanged();
            } else if (e.widget == this.fldSplit.getCheck()) {
                this.splitChanged();
            }
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.fldRepositoryURL.getText()) {
                this.repositoryURLChanged();
            } else if (e.widget == this.fldFilePatterns.getText()) {
                this.filePatternsChanged();
            } else if (e.widget == this.fldQueryLanguage.getText()) {
                this.queryLanguageChanged();
            } else if (e.widget == this.fldQuery.getText()) {
                this.queryChanged();
            } else if (e.widget == this.fldDefaultNamespaces.getText()) {
                this.defaultNamespacesChanged();
            } else if (e.widget == this.fldPaged.getText()) {
                this.pageSizeChanged();
            }
        }

        public void setFilePatterns(String ... patterns) {
            this.fldFilePatterns.setTextWithoutListener(Utils.concat(patterns, ","), this);
        }

        public void setRepositoryURL(String url) {
            this.fldRepositoryURL.setTextWithoutListener(url, this);
        }

        public void setLoadingMode(HawkModelDescriptor.LoadingMode lazy) {
            this.fldLoadingMode.getCombo().select(lazy.ordinal());
        }

        public void setQueryLanguage(String queryLanguage) {
            this.fldQueryLanguage.setTextWithoutListener(queryLanguage, this);
        }

        public void setQuery(String query) {
            this.fldQuery.setTextWithoutListener(query, this);
        }

        public void setSplit(boolean isSplit) {
            this.fldSplit.getCheck().setSelection(isSplit);
        }

        public void setPageSize(int size) {
            this.fldPaged.setTextWithoutListener(String.valueOf(size), this);
        }

        public void setDefaultNamespaces(String defaultNS) {
            this.fldDefaultNamespaces.setTextWithoutListener(defaultNS, this);
        }

        protected abstract void filePatternsChanged();

        protected abstract void repositoryURLChanged();

        protected abstract void loadingModeChanged();

        protected abstract void queryLanguageChanged();

        protected abstract void queryChanged();

        protected abstract void defaultNamespacesChanged();

        protected abstract void splitChanged();

        protected abstract void pageSizeChanged();

        protected abstract void selectQueryLanguage();

        protected abstract void selectRepository();

        protected abstract void selectFiles();
    }

    static abstract class InstanceSection
    extends FormSection
    implements ModifyListener,
    SelectionListener {
        private final FormTextField fldInstanceName;
        private final FormTextField fldServerURL;
        private final FormComboBoxField fldTProtocol;
        private final FormTextField fldUsername;
        private final FormTextField fldPassword;

        public InstanceSection(FormToolkit toolkit, Composite parent) {
            super(toolkit, parent, "Instance", "Access details for the remote Hawk instance.");
            this.cContents.setLayout((Layout)Utils.createTableWrapLayout(2));
            this.fldServerURL = new FormTextField(toolkit, this.cContents, "Server URL:", "");
            this.fldTProtocol = new FormComboBoxField(toolkit, this.cContents, "Thrift protocol:", APIUtils.ThriftProtocol.strings());
            this.fldInstanceName = new FormTextField(toolkit, this.cContents, "<a href=\"selectInstance\">Instance name</a>:", "");
            this.fldUsername = new FormTextField(toolkit, this.cContents, "Username:", "");
            this.fldPassword = new FormTextField(toolkit, this.cContents, "Password:", "", 0x400800);
            this.fldServerURL.getText().addModifyListener((ModifyListener)this);
            this.fldInstanceName.getText().addModifyListener((ModifyListener)this);
            this.fldTProtocol.getCombo().addSelectionListener((SelectionListener)this);
            this.fldUsername.getText().addModifyListener((ModifyListener)this);
            this.fldPassword.getText().addModifyListener((ModifyListener)this);
            this.fldUsername.getText().setToolTipText("Username to be included in the .hawkmodel file, to log into the Hawk Thrift API. To use the Eclipse secure storage instead, keep blank.");
            this.fldPassword.getText().setToolTipText("Plaintext password to be included in the .hawkmodel file, to log into the Hawk Thrift API. To use the Eclipse secure storage instead, keep blank.");
            this.fldInstanceName.getLabel().addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    switch (e.getHref().toString()) {
                        case "selectInstance": {
                            this.selectInstance();
                        }
                    }
                }
            });
        }

        public String getInstanceName() {
            return this.fldInstanceName.getText().getText().trim();
        }

        public String getServerURL() {
            return this.fldServerURL.getText().getText().trim();
        }

        public APIUtils.ThriftProtocol getThriftProtocol() {
            return APIUtils.ThriftProtocol.values()[this.fldTProtocol.getCombo().getSelectionIndex()];
        }

        public void setInstanceName(String name) {
            this.fldInstanceName.setTextWithoutListener(name, this);
        }

        public void setServerURL(String url) {
            this.fldServerURL.setTextWithoutListener(url, this);
        }

        public void setThriftProtocol(APIUtils.ThriftProtocol t) {
            this.fldTProtocol.getCombo().select(t.ordinal());
        }

        public String getUsername() {
            return this.fldUsername.getText().getText().trim();
        }

        public void setUsername(String u) {
            this.fldUsername.setTextWithoutListener(u, this);
        }

        public String getPassword() {
            return this.fldPassword.getText().getText().trim();
        }

        public void setPassword(String p) {
            this.fldPassword.setTextWithoutListener(p, this);
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.fldServerURL.getText()) {
                this.serverURLChanged();
            } else if (e.widget == this.fldInstanceName.getText()) {
                this.instanceNameChanged();
            } else if (e.widget == this.fldUsername.getText()) {
                this.usernameChanged();
            } else if (e.widget == this.fldPassword.getText()) {
                this.passwordChanged();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.fldTProtocol.getCombo()) {
                this.thriftProtocolChanged();
            }
        }

        protected abstract void instanceNameChanged();

        protected abstract void serverURLChanged();

        protected abstract void thriftProtocolChanged();

        protected abstract void usernameChanged();

        protected abstract void passwordChanged();

        protected abstract void selectInstance();
    }

    static abstract class SubscriptionSection
    extends FormSection
    implements SelectionListener,
    ModifyListener {
        private final FormCheckBoxField fldSubscribe;
        private final FormTextField fldClientID;
        private final FormComboBoxField fldDurability;

        public SubscriptionSection(FormToolkit toolkit, Composite parent) {
            super(toolkit, parent, "Subscription", "Configuration parameters for subscriptions to changes in the models indexed by Hawk.");
            this.cContents.setLayout((Layout)Utils.createTableWrapLayout(2));
            this.fldSubscribe = new FormCheckBoxField(toolkit, this.cContents, "Subscribe:", false);
            this.fldClientID = new FormTextField(toolkit, this.cContents, "Client ID:", HawkModelDescriptor.DEFAULT_CLIENTID);
            this.fldDurability = new FormComboBoxField(toolkit, this.cContents, "Durability:", this.toStringArray(SubscriptionDurability.values()));
            this.fldSubscribe.getCheck().addSelectionListener((SelectionListener)this);
            this.fldClientID.getText().addModifyListener((ModifyListener)this);
            this.fldDurability.getCombo().addSelectionListener((SelectionListener)this);
        }

        private String[] toStringArray(Object[] values) {
            String[] sArray = new String[values.length];
            int i = 0;
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                sArray[i++] = "" + v;
                ++n2;
            }
            return sArray;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.fldSubscribe.getCheck()) {
                this.subscribeChanged();
            } else if (e.widget == this.fldDurability.getCombo()) {
                this.durabilityChanged();
            }
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.fldClientID.getText()) {
                this.clientIDChanged();
            }
        }

        public boolean isSubscribed() {
            return this.fldSubscribe.getCheck().getSelection();
        }

        public void setSubscribed(boolean subscribed) {
            this.fldSubscribe.getCheck().setSelection(subscribed);
        }

        public String getClientID() {
            return this.fldClientID.getText().getText().trim();
        }

        public void setClientID(String s) {
            this.fldClientID.setTextWithoutListener(s, this);
        }

        public SubscriptionDurability getDurability() {
            return SubscriptionDurability.values()[this.fldDurability.getCombo().getSelectionIndex()];
        }

        public void setDurability(SubscriptionDurability s) {
            this.fldDurability.getCombo().select(s.ordinal());
        }

        protected abstract void subscribeChanged();

        protected abstract void clientIDChanged();

        protected abstract void durabilityChanged();
    }
}

