// This autogenerated skeleton file illustrates how to build a server.
// You should copy it to another filename to avoid overwriting it.

#include "Hawk.h"
#include <thrift/protocol/TBinaryProtocol.h>
#include <thrift/server/TSimpleServer.h>
#include <thrift/transport/TServerSocket.h>
#include <thrift/transport/TBufferTransports.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

class HawkHandler : virtual public HawkIf {
 public:
  HawkHandler() {
    // Your initialization goes here
  }

  void createInstance(const std::string& name, const std::string& backend, const int32_t minimumDelayMillis, const int32_t maximumDelayMillis, const std::vector<std::string> & enabledPlugins, const std::string& indexFactory) {
    // Your implementation goes here
    printf("createInstance\n");
  }

  void listBackends(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("listBackends\n");
  }

  void listPlugins(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("listPlugins\n");
  }

  void listPluginDetails(std::vector<HawkPlugin> & _return) {
    // Your implementation goes here
    printf("listPluginDetails\n");
  }

  void listInstances(std::vector<HawkInstance> & _return) {
    // Your implementation goes here
    printf("listInstances\n");
  }

  void removeInstance(const std::string& name) {
    // Your implementation goes here
    printf("removeInstance\n");
  }

  void startInstance(const std::string& name) {
    // Your implementation goes here
    printf("startInstance\n");
  }

  void stopInstance(const std::string& name) {
    // Your implementation goes here
    printf("stopInstance\n");
  }

  void syncInstance(const std::string& name, const bool blockUntilDone) {
    // Your implementation goes here
    printf("syncInstance\n");
  }

  void registerMetamodels(const std::string& name, const std::vector<File> & metamodel) {
    // Your implementation goes here
    printf("registerMetamodels\n");
  }

  void unregisterMetamodels(const std::string& name, const std::vector<std::string> & metamodel) {
    // Your implementation goes here
    printf("unregisterMetamodels\n");
  }

  void listMetamodels(std::vector<std::string> & _return, const std::string& name) {
    // Your implementation goes here
    printf("listMetamodels\n");
  }

  void listTypeNames(std::vector<std::string> & _return, const std::string& hawkInstanceName, const std::string& metamodelURI) {
    // Your implementation goes here
    printf("listTypeNames\n");
  }

  void listAttributeNames(std::vector<std::string> & _return, const std::string& hawkInstanceName, const std::string& metamodelURI, const std::string& typeName) {
    // Your implementation goes here
    printf("listAttributeNames\n");
  }

  void listMetamodelParsers(std::vector<MetamodelParserDetails> & _return, const std::string& name) {
    // Your implementation goes here
    printf("listMetamodelParsers\n");
  }

  void listQueryLanguages(std::vector<std::string> & _return, const std::string& name) {
    // Your implementation goes here
    printf("listQueryLanguages\n");
  }

  void query(QueryResult& _return, const std::string& name, const std::string& query, const std::string& language, const HawkQueryOptions& options) {
    // Your implementation goes here
    printf("query\n");
  }

  void timedQuery(QueryReport& _return, const std::string& name, const std::string& query, const std::string& language, const HawkQueryOptions& options) {
    // Your implementation goes here
    printf("timedQuery\n");
  }

  void resolveProxies(std::vector<ModelElement> & _return, const std::string& name, const std::vector<std::string> & ids, const HawkQueryOptions& options) {
    // Your implementation goes here
    printf("resolveProxies\n");
  }

  void asyncQuery(std::string& _return, const std::string& name, const std::string& query, const std::string& language, const HawkQueryOptions& options) {
    // Your implementation goes here
    printf("asyncQuery\n");
  }

  void cancelAsyncQuery(const std::string& queryID) {
    // Your implementation goes here
    printf("cancelAsyncQuery\n");
  }

  void fetchAsyncQueryResults(QueryReport& _return, const std::string& queryID) {
    // Your implementation goes here
    printf("fetchAsyncQueryResults\n");
  }

  void addRepository(const std::string& name, const Repository& repo, const Credentials& credentials) {
    // Your implementation goes here
    printf("addRepository\n");
  }

  bool isFrozen(const std::string& name, const std::string& uri) {
    // Your implementation goes here
    printf("isFrozen\n");
  }

  void setFrozen(const std::string& name, const std::string& uri, const bool isFrozen) {
    // Your implementation goes here
    printf("setFrozen\n");
  }

  void removeRepository(const std::string& name, const std::string& uri) {
    // Your implementation goes here
    printf("removeRepository\n");
  }

  void updateRepositoryCredentials(const std::string& name, const std::string& uri, const Credentials& cred) {
    // Your implementation goes here
    printf("updateRepositoryCredentials\n");
  }

  void listRepositories(std::vector<Repository> & _return, const std::string& name) {
    // Your implementation goes here
    printf("listRepositories\n");
  }

  void listRepositoryTypes(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("listRepositoryTypes\n");
  }

  void listFiles(std::vector<std::string> & _return, const std::string& name, const std::vector<std::string> & repository, const std::vector<std::string> & filePatterns) {
    // Your implementation goes here
    printf("listFiles\n");
  }

  void configurePolling(const std::string& name, const int32_t base, const int32_t max) {
    // Your implementation goes here
    printf("configurePolling\n");
  }

  void addDerivedAttribute(const std::string& name, const DerivedAttributeSpec& spec) {
    // Your implementation goes here
    printf("addDerivedAttribute\n");
  }

  void removeDerivedAttribute(const std::string& name, const DerivedAttributeSpec& spec) {
    // Your implementation goes here
    printf("removeDerivedAttribute\n");
  }

  void listDerivedAttributes(std::vector<DerivedAttributeSpec> & _return, const std::string& name) {
    // Your implementation goes here
    printf("listDerivedAttributes\n");
  }

  void addIndexedAttribute(const std::string& name, const IndexedAttributeSpec& spec) {
    // Your implementation goes here
    printf("addIndexedAttribute\n");
  }

  void removeIndexedAttribute(const std::string& name, const IndexedAttributeSpec& spec) {
    // Your implementation goes here
    printf("removeIndexedAttribute\n");
  }

  void listIndexedAttributes(std::vector<IndexedAttributeSpec> & _return, const std::string& name) {
    // Your implementation goes here
    printf("listIndexedAttributes\n");
  }

  void getModel(std::vector<ModelElement> & _return, const std::string& name, const HawkQueryOptions& options) {
    // Your implementation goes here
    printf("getModel\n");
  }

  void getRootElements(std::vector<ModelElement> & _return, const std::string& name, const HawkQueryOptions& options) {
    // Your implementation goes here
    printf("getRootElements\n");
  }

  void watchStateChanges(Subscription& _return, const std::string& name) {
    // Your implementation goes here
    printf("watchStateChanges\n");
  }

  void watchModelChanges(Subscription& _return, const std::string& name, const std::string& repositoryUri, const std::vector<std::string> & filePath, const std::string& clientID, const SubscriptionDurability::type durableEvents) {
    // Your implementation goes here
    printf("watchModelChanges\n");
  }

};

int main(int argc, char **argv) {
  int port = 9090;
  ::std::shared_ptr<HawkHandler> handler(new HawkHandler());
  ::std::shared_ptr<TProcessor> processor(new HawkProcessor(handler));
  ::std::shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  ::std::shared_ptr<TTransportFactory> transportFactory(new TBufferedTransportFactory());
  ::std::shared_ptr<TProtocolFactory> protocolFactory(new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}

