/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.handly.ui.viewer.Util;
import org.eclipse.handly.util.SerialPerObjectRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public abstract class DeferredTreeContentProvider
implements ITreeContentProvider {
    private final AbstractTreeViewer viewer;
    private final DeferredWorkbenchAdapter deferredWorkbenchAdapter = new DeferredWorkbenchAdapter();
    private final DeferredTreeContentManager deferredTreeContentManager;

    public DeferredTreeContentProvider(AbstractTreeViewer viewer, IWorkbenchPartSite site) {
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        this.viewer = viewer;
        this.deferredTreeContentManager = new DeferredTreeContentManager(viewer, site){

            protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                return DeferredTreeContentProvider.this.deferredWorkbenchAdapter;
            }
        };
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Object[] elements;
        if (viewer != this.viewer) {
            throw new IllegalArgumentException();
        }
        if (oldInput != null && (elements = this.getElements(oldInput)) != null) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.deferredTreeContentManager.cancel(element);
                ++n2;
            }
        }
    }

    protected final DeferredTreeContentManager getDeferredTreeContentManager() {
        return this.deferredTreeContentManager;
    }

    protected abstract void fetchDeferredChildren(Object var1, IElementCollector var2, IProgressMonitor var3);

    protected ISchedulingRule getRule(Object parentElement) {
        return new SerialPerObjectRule((Object)this);
    }

    protected String getLabel(Object element) {
        String label = Util.getText(this.viewer.getLabelProvider(), element);
        return label != null ? label : "";
    }

    private class DeferredWorkbenchAdapter
    implements IDeferredWorkbenchAdapter {
        private DeferredWorkbenchAdapter() {
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            DeferredTreeContentProvider.this.fetchDeferredChildren(object, collector, monitor);
        }

        public ISchedulingRule getRule(Object object) {
            return DeferredTreeContentProvider.this.getRule(object);
        }

        public String getLabel(Object o) {
            return DeferredTreeContentProvider.this.getLabel(o);
        }

        public boolean isContainer() {
            return true;
        }

        public Object getParent(Object o) {
            throw new AssertionError();
        }

        public Object[] getChildren(Object o) {
            throw new AssertionError();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            throw new AssertionError();
        }
    }
}

