/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.refactoring;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;
import org.eclipse.handly.refactoring.SourceFileChange;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SourceFileChangeTest
extends WorkspaceTestCase {
    private ISourceFile sourceFile;
    private IBuffer buffer;

    protected void setUp() throws Exception {
        super.setUp();
        IFile file = this.setUpProject("Test001").getFile("a.foo");
        this.sourceFile = new SimpleSourceFile(null, file.getName(), file, new SimpleModelManager());
        this.buffer = Elements.getBuffer((ISourceFile)this.sourceFile);
    }

    protected void tearDown() throws Exception {
        if (this.buffer != null) {
            this.buffer.release();
        }
        super.tearDown();
    }

    public void test01() throws Exception {
        InsertEdit edit = new InsertEdit(0, "foo");
        SourceFileChange change = new SourceFileChange("", this.sourceFile, (TextEdit)edit);
        SourceFileChangeTest.assertSame((Object)edit, (Object)change.getEdit());
        SourceFileChangeTest.assertEquals((Object)this.sourceFile, (Object)change.getModifiedElement());
        SourceFileChangeTest.assertEquals(Arrays.asList(Elements.getFile((ISourceFile)this.sourceFile)), Arrays.asList(change.getAffectedObjects()));
        SourceFileChangeTest.assertTrue((boolean)change.isValid(null).isOK());
        Change undoChange = change.perform(null);
        SourceFileChangeTest.assertEquals((String)"foo", (String)this.buffer.getDocument().get());
        SourceFileChangeTest.assertFalse((boolean)this.buffer.isDirty());
        SourceFileChangeTest.assertEquals((Object)this.sourceFile, (Object)undoChange.getModifiedElement());
        SourceFileChangeTest.assertEquals(Arrays.asList(Elements.getFile((ISourceFile)this.sourceFile)), Arrays.asList(undoChange.getAffectedObjects()));
        undoChange.initializeValidationData(null);
        SourceFileChangeTest.assertTrue((boolean)undoChange.isValid(null).isOK());
        Change redoChange = undoChange.perform(null);
        SourceFileChangeTest.assertEquals((String)"", (String)this.buffer.getDocument().get());
        SourceFileChangeTest.assertFalse((boolean)this.buffer.isDirty());
        SourceFileChangeTest.assertEquals((Object)this.sourceFile, (Object)redoChange.getModifiedElement());
        SourceFileChangeTest.assertEquals(Arrays.asList(Elements.getFile((ISourceFile)this.sourceFile)), Arrays.asList(redoChange.getAffectedObjects()));
        redoChange.initializeValidationData(null);
        SourceFileChangeTest.assertTrue((boolean)redoChange.isValid(null).isOK());
        redoChange.perform(null);
        SourceFileChangeTest.assertEquals((String)"foo", (String)this.buffer.getDocument().get());
        SourceFileChangeTest.assertFalse((boolean)this.buffer.isDirty());
    }

    public void test02() throws Exception {
        SourceFileChange change = new SourceFileChange("", this.sourceFile, (TextEdit)new InsertEdit(0, "foo"));
        change.setSaveMode(SaveMode.LEAVE_UNSAVED);
        change.perform(null);
        SourceFileChangeTest.assertEquals((String)"foo", (String)this.buffer.getDocument().get());
        SourceFileChangeTest.assertTrue((boolean)this.buffer.isDirty());
        change = new SourceFileChange("", this.sourceFile, (TextEdit)new ReplaceEdit(0, 3, "bar"));
        change.perform(null);
        SourceFileChangeTest.assertEquals((String)"bar", (String)this.buffer.getDocument().get());
        SourceFileChangeTest.assertTrue((boolean)this.buffer.isDirty());
        change = new SourceFileChange("", this.sourceFile, (TextEdit)new DeleteEdit(0, 3));
        change.setSaveMode(SaveMode.FORCE_SAVE);
        change.perform(null);
        SourceFileChangeTest.assertEquals((String)"", (String)this.buffer.getDocument().get());
        SourceFileChangeTest.assertFalse((boolean)this.buffer.isDirty());
    }

    public void test03() throws Exception {
        SourceFileChange change = new SourceFileChange("", this.sourceFile, (TextEdit)new InsertEdit(0, "foo"));
        change.setBase((ISnapshot)new DocumentSnapshot(this.buffer.getDocument()));
        SourceFileChangeTest.assertTrue((boolean)change.isValid(null).isOK());
        this.buffer.getDocument().set("bar");
        SourceFileChangeTest.assertTrue((boolean)change.isValid(null).hasFatalError());
        try {
            change.perform(null);
            SourceFileChangeTest.fail();
        }
        catch (CoreException e) {
            SourceFileChangeTest.assertTrue((boolean)(e.getCause() instanceof StaleSnapshotException));
        }
    }

    public void test04() throws Exception {
        SourceFileChange change = new SourceFileChange("", this.sourceFile, (TextEdit)new InsertEdit(0, "foo"));
        Change undoChange = change.perform(null);
        undoChange.initializeValidationData(null);
        SourceFileChangeTest.assertTrue((boolean)undoChange.isValid(null).isOK());
        this.buffer.getDocument().set("");
        SourceFileChangeTest.assertTrue((boolean)undoChange.isValid(null).hasFatalError());
        try {
            undoChange.perform(null);
            SourceFileChangeTest.fail();
        }
        catch (CoreException e) {
            SourceFileChangeTest.assertTrue((boolean)(e.getCause() instanceof StaleSnapshotException));
        }
    }

    public void test05() throws Exception {
        SourceFileChange change = new SourceFileChange("", this.sourceFile, (TextEdit)new InsertEdit(0, "foo"));
        Change undoChange = change.perform(null);
        undoChange.initializeValidationData(null);
        SourceFileChangeTest.assertTrue((boolean)undoChange.isValid(null).isOK());
        Elements.getFile((ISourceFile)this.sourceFile).delete(true, null);
        SourceFileChangeTest.assertTrue((boolean)undoChange.isValid(null).hasFatalError());
    }

    public void test06() throws Exception {
        SourceFileChange change = new SourceFileChange("", this.sourceFile, (TextEdit)new InsertEdit(0, "foo"));
        Change undoChange = change.perform(null);
        Change undoDeleteResourceChange = new DeleteResourceChange(Elements.getFile((ISourceFile)this.sourceFile).getFullPath(), true).perform(null);
        undoChange.initializeValidationData(null);
        SourceFileChangeTest.assertTrue((boolean)undoChange.isValid(null).isOK());
        undoDeleteResourceChange.perform((IProgressMonitor)new NullProgressMonitor());
        SourceFileChangeTest.assertTrue((boolean)undoChange.isValid(null).hasFatalError());
    }

    public void test07() throws Exception {
        this.buffer.getDocument().set("\nfoo\n");
        InsertEdit edit1 = new InsertEdit(0, "bar");
        DeleteEdit edit2 = new DeleteEdit(1, 3);
        InsertEdit edit3 = new InsertEdit(5, "baz");
        SourceFileChange change = new SourceFileChange("", this.sourceFile);
        change.addGroupedEdits(new TextEditGroup("bar", (TextEdit)edit1));
        change.addGroupedEdits(new TextEditBasedChangeGroup((TextEditBasedChange)change, new TextEditGroup("foo", (TextEdit)edit2)));
        change.addGroupedEdits(new TextEditGroup("baz", (TextEdit)edit3));
        SourceFileChangeTest.assertEquals(Arrays.asList(edit1, edit2, edit3), Arrays.asList(change.getEdit().getChildren()));
        TextEditBasedChangeGroup[] groups = change.getChangeGroups();
        SourceFileChangeTest.assertEquals((int)3, (int)groups.length);
        SourceFileChangeTest.assertEquals((String)"\nfoo\n", (String)change.getCurrentContent(null));
        SourceFileChangeTest.assertEquals((String)"bar\n\nbaz", (String)change.getPreviewContent(null));
        SourceFileChangeTest.assertGroupContent(groups[0], 0, "", "bar");
        SourceFileChangeTest.assertGroupContent(groups[1], 0, "foo", "");
        SourceFileChangeTest.assertGroupContent(groups[2], 0, "", "baz");
        SourceFileChangeTest.assertGroupContent(groups[0], 1, "", "bar\nfoo");
        SourceFileChangeTest.assertGroupContent(groups[1], 1, "\nfoo\n", "\n");
        SourceFileChangeTest.assertGroupContent(groups[2], 1, "foo\n", "foo\nbaz");
        SourceFileChangeTest.assertGroupContent(groups[0], 2, "\nfoo", "bar\nfoo\n");
        SourceFileChangeTest.assertGroupContent(groups[1], 2, "\nfoo\n", "\n\n");
        SourceFileChangeTest.assertGroupContent(groups[2], 2, "\nfoo\n", "\nfoo\nbaz");
        groups[1].setEnabled(false);
        groups[2].setEnabled(false);
        SourceFileChangeTest.assertEquals((String)"bar\nfoo\n", (String)change.getPreviewContent(null));
        change.perform(null);
        SourceFileChangeTest.assertEquals((String)"bar\nfoo\n", (String)change.getCurrentContent(null));
    }

    public void test08() throws Exception {
        this.buffer.getDocument().set("012345");
        ReplaceEdit edit = new ReplaceEdit(2, 3, "xy");
        SourceFileChange change = new SourceFileChange("", this.sourceFile, (TextEdit)edit);
        change.perform(null);
        SourceFileChangeTest.assertEquals((String)"01xy5", (String)this.buffer.getDocument().get());
        SourceFileChangeTest.assertRegion(edit.getRegion(), 2, 2);
    }

    public void test09() throws Exception {
        this.buffer.getDocument().set("012345");
        ReplaceEdit edit = new ReplaceEdit(2, 3, "xy");
        SourceFileChange change = new SourceFileChange("", this.sourceFile, (TextEdit)edit);
        change.setKeepPreviewEdits(true);
        try {
            change.getPreviewEdit((TextEdit)edit);
            SourceFileChangeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            change.getPreviewEdits(new TextEdit[]{edit});
            SourceFileChangeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        SourceFileChangeTest.assertEquals((String)"01xy5", (String)change.getPreviewContent(null));
        TextEdit previewEdit = change.getPreviewEdit((TextEdit)edit);
        SourceFileChangeTest.assertRegion(previewEdit.getRegion(), 2, 2);
        SourceFileChangeTest.assertEquals(Arrays.asList(previewEdit), Arrays.asList(change.getPreviewEdits(new TextEdit[]{edit})));
        change.setKeepPreviewEdits(false);
        try {
            change.getPreviewEdit((TextEdit)edit);
            SourceFileChangeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            change.getPreviewEdits(new TextEdit[]{edit});
            SourceFileChangeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test10() throws Exception {
        this.buffer.getDocument().set("012345");
        ReplaceEdit edit1 = new ReplaceEdit(1, 4, "9876");
        ReplaceEdit edit2 = new ReplaceEdit(2, 2, "xy");
        ReplaceEdit edit3 = new ReplaceEdit(1, 4, "1234");
        SourceFileChange change = new SourceFileChange("", this.sourceFile);
        change.addEdits(new TextEdit[]{edit1, edit2, edit3});
        SourceFileChangeTest.assertSame((Object)change.getEdit(), (Object)edit1.getParent());
        SourceFileChangeTest.assertSame((Object)edit3, (Object)edit2.getParent());
        SourceFileChangeTest.assertSame((Object)edit1, (Object)edit3.getParent());
        SourceFileChangeTest.assertEquals((String)"098765", (String)change.getPreviewContent(null));
    }

    private static void assertGroupContent(TextEditBasedChangeGroup group, int surroundingLines, String expectedCurrentContent, String expectedPreviewContent) throws CoreException {
        TextEditBasedChange change = group.getTextEditChange();
        SourceFileChangeTest.assertEquals((String)expectedCurrentContent, (String)change.getCurrentContent(group.getRegion(), true, surroundingLines, null));
        SourceFileChangeTest.assertEquals((String)expectedPreviewContent, (String)change.getPreviewContent(new TextEditBasedChangeGroup[]{group}, group.getRegion(), true, surroundingLines, null));
    }

    private static void assertRegion(IRegion region, int expectedOffset, int expectedLength) {
        SourceFileChangeTest.assertEquals((int)expectedOffset, (int)region.getOffset());
        SourceFileChangeTest.assertEquals((int)expectedLength, (int)region.getLength());
    }
}

