/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal;

import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.eclipse.handly.internal.DisplaySynchronizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Synchronizer;

public class DisplaySynchronizerTest
extends TestCase {
    private Display display;
    private DisplaySynchronizer displaySynchronizer;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = new Display();
        this.displaySynchronizer = new DisplaySynchronizer(this.display);
    }

    protected void tearDown() throws Exception {
        if (this.display != null) {
            this.display.dispose();
        }
        super.tearDown();
    }

    public void test1() {
        DisplaySynchronizerTest.assertSame((Object)this.display.getThread(), (Object)this.displaySynchronizer.getThread());
    }

    public void test2() {
        this.display.dispose();
        DisplaySynchronizerTest.assertIllegalStateException(() -> {
            Thread thread = this.displaySynchronizer.getThread();
        });
        DisplaySynchronizerTest.assertIllegalStateException(() -> this.displaySynchronizer.asyncExec(() -> {}));
        DisplaySynchronizerTest.assertIllegalStateException(() -> {
            try {
                this.displaySynchronizer.syncExec(() -> {});
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        });
    }

    public void test3() {
        RuntimeException e = new RuntimeException();
        try {
            this.displaySynchronizer.syncExec(() -> {
                throw e;
            });
            DisplaySynchronizerTest.fail();
        }
        catch (ExecutionException ee) {
            DisplaySynchronizerTest.assertSame((Object)e, (Object)ee.getCause());
        }
    }

    public void test4() {
        this.display.setSynchronizer(new Synchronizer(this.display){

            protected void syncExec(Runnable runnable) {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    SWT.error((int)46, (Throwable)t);
                }
            }
        });
        this.test3();
    }

    private static void assertIllegalStateException(Runnable runnable) {
        try {
            runnable.run();
            DisplaySynchronizerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

