/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.openoffice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.Activator;
import org.eclipse.gendoc.document.parser.documents.AbstractZipDocument;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.openoffice.OpenOfficeParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OpenOfficeDocument
extends AbstractZipDocument {
    private HashMap<String, XMLParser> subdocuments;
    private XMLParser contentTypes;

    public OpenOfficeDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) throws IOException {
        super(documentFile, configuration);
    }

    public OpenOfficeDocument(File document) throws IOException {
        super(document);
    }

    public OpenOfficeDocument(URL documentFile, Map<Document.CONFIGURATION, Boolean> configuration) {
        super(documentFile, configuration);
    }

    public OpenOfficeDocument(URL document) {
        super(document);
    }

    @Override
    public OpenOfficeParser getXMLParser() {
        return (OpenOfficeParser)super.getXMLParser();
    }

    public String getNextDocumentName(String relpath) {
        File rel = new File(relpath.replace("/", File.separator));
        String[] nameParts = rel.getName().split("\\*");
        File f = new File(this.getUnzipLocationDocumentFile(), rel.getPath());
        File folder = f.getParentFile();
        int index = 0;
        if (folder.exists()) {
            String[] names = folder.list();
            int i = 0;
            while (names != null && i < names.length) {
                if (names[i].startsWith(nameParts[0]) && names[i].endsWith(nameParts[1])) {
                    try {
                        index = Math.max(Integer.valueOf(names[i].replace(nameParts[0], "").replace(nameParts[1], "")), index);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
        }
        String res = String.valueOf(rel.getParent()) + File.separator + rel.getName().replace("*", String.valueOf(index + 1));
        return res.replace(File.separator, "/");
    }

    public XMLParser createSubdocument(String path, CharSequence content) throws IOException {
        return this.createSubdocument(path, content, null);
    }

    public XMLParser createSubdocument(String path, CharSequence content, String contentType) throws IOException {
        File f = new File(this.getUnzipLocationDocumentFile(), path.replace("/", File.separator));
        f.getParentFile().mkdirs();
        FileOutputStream writer = new FileOutputStream(f);
        writer.write(String.valueOf(content).getBytes(Charset.forName("UTF-8")));
        writer.flush();
        writer.close();
        if (contentType != null) {
            if (this.contentTypes == null) {
                this.contentTypes = this.getSubdocument("/[Content_Types].xml");
            }
            Node typesEl = null;
            try {
                typesEl = this.getXMLParser().getXPathUtils().evaluateNode(this.contentTypes.getDocument(), "/ct:Types");
                Node n = this.getXMLParser().getXPathUtils().evaluateNode(typesEl, "./ct:Override[@PartName='" + path + "']");
                if (n != null) {
                    n.getParentNode().removeChild(n);
                }
                Element el = (Element)typesEl.appendChild(typesEl.getOwnerDocument().createElementNS("http://schemas.openxmlformats.org/package/2006/content-types", "ct:Override"));
                el.setAttribute("PartName", path);
                el.setAttribute("ContentType", contentType);
            }
            catch (XPathExpressionException e) {
                Activator.log(e, 4);
            }
        }
        this.subdocuments.remove(path);
        return this.getSubdocument(path);
    }

    public List<XMLParser> getSubdocuments(String folder) {
        if (this.subdocuments == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<XMLParser> parsers = new ArrayList<XMLParser>();
        for (Map.Entry<String, XMLParser> e : this.subdocuments.entrySet()) {
            if (!e.getKey().startsWith(String.valueOf(folder) + "/") || e.getKey().indexOf(47, folder.length() + 1) != -1) continue;
            parsers.add(e.getValue());
        }
        return parsers;
    }

    public Collection<XMLParser> getSubdocuments() {
        return this.subdocuments == null ? Collections.emptyList() : this.subdocuments.values();
    }

    public XMLParser getSubdocument(String relpath) {
        XMLParser p;
        if (this.subdocuments == null) {
            this.subdocuments = new HashMap();
        }
        if (!(relpath = relpath.replace(File.separatorChar, '/')).startsWith("/")) {
            relpath = "/" + relpath;
        }
        if ((p = this.subdocuments.get(relpath)) != null) {
            return p;
        }
        File f = new File(this.getUnzipLocationDocumentFile(), relpath.replace("/", File.separator));
        if (f.exists()) {
            p = new XMLParser(f);
            this.subdocuments.put(relpath, p);
        }
        return p;
    }

    public String getBasePath() {
        return this.getUnzipLocationDocumentFile().getAbsolutePath();
    }

    public String getRelativePath(XMLParser p) {
        String basePath;
        String path = p.getXmlFile().getAbsolutePath();
        if (!path.startsWith(basePath = this.getBasePath())) {
            return null;
        }
        path = path.substring(basePath.length());
        path = path.replace(File.separatorChar, '/');
        return path;
    }
}

