/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.gendoc.document.parser.Activator;

public class Zipper {
    private int BUFFERVALUE = 8192;
    private byte[] BUFFER = new byte[this.BUFFERVALUE];
    private File file;

    public Zipper(File file) {
        this.file = file;
    }

    public void zip(String locationToZip) {
        if (this.file.isDirectory()) {
            try {
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(locationToZip));
                try {
                    this.addFileToZip(zos, this.file.getPath(), locationToZip);
                }
                finally {
                    zos.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                Activator.log(fnfe);
                throw new IllegalStateException(fnfe.getMessage(), fnfe);
            }
            catch (IOException ioe) {
                Activator.log(ioe);
                throw new IllegalStateException(ioe.getMessage(), ioe);
            }
        }
    }

    private void addFileToZip(ZipOutputStream zos, String path, String zipPath) {
        File file;
        block10: {
            file = new File(path);
            if (file.isDirectory() && file.list().length != 0) {
                String[] files;
                String[] stringArray = files = file.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String filePath = stringArray[n2];
                    this.addFileToZip(zos, String.valueOf(path) + File.separator + filePath, zipPath);
                    ++n2;
                }
            } else {
                try {
                    String zipEntryLocation = this.getRelativePathInZip(file.getPath(), zipPath);
                    if (file.isDirectory() && file.list().length == 0) {
                        ZipEntry entry = new ZipEntry(String.valueOf(zipEntryLocation) + "/");
                        zos.putNextEntry(entry);
                        break block10;
                    }
                    FileInputStream in = new FileInputStream(file);
                    try {
                        int bytesRead;
                        ZipEntry zipEntry = new ZipEntry(zipEntryLocation);
                        zos.putNextEntry(zipEntry);
                        while (-1 != (bytesRead = in.read(this.BUFFER))) {
                            zos.write(this.BUFFER, 0, bytesRead);
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        file.delete();
    }

    private String getRelativePathInZip(String filePath, String zipPath) {
        String relativePath = filePath.substring(this.file.getAbsolutePath().length() + 1);
        relativePath = relativePath.replace("\\", "/");
        return relativePath;
    }
}

