/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.helper.UnitsHelper;
import org.eclipse.gendoc.document.parser.xlsx.CellRef;
import org.eclipse.gendoc.document.parser.xlsx.XLSXDocument;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.BreakRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellAnchorMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellMark;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellRangeRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellRangeSheetRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.FirstCellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.ICellMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.ICellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.ImageRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.MinCellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.UnionCellRangeRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.helper.XPathXlsxUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XLSXParser
extends XMLParser {
    private XLSXDocument xlsxDocument;
    private LinkedHashMap<Integer, RowReflowInfo> rowReflowInfos = null;
    private XMLParser relationships;
    private int relationshipsNextId;
    private HashMap<String, XMLParser> partsDocuments;
    private final ICellMarker[] markers = new ICellMarker[]{new CellRefMarker("cellSmartTags", "/:worksheet/:smartTags/:cellSmartTags", "@r"), new CellRefMarker("cellWatch", "/:worksheet/:cellWatches/:cellWatch", "@r"), new MinCellRefMarker("customSheetView", "/:worksheet/:customSheetViews/:customSheetView", "@topLeftCell"), new MinCellRefMarker("customSheetView/pane", "/:worksheet/:customSheetViews/:customSheetView/:pane", "@topLeftCell"), new CellRefMarker("inputCells", "/:worksheet/:scenarios/:scenario/:inputCells", "@r"), new MinCellRefMarker("sheetView/pane", "/:worksheet/:sheetViews/:sheetView/:pane", "@topLeftCell"), new MinCellRefMarker("sheetView", "/:worksheet/:sheetViews/:sheetView", "@topLeftCell"), new FirstCellRefMarker("customSheetView/selection", "/:worksheet/:customSheetViews/:customSheetView/:selection", "@activeCell"), new FirstCellRefMarker("sheetView/selection", "/:worksheet/:sheetViews/:sheetView/:selection", "@activeCell"), new CellRefMarker("singleXmlCell", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/tableSingleCells", "/:singleXmlCells/:singleXmlCell", "@r"), new UnionCellRangeRefMarker("worksheet/autoFilter", "/:worksheet/:autoFilter", "@ref"), new CellRefMarker("comment", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments", "/:comments/:commentList/:comment", "@ref"), new CellRangeSheetRefMarker("dataRef", null, "/:worksheet/:dataConsolidate/:dataRefs/:dataRef", "@ref", "@sheet", "../@count"), new CellRefMarker("hyperlinks", "/:worksheet/:hyperlinks/:hyperlink", "@ref"), new CellRangeRefMarker("mergeCell", null, "/:worksheet/:mergeCells/:mergeCell", "@ref", "../@count"), new UnionCellRangeRefMarker("syncRef", "/:worksheet/:sheetPr", "@syncRef"), new CellRangeRefMarker("worksheet/sortCondition", "/:worksheet/:sortState/:sortCondition", "@syncRef"), new CellRangeRefMarker("worksheet/autoFilter/sortCondition", "/:worksheet/:autoFilter/:sortState/:sortCondition", "@ref"), new UnionCellRangeRefMarker("worksheet/sortState", "/:worksheet/:sortState", "@syncRef"), new UnionCellRangeRefMarker("worksheet/sortState", "/:worksheet/:autoFilter/:sortState", "@ref"), new CellRangeRefMarker("webPublishItems", null, "/:worksheet/:webPublishItems/:webPublishItem", "@sourceRef", "../@count"), new CellAnchorMarker("oneCellAnchor", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing", "/xdr:wsDr/xdr:oneCellAnchor", false), new CellAnchorMarker("twoCellAnchor", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing", "/xdr:wsDr/xdr:twoCellAnchor", true), new UnionCellRangeRefMarker("customSheetView/selection/sqref", "/:worksheet/:customSheetViews/:customSheetView/:selection", "@sqref"), new UnionCellRangeRefMarker("sheetView/selection/sqref", "/:worksheet/:sheetViews/:sheetView/:selection", "@sqref"), new CellRangeRefMarker("conditionalFormatting", "/:worksheet/:conditionalFormatting", "@sqref"), new CellRangeRefMarker("dataValidation", null, "/:worksheet/:dataValidations/:dataValidation", "@sqref", "../@count"), new CellRangeRefMarker("ignoredError", "/:worksheet/:ignoredErrors/:ignoredError", "@sqref"), new CellRangeRefMarker("protectedRange", "/:worksheet/:protectedRanges/:protectedRange", "@sqref"), new UnionCellRangeRefMarker("customSheetView/selection", "/:worksheet/:customSheetViews/:customSheetView/:selection", "@sqref"), new UnionCellRangeRefMarker("sheetView/selection", "/:worksheet/:sheetViews/:sheetView/:selection", "@sqref"), new CellRangeRefMarker("conditionalFormatting", "/:worksheet/:conditionalFormatting", "@sqref"), new CellRangeRefMarker("dataValidation", null, "/:worksheet/:dataValidations/:dataValidation", "@sqref", "../@count"), new CellRangeRefMarker("ignoredError", "/:worksheet/:ignoredErrors/:ignoredError", "@sqref"), new CellRangeRefMarker("protectedRange", "/:worksheet/:protectedRanges/:protectedRange", "@sqref"), new BreakRefMarker("rowBreaks", "//:worksheet/:rowBreaks/:brk", true), new BreakRefMarker("rowBreaks", "//:worksheet/:colBreaks/:brk", false), new ImageRefMarker()};

    public XLSXParser(File f, Document.CONFIGURATION idForDocument, XLSXDocument doc) {
        super(f, idForDocument);
        this.xlsxDocument = doc;
        this.parse();
    }

    public XLSXDocument getXLSXDocument() {
        return this.xlsxDocument;
    }

    public String getRelationshipsPath() {
        return String.valueOf(this.getPartParentRelativePath()) + "/" + "_rels" + "/" + this.getXmlFile().getName() + ".rels";
    }

    public String getPartParentRelativePath() {
        try {
            return this.getXmlFile().getParentFile().getAbsolutePath().replace(this.getXLSXDocument().getUnzipLocationDocumentFile().getCanonicalPath(), "").replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPartRelativePath() {
        try {
            return this.getXmlFile().getAbsolutePath().replace(this.getXLSXDocument().getUnzipLocationDocumentFile().getCanonicalPath(), "").replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void parse() {
        String relpath = String.valueOf(this.getPartRelativePath().replace(this.getXmlFile().getName(), "")) + "_rels/" + this.getXmlFile().getName() + ".rels";
        this.relationships = this.getXLSXDocument().getSubdocument(relpath);
        if (this.relationships != null) {
            this.relationshipsNextId = this.getNextRelationId();
        }
        this.partsDocuments = new HashMap();
        try {
            this.inlineCellStrings();
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
        ICellMarker[] iCellMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            ICellMarker marker = iCellMarkerArray[n2];
            marker.setMarks(this);
            ++n2;
        }
        this.calculateGaps();
    }

    public XMLParser loadExplicitPartDocument(String rel, String relId) throws IOException {
        return this.loadPartDocument(String.valueOf(relId) + ":" + rel, "//rel:Relationship[@Type='" + rel + "' and @Id='" + relId + "']/@Target");
    }

    public XMLParser loadImplicitPartDocument(String rel) throws IOException {
        return this.loadPartDocument(rel, "//rel:Relationship[@Type='" + rel + "']/@Target");
    }

    private XMLParser loadPartDocument(String key, String xpath) throws IOException {
        XMLParser parser = this.partsDocuments.get(key);
        if (parser == null && this.relationships != null) {
            NodeList nl;
            block6: {
                try {
                    nl = XPathXlsxUtils.evaluateNodes(this.relationships.getDocument(), xpath);
                    if (nl.getLength() != 0) break block6;
                    return null;
                }
                catch (XPathExpressionException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            String target = ((Attr)nl.item(0)).getValue();
            File f = new File(this.getXLSXDocument().getUnzipLocationDocumentFile(), target.replace("/", File.separator));
            if (!target.startsWith("/")) {
                f = new File(this.getXmlFile().getParentFile(), target).getCanonicalFile();
            }
            String relpath = f.getAbsolutePath().replace(this.getXLSXDocument().getUnzipLocationDocumentFile().getCanonicalPath(), "");
            parser = this.getXLSXDocument().getSubdocument(relpath);
            if (parser != null) {
                this.partsDocuments.put(key, parser);
            }
        }
        return parser;
    }

    public String addRelationship(String relationshipType, String target) throws IOException {
        try {
            if (this.relationships == null) {
                this.createRelationshipPart();
            }
            Element relationshipsEl = (Element)XPathXlsxUtils.evaluateNode(this.relationships.getDocument(), "/rel:Relationships");
            Element rel = (Element)relationshipsEl.appendChild(this.relationships.getDocument().createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "rel:Relationship"));
            String id = "rId" + this.relationshipsNextId;
            rel.setAttribute("Id", id);
            rel.setAttribute("Type", relationshipType);
            rel.setAttribute("Target", target.replace("/xl/", "../"));
            ++this.relationshipsNextId;
            return id;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void createRelationshipPart() throws IOException {
        this.relationships = this.getXLSXDocument().createSubdocument(this.getRelationshipsPath(), "<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"/>");
        ++this.relationshipsNextId;
    }

    public int getNextRelationId() {
        try {
            List<String> values = XPathXlsxUtils.evaluateValues(this.relationships.getDocument(), "/rel:Relationships/rel:Relationship/@Id[starts-with(.,'rId')]");
            int nextId = 1;
            int i = 0;
            while (i < values.size()) {
                String last = values.get(i).substring(3);
                try {
                    nextId = Math.max(nextId, Integer.valueOf(last));
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
            return nextId + 1;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void inlineCellStrings() throws XPathExpressionException {
        NodeList nl = XPathXlsxUtils.evaluateNodes(this.getDocument(), "//:c[./@t='s']");
        int i = 0;
        while (i < nl.getLength()) {
            Element cell = (Element)nl.item(i);
            cell.setAttribute("t", "inlineStr");
            NodeList valueNodes = cell.getElementsByTagName("v");
            Element value = (Element)valueNodes.item(0);
            int ref = Integer.valueOf(value.getTextContent());
            Element newElement = (Element)cell.insertBefore(this.getDocument().createElementNS("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "is"), value);
            cell.removeChild(value);
            NodeList cellValueNodes = this.xlsxDocument.getSharedStringNodes(ref);
            int j = 0;
            while (j < cellValueNodes.getLength()) {
                newElement.appendChild(newElement.getOwnerDocument().importNode(cellValueNodes.item(j), true));
                ++j;
            }
            ++i;
        }
    }

    private void calculateGaps() {
        this.rowReflowInfos = new LinkedHashMap();
        int rowIndex = -1;
        NodeList rows = null;
        try {
            rows = XPathXlsxUtils.evaluateNodes(this.getDocument(), "//:row");
        }
        catch (XPathExpressionException xPathExpressionException) {
            return;
        }
        int i = 0;
        while (i < rows.getLength()) {
            Element row = (Element)rows.item(i);
            int newRowIndex = Integer.valueOf(row.getAttribute("r")) - 1;
            RowReflowInfo rrInfo = new RowReflowInfo(newRowIndex);
            rrInfo.prevRowsGap = newRowIndex - rowIndex;
            this.rowReflowInfos.put(newRowIndex, rrInfo);
            rowIndex = newRowIndex;
            NodeList columns = row.getElementsByTagName("c");
            int colIndex = -1;
            rrInfo.cellReflowInfos = new LinkedHashMap();
            int j = 0;
            while (j < columns.getLength()) {
                Element column = (Element)columns.item(j);
                CellRef ref = new CellRef(column.getAttribute("r"));
                int newColIndex = ref.getCol();
                CellReflowInfo crInfo = new CellReflowInfo(ref);
                crInfo.prevCellGap = newColIndex - colIndex;
                rrInfo.cellReflowInfos.put(ref, crInfo);
                colIndex = newColIndex;
                ++j;
            }
            ++i;
        }
    }

    public void layoutCells() {
        int minRow = Integer.MAX_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxCol = 0;
        int curRow = 0;
        NodeList rows = this.getDocument().getElementsByTagName("row");
        int i = 0;
        while (i < rows.getLength()) {
            Element row = (Element)rows.item(i);
            int rowIndex = Integer.valueOf(row.getAttribute("r")) - 1;
            int rowDiff = this.getPreviousRowGap(rowIndex);
            curRow += rowDiff;
            NodeList columns = row.getElementsByTagName("c");
            int curCol = 0;
            int j = 0;
            while (j < columns.getLength()) {
                Element column = (Element)columns.item(j);
                CellRef ref = new CellRef(column.getAttribute("r"));
                int n = this.getPreviousCellGap(ref);
                maxCol = Math.max(maxCol, (curCol += n) - 1);
                CellRef newRef = new CellRef(curRow - 1, curCol - 1);
                column.setAttribute("r", newRef.getRef());
                this.mapCells(ref, newRef);
                ++j;
            }
            row.setAttribute("r", String.valueOf(curRow));
            row.removeAttribute("spans");
            if (row.getTextContent().contains("<drop/>")) {
                --curRow;
            }
            ++i;
        }
        if (minRow == Integer.MAX_VALUE) {
            minRow = 0;
        }
        if (minCol == Integer.MAX_VALUE) {
            minCol = 0;
        }
        try {
            XPathXlsxUtils.evaluateNode(this.getDocument(), "/:worksheet/:dimension/@ref").setNodeValue(String.valueOf(new CellRef(minRow, minCol).getRef()) + ":" + new CellRef(curRow, maxCol).getRef());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        ICellMarker[] iCellMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            ICellMarker marker = iCellMarkerArray[n2];
            List<CellMark> marks = marker.getAppliedMarks(this);
            if (marker instanceof ICellRefMarker) {
                Map<CellRef, Map<String, Set<CellMark>>> markMap = this.getMarksByCellRef(marks);
                LinkedHashSet<CellRef> sourceCells = new LinkedHashSet<CellRef>();
                for (Map<String, Set<CellMark>> m1 : markMap.values()) {
                    for (Set set : m1.values()) {
                        for (CellMark m : set) {
                            sourceCells.add(m.src);
                        }
                    }
                }
                for (CellRef source : sourceCells) {
                    RowReflowInfo rowReflowInfo = this.rowReflowInfos.get(source.getRow());
                    CellReflowInfo crInfo = rowReflowInfo.cellReflowInfos.get(source);
                    HashMap marksByPath = new HashMap();
                    for (CellRef r : crInfo.reflowedCells) {
                        Map<String, Set<CellMark>> tmpMap = markMap.get(r);
                        if (tmpMap == null) continue;
                        for (Map.Entry<String, Set<CellMark>> e : tmpMap.entrySet()) {
                            ArrayList l = (ArrayList)marksByPath.get(e.getKey());
                            if (l == null) {
                                l = new ArrayList();
                                marksByPath.put(e.getKey(), l);
                            }
                            l.addAll(e.getValue());
                        }
                    }
                    for (List ms : marksByPath.values()) {
                        ((ICellRefMarker)marker).layoutCellReference(this, source, ms);
                    }
                }
            } else {
                marker.layoutCells(this, marks);
            }
            marker.cleanup(this);
            ++n2;
        }
    }

    public void handleDropCellReferences() {
        try {
            HashSet<String> cellRefs = new HashSet<String>(XPathXlsxUtils.evaluateValues(this.getDocument(), "//:row/:c/@r"));
            ICellMarker[] iCellMarkerArray = this.markers;
            int n = this.markers.length;
            int n2 = 0;
            while (n2 < n) {
                ICellMarker marker = iCellMarkerArray[n2];
                if (marker instanceof ICellRefMarker) {
                    ICellRefMarker cellMarker = (ICellRefMarker)marker;
                    cellMarker.verifyCellReference(this, cellRefs);
                }
                ++n2;
            }
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Map<CellRef, Map<String, Set<CellMark>>> getMarksByCellRef(List<CellMark> marks) {
        LinkedHashMap<CellRef, Map<String, Set<CellMark>>> map = new LinkedHashMap<CellRef, Map<String, Set<CellMark>>>();
        for (CellMark m : marks) {
            LinkedHashSet<CellMark> cmList;
            LinkedHashMap<String, LinkedHashSet<CellMark>> cmLMap = (LinkedHashMap<String, LinkedHashSet<CellMark>>)map.get(m.cell);
            if (cmLMap == null) {
                cmLMap = new LinkedHashMap<String, LinkedHashSet<CellMark>>();
                map.put(m.cell, cmLMap);
            }
            if ((cmList = (LinkedHashSet<CellMark>)cmLMap.get(m.path)) == null) {
                cmList = new LinkedHashSet<CellMark>();
                cmLMap.put(m.path, cmList);
            }
            cmList.add(m);
        }
        return map;
    }

    private void mapCells(CellRef origRef, CellRef newRef) {
        RowReflowInfo rowReflowInfo = this.rowReflowInfos.get(origRef.getRow());
        if (rowReflowInfo.reflowedRows == null) {
            rowReflowInfo.reflowedRows = new ArrayList<Integer>();
        }
        rowReflowInfo.reflowedRows.add(newRef.getCol());
        CellReflowInfo cellReflowInfo = rowReflowInfo.cellReflowInfos.get(origRef);
        if (cellReflowInfo.reflowedCells == null) {
            cellReflowInfo.reflowedCells = new ArrayList<CellRef>();
        }
        cellReflowInfo.reflowedCells.add(newRef);
    }

    private int getPreviousCellGap(CellRef ref) {
        RowReflowInfo rrInfo = this.rowReflowInfos.get(ref.getRow());
        CellReflowInfo crInfo = rrInfo.cellReflowInfos.get(ref);
        return crInfo.prevCellGap;
    }

    private int getPreviousRowGap(int rowIndex) {
        RowReflowInfo rrInfo = this.rowReflowInfos.get(rowIndex);
        return rrInfo.prevRowsGap;
    }

    public int calculateColumnWidth(int nColumn) {
        try {
            Element colEl = (Element)XPathXlsxUtils.evaluateNode(this.getDocument(), "/:worksheet/:cols/:col[@min <= " + nColumn + " and @max >= " + nColumn + "]");
            double width = 0.0;
            int styleIndex = 0;
            if (colEl != null) {
                styleIndex = colEl.hasAttribute("style") ? Integer.valueOf(colEl.getAttribute("style")) : 0;
                width = colEl.hasAttribute("width") ? Double.valueOf(colEl.getAttribute("width")) : 8.0;
            } else {
                width = XPathXlsxUtils.evaluateNumber((Node)this.getDocument(), "/:worksheet/:sheetFormatPr/@defaultColWidth", 0.0);
                if (width == 0.0) {
                    width = XPathXlsxUtils.evaluateNumber((Node)this.getDocument(), "/:worksheet/:sheetFormatPr/@baseColWidth", 8.0);
                    width += 5.0;
                }
            }
            XMLParser stylePart = this.getXLSXDocument().getSubdocument("/xl/styles.xml");
            int fontIndex = XPathXlsxUtils.evaluateNumber((Node)stylePart.getDocument(), "/:styleSheet/:cellStyleXfs/:xf[" + (styleIndex + 1) + "]/@fontId", 0);
            Element fontEl = (Element)XPathXlsxUtils.evaluateNode(stylePart.getDocument(), "/:styleSheet/:fonts/:font[" + (fontIndex + 1) + "]");
            String fontName = XPathXlsxUtils.evaluateText(fontEl, "./:name/@val");
            boolean bold = Boolean.valueOf(XPathXlsxUtils.evaluateText(fontEl, "./:b/@val"));
            boolean italic = Boolean.valueOf(XPathXlsxUtils.evaluateText(fontEl, "./:i/@val"));
            float sz = XPathXlsxUtils.evaluateNumber((Node)fontEl, "./:sz/@val", 11.0f);
            Font f = new Font(fontName, (bold ? 1 : 0) | (italic ? 2 : 0), (int)sz).deriveFont(sz);
            double max = -1.0;
            GlyphVector gv = f.createGlyphVector(new FontRenderContext(null, true, true), "0123456789");
            int i = 0;
            while (i <= 9) {
                GlyphMetrics gm = gv.getGlyphMetrics(i);
                Rectangle2D bb = gm.getBounds2D();
                max = Math.max(max, bb.getWidth());
                ++i;
            }
            return (int)((256.0 * width + (double)((int)(128.0 / max))) / 256.0 * max);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int calculateRowHeight(int nRow) {
        try {
            double sheetFormatEl = XPathXlsxUtils.evaluateNumber((Node)this.getDocument(), "/:worksheet/:sheetFormatPr/@defaultRowHeight", 0.0);
            int defHeight = (int)UnitsHelper.convertToPixels((UnitsHelper.Unit)UnitsHelper.Unit.POINT, (double)sheetFormatEl, (int)96);
            Element rowEl = (Element)XPathXlsxUtils.evaluateNode(this.getDocument(), "/:worksheet/:sheetData/:row[@r=" + nRow + "]");
            if (rowEl.hasAttribute("ht")) {
                return (int)UnitsHelper.convertToPixels((UnitsHelper.Unit)UnitsHelper.Unit.POINT, (double)Double.valueOf(rowEl.getAttribute("ht")), (int)96);
            }
            return defHeight;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class CellReflowInfo {
        CellRef ref;
        int prevCellGap;
        List<CellRef> reflowedCells;

        public CellReflowInfo(CellRef ref) {
            this.ref = ref;
        }
    }

    private static class RowReflowInfo {
        int row;
        int prevRowsGap;
        List<Integer> reflowedRows;
        LinkedHashMap<CellRef, CellReflowInfo> cellReflowInfos;

        public RowReflowInfo(int row) {
            this.row = row;
        }
    }
}

