/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.ITagExtension;
import org.eclipse.gendoc.tags.ITagExtensionService;
import org.eclipse.gendoc.tags.ITagHandler;
import org.eclipse.gendoc.tags.handlers.ITagHandlerService;

public class TagHandlerService
extends AbstractService
implements ITagHandlerService {
    private Map<String, ITagHandler> tagHandlers = new HashMap<String, ITagHandler>();

    public void clear() {
        super.clear();
        this.tagHandlers.clear();
    }

    @Override
    public ITagHandler getHandlerFor(ITag tag) {
        return this.getHandlerFor(tag.getName());
    }

    @Override
    public ITagHandler getHandlerFor(String tagName) {
        ITagExtensionService tagsExtensionService;
        ITagExtension tagExtension;
        ITagHandler tagHandler = this.tagHandlers.get(tagName);
        if (tagName != null && tagHandler == null && (tagExtension = (tagsExtensionService = (ITagExtensionService)GendocServices.getDefault().getService(ITagExtensionService.class)).getTagExtension(tagName)) != null) {
            tagHandler = tagExtension.getHandler();
            this.tagHandlers.put(tagName, tagHandler);
        }
        return tagHandler;
    }
}

