/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.process.buffers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.tags.handlers.process.buffers.ITagAnalyserBuffer;
import org.w3c.dom.Node;

public class FileAnalyserBuffer
extends AbstractService
implements ITagAnalyserBuffer {
    List<BufferStruct> listOfBuffers = new ArrayList<BufferStruct>();

    @Override
    public void bufferize(Document document, Node currentNode, StringBuffer finalText, List<Node> nodesList) {
        BufferStruct buf = new BufferStruct(document, currentNode, finalText, nodesList);
        this.listOfBuffers.add(buf);
    }

    @Override
    public void flush() {
        Iterator<BufferStruct> i = this.listOfBuffers.iterator();
        while (i.hasNext()) {
            BufferStruct b = i.next();
            IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
            try {
                Node sibling = documentService.injectNode(b.currentNode, b.getFinalText());
                for (Node node : b.nodesList) {
                    node.getParentNode().removeChild(node);
                }
                b.document.getXMLParser().setCurrentNode(sibling);
            }
            catch (InvalidContentException e) {
                e.printStackTrace();
            }
            i.remove();
        }
    }

    private static class BufferStruct {
        private final Document document;
        private final Node currentNode;
        private String filePath;
        private final List<Node> nodesList;

        public BufferStruct(Document document, Node currentNode, StringBuffer finalText, List<Node> nodesList) {
            block12: {
                this.filePath = null;
                this.document = document;
                this.currentNode = currentNode;
                this.nodesList = nodesList;
                BufferedWriter writer = null;
                try {
                    try {
                        File f = File.createTempFile("gendoc2", null);
                        f.deleteOnExit();
                        this.filePath = f.getAbsolutePath();
                        FileWriter fileWriter = new FileWriter(f);
                        writer = new BufferedWriter(fileWriter);
                        writer.write(finalText.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (writer == null) break block12;
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        public String getFinalText() {
            StringBuffer buffer;
            block15: {
                String lineSeparator = System.getProperty("line.separator");
                buffer = new StringBuffer();
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(new File(this.filePath)));
                        String tmp = reader.readLine();
                        while (tmp != null) {
                            buffer.append(tmp);
                            buffer.append(lineSeparator);
                            tmp = reader.readLine();
                        }
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return buffer.toString();
        }
    }
}

