/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.p3order.IConstraintResolver;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForsterConstraintResolver
implements IConstraintResolver {
    private Multimap<LNode, LNode> layoutUnits;

    public ForsterConstraintResolver(Multimap<LNode, LNode> layoutUnits) {
        this.layoutUnits = layoutUnits;
    }

    @Override
    public void processConstraints(List<NodeGroup> nodeGroups, int layerIndex) {
        this.buildConstraintsGraph(nodeGroups);
        Pair<NodeGroup, NodeGroup> violatedConstraint = null;
        while ((violatedConstraint = this.findViolatedConstraint(nodeGroups)) != null) {
            this.handleViolatedConstraint((NodeGroup)violatedConstraint.getFirst(), (NodeGroup)violatedConstraint.getSecond(), nodeGroups);
        }
    }

    private void buildConstraintsGraph(List<NodeGroup> nodeGroups) {
        for (NodeGroup nodeGroup : nodeGroups) {
            nodeGroup.resetOutgoingConstraints();
            nodeGroup.incomingConstraintsCount = 0;
        }
        LNode lastNonDummyNode = null;
        for (NodeGroup nodeGroup : nodeGroups) {
            LNode node = nodeGroup.getNode();
            LNode successor = (LNode)node.getProperty(Properties.IN_LAYER_SUCCESSOR_CONSTRAINT);
            if (successor != null) {
                NodeGroup successorNodeGroup = (NodeGroup)successor.getProperty(Properties.NODE_GROUP);
                nodeGroup.getOutgoingConstraints().add(successorNodeGroup);
                ++successorNodeGroup.incomingConstraintsCount;
            }
            if (node.getProperty(Properties.NODE_TYPE) != NodeType.NORMAL) continue;
            if (lastNonDummyNode != null) {
                for (LNode lastUnitNode : this.layoutUnits.get((Object)lastNonDummyNode)) {
                    NodeGroup lastUnitNodeGroup = (NodeGroup)lastUnitNode.getProperty(Properties.NODE_GROUP);
                    for (LNode currentUnitNode : this.layoutUnits.get((Object)node)) {
                        NodeGroup currentUnitNodeGroup = (NodeGroup)currentUnitNode.getProperty(Properties.NODE_GROUP);
                        lastUnitNodeGroup.getOutgoingConstraints().add(currentUnitNodeGroup);
                        ++currentUnitNodeGroup.incomingConstraintsCount;
                    }
                }
            }
            lastNonDummyNode = node;
        }
    }

    private Pair<NodeGroup, NodeGroup> findViolatedConstraint(List<NodeGroup> nodeGroups) {
        LinkedList<NodeGroup> activeNodeGroups = null;
        float lastValue = -32768.0f;
        for (NodeGroup nodeGroup : nodeGroups) {
            assert (nodeGroup.barycenter != null && nodeGroup.barycenter.floatValue() >= lastValue);
            lastValue = nodeGroup.barycenter.floatValue();
            nodeGroup.resetIncomingConstraints();
            if (!nodeGroup.hasOutgoingConstraints() || nodeGroup.incomingConstraintsCount != 0) continue;
            if (activeNodeGroups == null) {
                activeNodeGroups = new LinkedList<NodeGroup>();
            }
            activeNodeGroups.add(nodeGroup);
        }
        if (activeNodeGroups != null) {
            while (!activeNodeGroups.isEmpty()) {
                NodeGroup nodeGroup;
                nodeGroup = (NodeGroup)activeNodeGroups.remove(0);
                if (nodeGroup.hasIncomingConstraints()) {
                    for (NodeGroup predecessor : nodeGroup.getIncomingConstraints()) {
                        if (!(predecessor.barycenter.floatValue() == nodeGroup.barycenter.floatValue() ? nodeGroups.indexOf(predecessor) > nodeGroups.indexOf(nodeGroup) : predecessor.barycenter.floatValue() > nodeGroup.barycenter.floatValue())) continue;
                        return Pair.create((Object)predecessor, (Object)nodeGroup);
                    }
                }
                for (NodeGroup successor : nodeGroup.getOutgoingConstraints()) {
                    List<NodeGroup> successorIncomingList = successor.getIncomingConstraints();
                    successorIncomingList.add(0, nodeGroup);
                    if (successor.incomingConstraintsCount != successorIncomingList.size()) continue;
                    activeNodeGroups.add(successor);
                }
            }
        }
        return null;
    }

    private void handleViolatedConstraint(NodeGroup firstNodeGroup, NodeGroup secondNodeGroup, List<NodeGroup> nodeGroups) {
        NodeGroup newNodeGroup = new NodeGroup(firstNodeGroup, secondNodeGroup);
        assert (newNodeGroup.barycenter.floatValue() >= secondNodeGroup.barycenter.floatValue());
        assert (newNodeGroup.barycenter.floatValue() <= firstNodeGroup.barycenter.floatValue());
        ListIterator<NodeGroup> nodeGroupIterator = nodeGroups.listIterator();
        boolean alreadyInserted = false;
        while (nodeGroupIterator.hasNext()) {
            NodeGroup nodeGroup = nodeGroupIterator.next();
            if (nodeGroup == firstNodeGroup || nodeGroup == secondNodeGroup) {
                nodeGroupIterator.remove();
                continue;
            }
            if (!alreadyInserted && nodeGroup.barycenter.floatValue() > newNodeGroup.barycenter.floatValue()) {
                nodeGroupIterator.previous();
                nodeGroupIterator.add(newNodeGroup);
                alreadyInserted = true;
                continue;
            }
            if (!nodeGroup.hasOutgoingConstraints()) continue;
            boolean firstNodeGroupConstraint = nodeGroup.getOutgoingConstraints().remove(firstNodeGroup);
            boolean secondNodeGroupConstraint = nodeGroup.getOutgoingConstraints().remove(secondNodeGroup);
            if (!firstNodeGroupConstraint && !secondNodeGroupConstraint) continue;
            nodeGroup.getOutgoingConstraints().add(newNodeGroup);
            ++newNodeGroup.incomingConstraintsCount;
        }
        if (!alreadyInserted) {
            nodeGroups.add(newNodeGroup);
        }
    }
}

