/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p3order.IConstraintResolver;
import de.cau.cs.kieler.klay.layered.p3order.ICrossingMinimizationHeuristic;
import de.cau.cs.kieler.klay.layered.p3order.NodeGroup;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarycenterHeuristic
implements ICrossingMinimizationHeuristic {
    private float[] portRanks;
    private Random random;
    private IConstraintResolver constraintResolver;
    private static final float RANDOM_AMOUNT = 0.07f;

    public BarycenterHeuristic(IConstraintResolver constraintResolver, Random graphRandom, float[] portRanks) {
        this.constraintResolver = constraintResolver;
        this.random = graphRandom;
        this.portRanks = portRanks;
    }

    @Override
    public void minimizeCrossings(List<NodeGroup> layer, int layerIndex, boolean preOrdered, boolean randomize, boolean forward) {
        if (randomize) {
            this.randomizeBarycenters(layer);
        } else {
            this.calculateBarycenters(layer, forward);
            this.fillInUnknownBarycenters(layer, preOrdered);
        }
        if (layer.size() > 1) {
            Collections.sort(layer);
            this.constraintResolver.processConstraints(layer, layerIndex);
        }
    }

    private void randomizeBarycenters(List<NodeGroup> nodeGroups) {
        for (NodeGroup nodeGroup : nodeGroups) {
            if (nodeGroup.getNodes().length != 1) continue;
            nodeGroup.barycenter = Float.valueOf(this.random.nextFloat());
            nodeGroup.summedWeight = nodeGroup.barycenter.floatValue();
            nodeGroup.degree = 1;
        }
    }

    private void fillInUnknownBarycenters(List<NodeGroup> nodeGroups, boolean preOrdered) {
        if (preOrdered) {
            float lastValue = -1.0f;
            ListIterator<NodeGroup> nodeGroupIterator = nodeGroups.listIterator();
            while (nodeGroupIterator.hasNext()) {
                NodeGroup nodeGroup = nodeGroupIterator.next();
                Float value = nodeGroup.barycenter;
                if (value == null) {
                    float nextValue = lastValue + 1.0f;
                    ListIterator<NodeGroup> nextNodeGroupIterator = nodeGroups.listIterator(nodeGroupIterator.nextIndex());
                    while (nextNodeGroupIterator.hasNext()) {
                        Float x = nextNodeGroupIterator.next().barycenter;
                        if (x == null) continue;
                        nextValue = x.floatValue();
                        break;
                    }
                    nodeGroup.barycenter = value = Float.valueOf((lastValue + nextValue) / 2.0f);
                    nodeGroup.summedWeight = value.floatValue();
                    nodeGroup.degree = 1;
                }
                lastValue = value.floatValue();
            }
        } else {
            float maxBary = 0.0f;
            for (NodeGroup nodeGroup : nodeGroups) {
                if (nodeGroup.barycenter == null) continue;
                maxBary = Math.max(maxBary, nodeGroup.barycenter.floatValue());
            }
            maxBary += 2.0f;
            for (NodeGroup nodeGroup : nodeGroups) {
                if (nodeGroup.barycenter != null) continue;
                float value = this.random.nextFloat() * maxBary - 1.0f;
                nodeGroup.barycenter = Float.valueOf(value);
                nodeGroup.summedWeight = value;
                nodeGroup.degree = 1;
            }
        }
    }

    private void calculateBarycenters(List<NodeGroup> nodeGroups, boolean forward) {
        for (NodeGroup nodeGroup : nodeGroups) {
            nodeGroup.visited = false;
        }
        for (NodeGroup nodeGroup : nodeGroups) {
            if (nodeGroup.getNodes().length != 1) continue;
            this.calculateBarycenter(nodeGroup, forward);
        }
    }

    private void calculateBarycenter(NodeGroup nodeGroup, boolean forward) {
        if (nodeGroup.visited) {
            return;
        }
        nodeGroup.visited = true;
        nodeGroup.degree = 0;
        nodeGroup.summedWeight = 0.0f;
        nodeGroup.barycenter = null;
        LNode node = nodeGroup.getNode();
        for (LPort freePort : node.getPorts()) {
            Iterable<LPort> portIterable = forward ? freePort.getPredecessorPorts() : freePort.getSuccessorPorts();
            for (LPort fixedPort : portIterable) {
                LNode fixedNode = fixedPort.getNode();
                if (fixedNode.getLayer() == node.getLayer()) {
                    if (fixedNode == node) continue;
                    NodeGroup fixedNodeGroup = (NodeGroup)fixedNode.getProperty(Properties.NODE_GROUP);
                    this.calculateBarycenter(fixedNodeGroup, forward);
                    nodeGroup.degree += fixedNodeGroup.degree;
                    nodeGroup.summedWeight += fixedNodeGroup.summedWeight;
                    continue;
                }
                nodeGroup.summedWeight += this.portRanks[fixedPort.id];
                ++nodeGroup.degree;
            }
        }
        List barycenterAssociates = (List)node.getProperty(Properties.BARYCENTER_ASSOCIATES);
        if (barycenterAssociates != null) {
            for (LNode associate : barycenterAssociates) {
                if (node.getLayer() != associate.getLayer()) continue;
                NodeGroup associateNodeGroup = (NodeGroup)associate.getProperty(Properties.NODE_GROUP);
                this.calculateBarycenter(associateNodeGroup, forward);
                nodeGroup.degree += associateNodeGroup.degree;
                nodeGroup.summedWeight += associateNodeGroup.summedWeight;
            }
        }
        if (nodeGroup.degree > 0) {
            nodeGroup.summedWeight += this.random.nextFloat() * 0.07f - 0.035f;
            nodeGroup.barycenter = Float.valueOf(nodeGroup.summedWeight / (float)nodeGroup.degree);
        }
    }
}

