/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p2layers;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkSimplexLayerer
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration BASELINE_PROCESSING_CONFIGURATION = new IntermediateProcessingConfiguration(EnumSet.of(LayoutProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER), null, EnumSet.of(LayoutProcessorStrategy.LAYER_CONSTRAINT_PROCESSOR), null, null, null);
    private static final IntermediateProcessingConfiguration BIG_NODES_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(1, LayoutProcessorStrategy.BIG_NODES_PROCESSOR);
    private LGraph layeredGraph;
    private Collection<LNode> nodes;
    private List<LEdge> edges;
    private List<LNode> componentNodes;
    private List<LNode> sources;
    private List<LNode> sinks;
    private int[] inDegree;
    private int[] outDegree;
    private int[] layer;
    private int[] revLayer;
    private int[] minSpan;
    private boolean[] treeNode;
    private boolean[] treeEdge;
    private boolean[] edgeVisited;
    private boolean[] nodeVisited;
    private int postOrder;
    private int[] poID;
    private int[] lowestPoID;
    private int[] cutvalue;
    private Map<LEdge, Pair<LPort, LPort>> removedSelfLoops;
    private static final int ITER_LIMIT_FACTOR = 4;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration strategy = new IntermediateProcessingConfiguration(BASELINE_PROCESSING_CONFIGURATION);
        if (((Boolean)graph.getProperty(Properties.DISTRIBUTE_NODES)).booleanValue()) {
            strategy.addAll(BIG_NODES_PROCESSING_ADDITIONS);
        }
        return strategy;
    }

    private List<List<LNode>> connectedComponents(Collection<LNode> theNodes) {
        if (this.nodeVisited == null || this.nodeVisited.length < theNodes.size()) {
            this.nodeVisited = new boolean[theNodes.size()];
        } else {
            Arrays.fill(this.nodeVisited, false);
        }
        this.componentNodes = new LinkedList<LNode>();
        int counter = 0;
        for (LNode node : theNodes) {
            node.id = counter++;
        }
        LinkedList<List<LNode>> components = new LinkedList<List<LNode>>();
        for (LNode node : theNodes) {
            if (this.nodeVisited[node.id]) continue;
            this.connectedComponentsDFS(node);
            if (components.isEmpty() || components.getFirst().size() < this.componentNodes.size()) {
                components.addFirst(this.componentNodes);
            } else {
                components.addLast(this.componentNodes);
            }
            this.componentNodes = new LinkedList<LNode>();
        }
        return components;
    }

    private void connectedComponentsDFS(LNode node) {
        this.nodeVisited[node.id] = true;
        this.componentNodes.add(node);
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getConnectedEdges()) {
                LNode opposite = this.getOpposite(port, edge).getNode();
                if (this.nodeVisited[opposite.id]) continue;
                this.connectedComponentsDFS(opposite);
            }
        }
    }

    private void initialize(Collection<LNode> theNodes) {
        int numNodes = theNodes.size();
        this.inDegree = new int[numNodes];
        this.outDegree = new int[numNodes];
        this.layer = new int[numNodes];
        this.revLayer = new int[numNodes];
        this.treeNode = new boolean[numNodes];
        this.poID = new int[numNodes];
        this.lowestPoID = new int[numNodes];
        Arrays.fill(this.revLayer, numNodes);
        this.sources = new LinkedList<LNode>();
        this.sinks = new LinkedList<LNode>();
        this.nodes = theNodes;
        int index = 0;
        LinkedList<LEdge> theEdges = new LinkedList<LEdge>();
        for (LNode node : theNodes) {
            node.id = index++;
            for (LPort lPort : node.getPorts()) {
                for (LEdge edge : lPort.getOutgoingEdges()) {
                    if (edge.getSource().getNode() == edge.getTarget().getNode()) {
                        this.removedSelfLoops.put(edge, (Pair<LPort, LPort>)new Pair((Object)edge.getSource(), (Object)edge.getTarget()));
                        continue;
                    }
                    theEdges.add(edge);
                    int n = node.id;
                    this.outDegree[n] = this.outDegree[n] + 1;
                }
                for (LEdge edge : lPort.getIncomingEdges()) {
                    if (edge.getSource().getNode() == edge.getTarget().getNode()) {
                        this.removedSelfLoops.put(edge, (Pair<LPort, LPort>)new Pair((Object)edge.getSource(), (Object)edge.getTarget()));
                        continue;
                    }
                    int n = node.id;
                    this.inDegree[n] = this.inDegree[n] + 1;
                }
            }
            if (this.outDegree[node.id] == 0) {
                this.sinks.add(node);
            }
            if (this.inDegree[node.id] != 0) continue;
            this.sources.add(node);
        }
        int counter = 0;
        for (LEdge edge : theEdges) {
            edge.id = counter++;
        }
        int numEdges = theEdges.size();
        if (this.cutvalue == null || this.cutvalue.length < numEdges) {
            this.cutvalue = new int[numEdges];
            this.minSpan = new int[numEdges];
            this.treeEdge = new boolean[numEdges];
            this.edgeVisited = new boolean[numEdges];
        } else {
            Arrays.fill(this.treeEdge, false);
            Arrays.fill(this.edgeVisited, false);
        }
        this.edges = theEdges;
        this.postOrder = 1;
        for (LEdge lEdge : this.removedSelfLoops.keySet()) {
            lEdge.setSource(null);
            lEdge.setTarget(null);
        }
    }

    private void restoreSelfLoops() {
        for (LEdge edge : this.removedSelfLoops.keySet()) {
            Pair<LPort, LPort> endpoints = this.removedSelfLoops.get(edge);
            edge.setSource((LPort)endpoints.getFirst());
            edge.setTarget((LPort)endpoints.getSecond());
        }
    }

    private void dispose() {
        this.componentNodes = null;
        this.cutvalue = null;
        this.edges = null;
        this.edgeVisited = null;
        this.inDegree = null;
        this.layer = null;
        this.layeredGraph = null;
        this.lowestPoID = null;
        this.minSpan = null;
        this.nodes = null;
        this.nodeVisited = null;
        this.outDegree = null;
        this.poID = null;
        this.revLayer = null;
        this.sinks = null;
        this.sources = null;
        this.treeEdge = null;
        this.treeNode = null;
        this.removedSelfLoops = null;
    }

    @Override
    public void process(LGraph theLayeredGraph) {
        assert (theLayeredGraph != null);
        this.getMonitor().begin("Network-Simplex Layering", 1.0f);
        this.layeredGraph = theLayeredGraph;
        this.removedSelfLoops = new HashMap<LEdge, Pair<LPort, LPort>>();
        int thoroughness = (Integer)theLayeredGraph.getProperty(Properties.THOROUGHNESS) * 4;
        List<LNode> theNodes = this.layeredGraph.getLayerlessNodes();
        if (theNodes.size() < 1) {
            this.getMonitor().done();
            return;
        }
        for (List<LNode> connComp : this.connectedComponents(theNodes)) {
            int iterLimit = thoroughness * (int)(Math.sqrt(connComp.size()) + 1.0);
            this.initialize(connComp);
            this.feasibleTree();
            LEdge e = this.leaveEdge();
            int iter = 0;
            while (e != null && iter < iterLimit) {
                this.exchange(e, this.enterEdge(e));
                e = this.leaveEdge();
                ++iter;
            }
            if (((Boolean)this.layeredGraph.getProperty(Properties.DISTRIBUTE_NODES)).booleanValue()) {
                this.normalize();
            } else {
                this.balance(this.normalize());
            }
            for (LNode node : this.nodes) {
                this.putNode(node);
            }
        }
        this.restoreSelfLoops();
        theNodes.clear();
        this.dispose();
        this.getMonitor().done();
    }

    private void feasibleTree() {
        this.initLayering();
        if (this.edges.size() > 0) {
            Arrays.fill(this.edgeVisited, false);
            while (this.tightTreeDFS(this.nodes.iterator().next()) < this.nodes.size()) {
                LEdge e = this.minimalSlack();
                int slack = this.layer[e.getTarget().getNode().id] - this.layer[e.getSource().getNode().id] - this.minSpan[e.id];
                if (this.treeNode[e.getTarget().getNode().id]) {
                    slack = -slack;
                }
                for (LNode node : this.nodes) {
                    if (!this.treeNode[node.id]) continue;
                    int n = node.id;
                    this.layer[n] = this.layer[n] + slack;
                }
                Arrays.fill(this.edgeVisited, false);
            }
            Arrays.fill(this.edgeVisited, false);
            this.postorderTraversal(this.nodes.iterator().next());
            this.cutvalues();
        }
    }

    private void initLayering() {
        for (LNode node : this.sources) {
            this.layeringDFS(node, false);
        }
        for (LNode node : this.sinks) {
            this.layeringDFS(node, true);
        }
        int min = Integer.MAX_VALUE;
        for (LNode node : this.nodes) {
            if (min <= this.revLayer[node.id]) continue;
            min = this.revLayer[node.id];
        }
        for (LNode node : this.nodes) {
            int n = node.id;
            this.revLayer[n] = this.revLayer[n] - min;
        }
        for (LEdge edge : this.edges) {
            this.minSpan[edge.id] = this.layer[edge.getTarget().getNode().id] <= this.revLayer[edge.getSource().getNode().id] ? 1 : Math.min(this.layer[edge.getTarget().getNode().id] - this.layer[edge.getSource().getNode().id], Math.min(this.revLayer[edge.getTarget().getNode().id] - this.revLayer[edge.getSource().getNode().id], this.layer[edge.getTarget().getNode().id] - this.revLayer[edge.getSource().getNode().id]));
        }
    }

    private void layeringDFS(LNode node, boolean reverse) {
        LNode target = null;
        if (reverse) {
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getIncomingEdges()) {
                    target = edge.getSource().getNode();
                    this.revLayer[target.id] = Math.min(this.revLayer[target.id], this.revLayer[node.id] - 1);
                    this.layeringDFS(target, true);
                }
            }
        } else {
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    target = edge.getTarget().getNode();
                    this.layer[target.id] = Math.max(this.layer[target.id], this.layer[node.id] + 1);
                    this.layeringDFS(target, false);
                }
            }
        }
    }

    private Pair<Integer, Integer> minimalSpan(LNode node) {
        int minSpanOut = Integer.MAX_VALUE;
        int minSpanIn = Integer.MAX_VALUE;
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getConnectedEdges()) {
                int currentSpan = this.layer[edge.getTarget().getNode().id] - this.layer[edge.getSource().getNode().id];
                if (edge.getTarget() == port && currentSpan < minSpanIn) {
                    minSpanIn = currentSpan;
                    continue;
                }
                if (currentSpan >= minSpanOut) continue;
                minSpanOut = currentSpan;
            }
        }
        if (minSpanIn == Integer.MAX_VALUE) {
            minSpanIn = -1;
        }
        if (minSpanOut == Integer.MAX_VALUE) {
            minSpanOut = -1;
        }
        return new Pair((Object)minSpanIn, (Object)minSpanOut);
    }

    private int tightTreeDFS(LNode node) {
        int nodeCount = 1;
        this.treeNode[node.id] = true;
        LNode opposite = null;
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getConnectedEdges()) {
                if (this.edgeVisited[edge.id]) continue;
                this.edgeVisited[edge.id] = true;
                opposite = this.getOpposite(port, edge).getNode();
                if (this.treeEdge[edge.id]) {
                    nodeCount += this.tightTreeDFS(opposite);
                    continue;
                }
                if (this.treeNode[opposite.id] || this.minSpan[edge.id] != this.layer[edge.getTarget().getNode().id] - this.layer[edge.getSource().getNode().id]) continue;
                this.treeEdge[edge.id] = true;
                nodeCount += this.tightTreeDFS(opposite);
            }
        }
        return nodeCount;
    }

    private LEdge minimalSlack() {
        int minSlack = Integer.MAX_VALUE;
        LEdge minSlackEdge = null;
        for (LEdge edge : this.edges) {
            int curSlack;
            if (!(this.treeNode[edge.getSource().getNode().id] ^ this.treeNode[edge.getTarget().getNode().id]) || (curSlack = this.layer[edge.getTarget().getNode().id] - this.layer[edge.getSource().getNode().id] - this.minSpan[edge.id]) >= minSlack) continue;
            minSlack = curSlack;
            minSlackEdge = edge;
        }
        return minSlackEdge;
    }

    private int postorderTraversal(LNode node) {
        int lowest = Integer.MAX_VALUE;
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getConnectedEdges()) {
                if (!this.treeEdge[edge.id] || this.edgeVisited[edge.id]) continue;
                this.edgeVisited[edge.id] = true;
                lowest = Math.min(lowest, this.postorderTraversal(this.getOpposite(port, edge).getNode()));
            }
        }
        this.poID[node.id] = this.postOrder;
        this.lowestPoID[node.id] = Math.min(lowest, this.postOrder++);
        return this.lowestPoID[node.id];
    }

    private boolean isInHead(LNode node, LEdge edge) {
        LNode source = edge.getSource().getNode();
        LNode target = edge.getTarget().getNode();
        if (this.lowestPoID[source.id] <= this.poID[node.id] && this.poID[node.id] <= this.poID[source.id] && this.lowestPoID[target.id] <= this.poID[node.id] && this.poID[node.id] <= this.poID[target.id]) {
            return this.poID[source.id] >= this.poID[target.id];
        }
        return this.poID[source.id] < this.poID[target.id];
    }

    private void cutvalues() {
        LinkedList<LNode> leafs = new LinkedList<LNode>();
        ArrayList unknownCutvalues = new ArrayList(this.nodes.size());
        for (LNode node : this.nodes) {
            int treeEdgeCount = 0;
            unknownCutvalues.add(new HashSet());
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getConnectedEdges()) {
                    if (!this.treeEdge[edge.id]) continue;
                    ((HashSet)unknownCutvalues.get(node.id)).add(edge);
                    ++treeEdgeCount;
                }
            }
            if (treeEdgeCount != true) continue;
            leafs.add(node);
        }
        for (LNode node : leafs) {
            while (((HashSet)unknownCutvalues.get(node.id)).size() == 1) {
                LEdge toDetermine = (LEdge)((HashSet)unknownCutvalues.get(node.id)).iterator().next();
                this.cutvalue[toDetermine.id] = 1;
                LNode source = toDetermine.getSource().getNode();
                LNode target = toDetermine.getTarget().getNode();
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getConnectedEdges()) {
                        if (edge.equals(toDetermine)) continue;
                        if (this.treeEdge[edge.id]) {
                            if (source.equals(edge.getSource().getNode()) || target.equals(edge.getTarget().getNode())) {
                                int n = toDetermine.id;
                                this.cutvalue[n] = this.cutvalue[n] - (this.cutvalue[edge.id] - 1);
                                continue;
                            }
                            int n = toDetermine.id;
                            this.cutvalue[n] = this.cutvalue[n] + (this.cutvalue[edge.id] - 1);
                            continue;
                        }
                        if (node.equals(source)) {
                            if (edge.getSource().getNode().equals(node)) {
                                int n = toDetermine.id;
                                this.cutvalue[n] = this.cutvalue[n] + 1;
                                continue;
                            }
                            int n = toDetermine.id;
                            this.cutvalue[n] = this.cutvalue[n] - 1;
                            continue;
                        }
                        if (edge.getSource().getNode().equals(node)) {
                            int n = toDetermine.id;
                            this.cutvalue[n] = this.cutvalue[n] - 1;
                            continue;
                        }
                        int n = toDetermine.id;
                        this.cutvalue[n] = this.cutvalue[n] + 1;
                    }
                }
                ((HashSet)unknownCutvalues.get(source.id)).remove(toDetermine);
                ((HashSet)unknownCutvalues.get(target.id)).remove(toDetermine);
                node = source.equals(node) ? toDetermine.getTarget().getNode() : toDetermine.getSource().getNode();
            }
        }
    }

    private void naiveCutvalues() {
        for (LEdge edge : this.edges) {
            if (!this.treeEdge[edge.id]) continue;
            this.cutvalue[edge.id] = 1;
            for (LEdge cur : this.edges) {
                if (this.treeEdge[cur.id]) continue;
                boolean source = this.isInHead(cur.getSource().getNode(), edge);
                boolean target = this.isInHead(cur.getTarget().getNode(), edge);
                if (target && !source) {
                    int n = edge.id;
                    this.cutvalue[n] = this.cutvalue[n] + 1;
                    continue;
                }
                if (!source || target) continue;
                int n = edge.id;
                this.cutvalue[n] = this.cutvalue[n] - 1;
            }
        }
    }

    private LEdge leaveEdge() {
        for (LEdge edge : this.edges) {
            if (!this.treeEdge[edge.id] || this.cutvalue[edge.id] >= 0) continue;
            return edge;
        }
        return null;
    }

    private LEdge enterEdge(LEdge leave) {
        if (!this.treeEdge[leave.id]) {
            throw new IllegalArgumentException("The input edge is not a tree edge.");
        }
        LEdge replace = null;
        int repSlack = Integer.MAX_VALUE;
        for (LEdge edge : this.edges) {
            int slack;
            LNode source = edge.getSource().getNode();
            LNode target = edge.getTarget().getNode();
            if (!this.isInHead(source, leave) || this.isInHead(target, leave) || (slack = this.layer[target.id] - this.layer[source.id] - this.minSpan[edge.id]) >= repSlack) continue;
            repSlack = slack;
            replace = edge;
        }
        return replace;
    }

    private void exchange(LEdge leave, LEdge enter) {
        if (!this.treeEdge[leave.id]) {
            throw new IllegalArgumentException("Given leave edge is no tree edge.");
        }
        if (this.treeEdge[enter.id]) {
            throw new IllegalArgumentException("Given enter edge is a tree edge already.");
        }
        this.treeEdge[leave.id] = false;
        this.treeEdge[enter.id] = true;
        int delta = this.layer[enter.getTarget().getNode().id] - this.layer[enter.getSource().getNode().id] - this.minSpan[enter.id];
        if (!this.isInHead(enter.getTarget().getNode(), leave)) {
            delta = -delta;
        }
        for (LNode node : this.nodes) {
            if (this.isInHead(node, leave)) continue;
            int n = node.id;
            this.layer[n] = this.layer[n] + delta;
        }
        this.postOrder = 1;
        Arrays.fill(this.edgeVisited, false);
        this.postorderTraversal(this.nodes.iterator().next());
        this.cutvalues();
    }

    private int[] normalize() {
        int highest = Integer.MIN_VALUE;
        int lowest = Integer.MAX_VALUE;
        for (LNode node : this.sources) {
            if (this.layer[node.id] >= lowest) continue;
            lowest = this.layer[node.id];
        }
        for (LNode node : this.sinks) {
            if (this.layer[node.id] <= highest) continue;
            highest = this.layer[node.id];
        }
        int layerID = 0;
        int[] filling = new int[highest - lowest + 1];
        for (LNode node : this.nodes) {
            int n = node.id;
            this.layer[n] = this.layer[n] - lowest;
            int n2 = this.layer[node.id];
            filling[n2] = filling[n2] + 1;
        }
        for (Layer eLayer : this.layeredGraph) {
            int n = layerID++;
            filling[n] = filling[n] + eLayer.getNodes().size();
            if (filling.length == layerID) break;
        }
        return filling;
    }

    private void balance(int[] filling) {
        Pair<Integer, Integer> range = null;
        for (LNode node : this.nodes) {
            if (this.inDegree[node.id] != this.outDegree[node.id]) continue;
            int newLayer = this.layer[node.id];
            range = this.minimalSpan(node);
            int i = this.layer[node.id] - (Integer)range.getFirst() + 1;
            while (i < this.layer[node.id] + (Integer)range.getSecond()) {
                if (filling[i] < filling[newLayer]) {
                    newLayer = i;
                }
                ++i;
            }
            if (filling[newLayer] >= filling[this.layer[node.id]]) continue;
            int n = this.layer[node.id];
            filling[n] = filling[n] - 1;
            int n2 = newLayer;
            filling[n2] = filling[n2] + 1;
            this.layer[node.id] = newLayer;
        }
    }

    private void putNode(LNode node) {
        List<Layer> layers = this.layeredGraph.getLayers();
        while (layers.size() <= this.layer[node.id]) {
            layers.add(layers.size(), new Layer(this.layeredGraph));
        }
        node.setLayer(layers.get(this.layer[node.id]));
    }

    private LPort getOpposite(LPort port, LEdge edge) {
        if (edge.getSource().equals(port)) {
            return edge.getTarget();
        }
        if (edge.getTarget().equals(port)) {
            return edge.getSource();
        }
        throw new IllegalArgumentException("Input edge is not connected to the input port.");
    }
}

