/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;

public class PortSideProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Port side processing", 1.0f);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                    for (LPort port : node.getPorts()) {
                        if (port.getSide() != PortSide.UNDEFINED) continue;
                        this.setPortSide(port);
                    }
                    continue;
                }
                for (LPort port : node.getPorts()) {
                    this.setPortSide(port);
                }
                node.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_SIDE);
            }
        }
        this.getMonitor().done();
    }

    private void setPortSide(LPort port) {
        if (port.getNetFlow() < 0) {
            port.setSide(PortSide.EAST);
            port.getAnchor().x = port.getSize().x;
        } else {
            port.setSide(PortSide.WEST);
            port.getAnchor().x = 0.0;
        }
    }
}

