/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class NodeMarginCalculator
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Node margin calculation", 1.0f);
        double spacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                Rectangle2D.Double boundingBox = new Rectangle2D.Double(node.getPosition().x, node.getPosition().y, node.getSize().x, node.getSize().y);
                Rectangle2D.Double elementBox = new Rectangle2D.Double();
                for (LLabel label : node.getLabels()) {
                    elementBox.x = label.getPosition().x + node.getPosition().x;
                    elementBox.y = label.getPosition().y + node.getPosition().y;
                    elementBox.width = label.getSize().x;
                    elementBox.height = label.getSize().y;
                    Rectangle2D.union(boundingBox, elementBox, boundingBox);
                }
                for (LPort port : node.getPorts()) {
                    double portX = port.getPosition().x + node.getPosition().x;
                    double portY = port.getPosition().y + node.getPosition().y;
                    elementBox.x = portX;
                    elementBox.y = portY;
                    elementBox.width = port.getSize().x;
                    elementBox.height = port.getSize().y;
                    Rectangle2D.union(boundingBox, elementBox, boundingBox);
                    for (LLabel label : port.getLabels()) {
                        elementBox.x = label.getPosition().x + portX;
                        elementBox.y = label.getPosition().y + portY;
                        elementBox.width = label.getSize().x;
                        elementBox.height = label.getSize().y;
                        Rectangle2D.union(boundingBox, elementBox, boundingBox);
                    }
                }
                LInsets.Double margin = node.getMargin();
                margin.top = node.getPosition().y - boundingBox.y;
                margin.bottom = boundingBox.getMaxY() - (node.getPosition().y + node.getSize().y);
                margin.left = node.getPosition().x - boundingBox.x;
                margin.right = boundingBox.getMaxX() - (node.getPosition().x + node.getSize().x);
                this.processComments(node, spacing);
            }
        }
        this.getMonitor().done();
    }

    private void processComments(LNode node, double spacing) {
        double totalWidth;
        double maxCommentWidth;
        LInsets.Double margin = node.getMargin();
        List topBoxes = (List)node.getProperty(Properties.TOP_COMMENTS);
        double topWidth = 0.0;
        if (topBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : topBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                topWidth += commentBox.getSize().x;
            }
            topWidth += spacing / 2.0 * (double)(topBoxes.size() - 1);
            margin.top += maxHeight + spacing;
        }
        List bottomBoxes = (List)node.getProperty(Properties.BOTTOM_COMMENTS);
        double bottomWidth = 0.0;
        if (bottomBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : bottomBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                bottomWidth += commentBox.getSize().x;
            }
            bottomWidth += spacing / 2.0 * (double)(bottomBoxes.size() - 1);
            margin.bottom += maxHeight + spacing;
        }
        if ((maxCommentWidth = Math.max(topWidth, bottomWidth)) > (totalWidth = node.getSize().x + margin.left + margin.right)) {
            double extra = (maxCommentWidth - totalWidth) / 2.0;
            margin.left += extra;
            margin.right += extra;
        }
    }
}

