/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.List;
import java.util.ListIterator;

public class HyperedgeDummyMerger
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Hyperedge merging", 1.0f);
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            List<LNode> nodes = layer.getNodes();
            if (nodes.isEmpty()) continue;
            LNode currentNode = null;
            NodeType currentNodeType = null;
            LNode lastNode = null;
            NodeType lastNodeType = null;
            int nodeIndex = 0;
            while (nodeIndex < nodes.size()) {
                currentNode = nodes.get(nodeIndex);
                currentNodeType = (NodeType)((Object)currentNode.getProperty(Properties.NODE_TYPE));
                if (currentNodeType == NodeType.LONG_EDGE && lastNodeType == NodeType.LONG_EDGE) {
                    boolean lastNodePropertiesSet;
                    LPort currentNodeSource = (LPort)currentNode.getProperty(Properties.LONG_EDGE_SOURCE);
                    LPort lastNodeSource = (LPort)lastNode.getProperty(Properties.LONG_EDGE_SOURCE);
                    LPort currentNodeTarget = (LPort)currentNode.getProperty(Properties.LONG_EDGE_TARGET);
                    LPort lastNodeTarget = (LPort)lastNode.getProperty(Properties.LONG_EDGE_TARGET);
                    boolean currentNodePropertiesSet = currentNodeSource != null || currentNodeTarget != null;
                    boolean bl = lastNodePropertiesSet = lastNodeSource != null || lastNodeTarget != null;
                    if (currentNodePropertiesSet && lastNodePropertiesSet && (currentNodeSource == lastNodeSource || currentNodeTarget == lastNodeTarget)) {
                        this.mergeNodes(lastNode, currentNode, currentNodeSource == lastNodeSource, currentNodeTarget == lastNodeTarget);
                        nodes.remove(nodeIndex);
                        --nodeIndex;
                        currentNode = lastNode;
                        currentNodeType = lastNodeType;
                    }
                }
                lastNode = currentNode;
                lastNodeType = currentNodeType;
                ++nodeIndex;
            }
        }
        this.getMonitor().done();
    }

    private void mergeNodes(LNode mergeTarget, LNode mergeSource, boolean keepSourcePort, boolean keepTargetPort) {
        LPort mergeTargetInputPort = mergeTarget.getPorts(PortSide.WEST).iterator().next();
        LPort mergeTargetOutputPort = mergeTarget.getPorts(PortSide.EAST).iterator().next();
        for (LPort port : mergeSource.getPorts()) {
            LEdge edge;
            int n;
            int n2;
            LEdge[] lEdgeArray;
            LEdge[] edgeArray;
            if (!port.getIncomingEdges().isEmpty()) {
                lEdgeArray = edgeArray = port.getIncomingEdges().toArray(new LEdge[0]);
                n2 = edgeArray.length;
                n = 0;
                while (n < n2) {
                    edge = lEdgeArray[n];
                    edge.setTarget(mergeTargetInputPort);
                    ++n;
                }
            }
            if (port.getOutgoingEdges().isEmpty()) continue;
            lEdgeArray = edgeArray = port.getOutgoingEdges().toArray(new LEdge[0]);
            n2 = edgeArray.length;
            n = 0;
            while (n < n2) {
                edge = lEdgeArray[n];
                edge.setSource(mergeTargetOutputPort);
                ++n;
            }
        }
        if (!keepSourcePort) {
            mergeTarget.setProperty(Properties.LONG_EDGE_SOURCE, null);
        }
        if (!keepTargetPort) {
            mergeTarget.setProperty(Properties.LONG_EDGE_TARGET, null);
        }
    }
}

