/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer
extends LGraphElement
implements Iterable<LNode> {
    private static final long serialVersionUID = 5760328884701318753L;
    private final LGraph owner;
    private final KVector size = new KVector();
    private final List<LNode> nodes = new LinkedList<LNode>();

    public Layer(LGraph graph) {
        super(graph.hashCodeCounter());
        this.owner = graph;
    }

    public String toString() {
        return "L_" + this.getIndex() + this.nodes.toString();
    }

    public KVector getSize() {
        return this.size;
    }

    public List<LNode> getNodes() {
        return this.nodes;
    }

    @Override
    public Iterator<LNode> iterator() {
        return this.nodes.iterator();
    }

    public LGraph getGraph() {
        return this.owner;
    }

    public int getIndex() {
        return this.owner.getLayers().indexOf(this);
    }

    public void placeNodes(double xoffset) {
        double maxLeftMargin = 0.0;
        double maxRightMargin = 0.0;
        for (LNode node : this.nodes) {
            maxLeftMargin = Math.max(maxLeftMargin, node.getMargin().left);
            maxRightMargin = Math.max(maxRightMargin, node.getMargin().right);
        }
        for (LNode node : this.nodes) {
            double rightMargin;
            double ratio;
            Alignment alignment = (Alignment)node.getProperty(LayoutOptions.ALIGNMENT);
            switch (alignment) {
                case LEFT: {
                    ratio = 0.0;
                    break;
                }
                case RIGHT: {
                    ratio = 1.0;
                    break;
                }
                case CENTER: {
                    ratio = 0.5;
                    break;
                }
                default: {
                    int inports = 0;
                    int outports = 0;
                    for (LPort port : node.getPorts()) {
                        if (!port.getIncomingEdges().isEmpty()) {
                            ++inports;
                        }
                        if (port.getOutgoingEdges().isEmpty()) continue;
                        ++outports;
                    }
                    ratio = inports + outports == 0 ? 0.5 : (double)outports / (double)(inports + outports);
                }
            }
            double nodeSize = node.getSize().x;
            double xpos = (this.size.x - nodeSize) * ratio;
            if (ratio > 0.5) {
                xpos -= maxRightMargin * 2.0 * (ratio - 0.5);
            } else if (ratio < 0.5) {
                xpos += maxLeftMargin * 2.0 * (0.5 - ratio);
            }
            double leftMargin = node.getMargin().left;
            if (xpos < leftMargin) {
                xpos = leftMargin;
            }
            if (xpos > this.size.x - (rightMargin = node.getMargin().right) - nodeSize) {
                xpos = this.size.x - rightMargin - nodeSize;
            }
            node.getPosition().x = xoffset + xpos;
        }
    }
}

