/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.components;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGraphPlacer {
    AbstractGraphPlacer() {
    }

    public abstract LGraph combine(List<LGraph> var1);

    protected void moveGraphs(LGraph destGraph, Collection<LGraph> sourceGraphs, double offsetx, double offsety) {
        for (LGraph sourceGraph : sourceGraphs) {
            this.moveGraph(destGraph, sourceGraph, offsetx, offsety);
        }
    }

    protected void moveGraph(LGraph destGraph, LGraph sourceGraph, double offsetx, double offsety) {
        KVector graphOffset = sourceGraph.getOffset().translate(offsetx, offsety);
        for (Layer layer : sourceGraph) {
            for (LNode node : layer) {
                node.getPosition().add(graphOffset);
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        edge.getBendPoints().translate(graphOffset);
                        for (LLabel label : edge.getLabels()) {
                            label.getPosition().add(graphOffset);
                        }
                    }
                }
                destGraph.getLayerlessNodes().add(node);
            }
        }
    }

    protected void offsetGraphs(Collection<LGraph> graphs, double offsetx, double offsety) {
        for (LGraph graph : graphs) {
            this.offsetGraph(graph, offsetx, offsety);
        }
    }

    protected void offsetGraph(LGraph graph, double offsetx, double offsety) {
        KVector graphOffset = new KVector(offsetx, offsety);
        for (Layer layer : graph) {
            for (LNode node : layer) {
                node.getPosition().add(graphOffset);
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        edge.getBendPoints().translate(graphOffset);
                        for (LLabel label : edge.getLabels()) {
                            label.getPosition().add(graphOffset);
                        }
                    }
                }
            }
        }
    }
}

