/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediateProcessingConfiguration {
    public static final int BEFORE_PHASE_1 = 0;
    public static final int BEFORE_PHASE_2 = 1;
    public static final int BEFORE_PHASE_3 = 2;
    public static final int BEFORE_PHASE_4 = 3;
    public static final int BEFORE_PHASE_5 = 4;
    public static final int AFTER_PHASE_5 = 5;
    public static final int INTERMEDIATE_PHASE_SLOTS = 6;
    private List<Set<LayoutProcessorStrategy>> strategy = new ArrayList<Set<LayoutProcessorStrategy>>(6);

    public IntermediateProcessingConfiguration() {
        int i = 0;
        while (i < 6) {
            this.strategy.add(EnumSet.noneOf(LayoutProcessorStrategy.class));
            ++i;
        }
    }

    public IntermediateProcessingConfiguration(IntermediateProcessingConfiguration init) {
        int i = 0;
        while (i < 6) {
            this.strategy.add(EnumSet.copyOf(init.strategy.get(i)));
            ++i;
        }
    }

    public IntermediateProcessingConfiguration(int slotIndex, LayoutProcessorStrategy processor) {
        this();
        this.addAll(slotIndex, EnumSet.of(processor));
    }

    public IntermediateProcessingConfiguration(int slotIndex, Collection<LayoutProcessorStrategy> processors) {
        this();
        this.addAll(slotIndex, processors);
    }

    public IntermediateProcessingConfiguration(Collection<LayoutProcessorStrategy> beforePhase1, Collection<LayoutProcessorStrategy> beforePhase2, Collection<LayoutProcessorStrategy> beforePhase3, Collection<LayoutProcessorStrategy> beforePhase4, Collection<LayoutProcessorStrategy> beforePhase5, Collection<LayoutProcessorStrategy> afterPhase5) {
        this();
        this.addAll(0, beforePhase1).addAll(1, beforePhase2).addAll(2, beforePhase3).addAll(3, beforePhase4).addAll(4, beforePhase5).addAll(5, afterPhase5);
    }

    public Set<LayoutProcessorStrategy> getProcessors(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 6) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 6.");
        }
        return EnumSet.copyOf(this.strategy.get(slotIndex));
    }

    public void addLayoutProcessor(int slotIndex, LayoutProcessorStrategy processor) {
        if (slotIndex < 0 || slotIndex >= 6) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 6.");
        }
        this.strategy.get(slotIndex).add(processor);
    }

    public IntermediateProcessingConfiguration addAll(int slotIndex, Collection<LayoutProcessorStrategy> processors) {
        if (slotIndex < 0 || slotIndex >= 6) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 6.");
        }
        if (processors != null) {
            this.strategy.get(slotIndex).addAll(processors);
        }
        return this;
    }

    public IntermediateProcessingConfiguration addAll(IntermediateProcessingConfiguration operand) {
        if (operand != null) {
            int i = 0;
            while (i < 6) {
                this.strategy.get(i).addAll((Collection<LayoutProcessorStrategy>)operand.strategy.get(i));
                ++i;
            }
        }
        return this;
    }

    public void removeLayoutProcessor(int slotIndex, LayoutProcessorStrategy processor) {
        if (slotIndex < 0 || slotIndex >= 6) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 6.");
        }
        this.strategy.get(slotIndex).remove((Object)processor);
    }

    public void clear() {
        for (Set<LayoutProcessorStrategy> set : this.strategy) {
            set.clear();
        }
    }
}

