/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.IGraphImporter;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.EdgeConstraint;
import de.cau.cs.kieler.klay.layered.properties.InLayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphImporter<T>
implements IGraphImporter<T> {
    protected final LGraphElement.HashCodeCounter hashCodeCounter;
    protected LGraph layeredGraph;

    public AbstractGraphImporter(LGraphElement.HashCodeCounter counter) {
        this.hashCodeCounter = counter;
    }

    protected LNode createExternalPortDummy(KPort port, PortConstraints portConstraints, PortSide portSide, int netFlow, KVector portNodeSize, KVector portPosition, KVector portSize) {
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        PortSide finalExternalPortSide = portSide;
        LNode dummy = new LNode(this.layeredGraph);
        dummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.EXTERNAL_PORT);
        dummy.setProperty(Properties.ORIGIN, port);
        dummy.setProperty(Properties.EXT_PORT_SIZE, portSize);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        dummy.setProperty(Properties.OFFSET, portLayout.getProperty(LayoutOptions.OFFSET));
        KVector anchor = (KVector)portLayout.getProperty(Properties.PORT_ANCHOR);
        if (anchor == null) {
            anchor = new KVector(portSize.x / 2.0, portSize.y / 2.0);
        }
        dummy.setProperty(Properties.PORT_ANCHOR, anchor);
        LPort dummyPort = new LPort(this.layeredGraph);
        dummyPort.setNode(dummy);
        if (!portConstraints.isSideFixed()) {
            finalExternalPortSide = netFlow > 0 ? PortSide.EAST : PortSide.WEST;
            portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)finalExternalPortSide);
        }
        switch (finalExternalPortSide) {
            case WEST: {
                dummy.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST_SEPARATE);
                dummy.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.OUTGOING_ONLY);
                dummy.getSize().y = portSize.y;
                dummyPort.setSide(PortSide.EAST);
                dummyPort.getPosition().y = anchor.y;
                break;
            }
            case EAST: {
                dummy.setProperty(Properties.LAYER_CONSTRAINT, (Object)LayerConstraint.LAST_SEPARATE);
                dummy.setProperty(Properties.EDGE_CONSTRAINT, (Object)EdgeConstraint.INCOMING_ONLY);
                dummy.getSize().y = portSize.y;
                dummyPort.setSide(PortSide.WEST);
                dummyPort.getPosition().y = anchor.y;
                break;
            }
            case NORTH: {
                dummy.setProperty(Properties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.TOP);
                dummy.getSize().x = portSize.x;
                dummyPort.setSide(PortSide.SOUTH);
                dummyPort.getPosition().x = anchor.x;
                break;
            }
            case SOUTH: {
                dummy.setProperty(Properties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.BOTTOM);
                dummy.getSize().x = portSize.x;
                dummyPort.setSide(PortSide.NORTH);
                dummyPort.getPosition().x = anchor.x;
                break;
            }
            default: {
                assert (false) : finalExternalPortSide;
                break;
            }
        }
        if (portConstraints.isOrderFixed()) {
            double positionOrRatio = 0.0;
            switch (finalExternalPortSide) {
                case EAST: 
                case WEST: {
                    positionOrRatio = portPosition.y;
                    if (!portConstraints.isRatioFixed()) break;
                    positionOrRatio /= portNodeSize.y;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    positionOrRatio = portPosition.x;
                    if (!portConstraints.isRatioFixed()) break;
                    positionOrRatio /= portNodeSize.x;
                }
            }
            dummy.setProperty(Properties.EXT_PORT_RATIO_OR_POSITION, positionOrRatio);
        }
        dummy.setProperty(Properties.EXT_PORT_SIDE, finalExternalPortSide);
        return dummy;
    }

    protected KVector getExternalPortPosition(LGraph graph, LNode portDummy, double portWidth, double portHeight) {
        KVector portPosition = new KVector(portDummy.getPosition());
        portPosition.x += portDummy.getSize().x / 2.0;
        portPosition.y += portDummy.getSize().y / 2.0;
        float portOffset = ((Float)portDummy.getProperty(LayoutOptions.OFFSET)).floatValue();
        KVector graphSize = graph.getSize();
        LInsets.Double insets = graph.getInsets();
        float borderSpacing = ((Float)graph.getProperty((IProperty)Properties.BORDER_SPACING)).floatValue();
        KVector graphOffset = graph.getOffset();
        switch ((PortSide)portDummy.getProperty(Properties.EXT_PORT_SIDE)) {
            case NORTH: {
                portPosition.x += insets.left + (double)borderSpacing + graphOffset.x - portWidth / 2.0;
                portPosition.y = -portHeight - (double)portOffset;
                portDummy.getPosition().y = -(insets.top + (double)borderSpacing + (double)portOffset + graphOffset.y);
                break;
            }
            case EAST: {
                portPosition.x = graphSize.x + insets.left + insets.right + (double)(2.0f * borderSpacing) + (double)portOffset;
                portPosition.y += insets.top + (double)borderSpacing + graphOffset.y - portHeight / 2.0;
                portDummy.getPosition().x = graphSize.x + insets.right + (double)borderSpacing + (double)portOffset - graphOffset.x;
                break;
            }
            case SOUTH: {
                portPosition.x += insets.left + (double)borderSpacing + graphOffset.x - portWidth / 2.0;
                portPosition.y = graphSize.y + insets.top + insets.bottom + (double)(2.0f * borderSpacing) + (double)portOffset;
                portDummy.getPosition().y = graphSize.y + insets.bottom + (double)borderSpacing + (double)portOffset - graphOffset.y;
                break;
            }
            case WEST: {
                portPosition.x = -portWidth - (double)portOffset;
                portPosition.y += insets.top + (double)borderSpacing + graphOffset.y - portHeight / 2.0;
                portDummy.getPosition().x = -(insets.left + (double)borderSpacing + (double)portOffset + graphOffset.x);
            }
        }
        return portPosition;
    }
}

