/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui;

import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutTypeData;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class LayouterHintProvider
implements ITreeContentProvider {
    private LayoutDataService layoutServices;
    private final Map<Object, Boolean> filterMap = new HashMap<Object, Boolean>();
    private String filterValue;
    private String bestFilterMatch;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof LayoutDataService) {
            this.layoutServices = (LayoutDataService)inputElement;
        }
        return this.layoutServices.getTypeData().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LayoutTypeData) {
            LayoutTypeData typeData = (LayoutTypeData)parentElement;
            return typeData.getLayouters().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof LayoutAlgorithmData) {
            LayoutAlgorithmData layouterData = (LayoutAlgorithmData)element;
            return this.layoutServices.getTypeData(layouterData.getType());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof LayoutTypeData) {
            return ((LayoutTypeData)element).getLayouters().size() > 0;
        }
        return false;
    }

    public void dispose() {
    }

    public void updateFilter(String filter) {
        this.filterValue = filter;
        if (this.filterValue != null) {
            this.filterValue = this.filterValue.toLowerCase();
        }
        this.filterMap.clear();
        this.bestFilterMatch = null;
    }

    public boolean applyFilter(Object element) {
        Boolean result = this.filterMap.get(element);
        if (result == null) {
            if (this.filterValue != null && this.filterValue.length() > 0) {
                if (element instanceof LayoutTypeData) {
                    LayoutTypeData typeData = (LayoutTypeData)element;
                    result = typeData.getName().toLowerCase().contains(this.filterValue);
                    if (result.booleanValue()) {
                        for (LayoutAlgorithmData layouterData : typeData.getLayouters()) {
                            this.filterMap.put(layouterData, Boolean.TRUE);
                        }
                        this.bestFilterMatch = this.bestFilterMatch == null ? typeData.getId() : "";
                    } else {
                        boolean hasFilteredChild = false;
                        for (LayoutAlgorithmData layouterData : typeData.getLayouters()) {
                            hasFilteredChild |= this.applyFilter(layouterData);
                        }
                        result = hasFilteredChild;
                    }
                } else if (element instanceof LayoutAlgorithmData) {
                    LayoutAlgorithmData layouterData = (LayoutAlgorithmData)element;
                    if (layouterData.getName().toLowerCase().contains(this.filterValue)) {
                        result = Boolean.TRUE;
                        this.bestFilterMatch = this.bestFilterMatch == null ? layouterData.getId() : "";
                    } else {
                        String category = LayoutDataService.getInstance().getCategoryName(layouterData.getCategory());
                        result = category != null && category.toLowerCase().contains(this.filterValue);
                    }
                }
            } else {
                result = Boolean.TRUE;
            }
            this.filterMap.put(element, result);
        }
        return result;
    }

    public String getBestFilterMatch() {
        return this.bestFilterMatch;
    }
}

