/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.graphiti;

import com.google.common.collect.BiMap;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.config.VolatileLayoutConfig;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.impl.KEdgeLayoutImpl;
import de.cau.cs.kieler.kiml.klayoutdata.impl.KShapeLayoutImpl;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.diagram.LayoutMapping;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.SWTException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KimlGraphitiUtil {
    public static final IProperty<DiagramEditor> DIAGRAM_EDITOR = new Property("graphiti.diagramEditor");
    public static final IProperty<Command> LAYOUT_COMMAND = new Property("graphiti.applyLayoutCommand");
    public static final IProperty<List<Connection>> CONNECTIONS = new Property("graphiti.connections");
    public static final IProperty<VolatileLayoutConfig> STATIC_CONFIG = new Property("graphiti.staticLayoutConfig");
    private static final double HEAD_LOCATION = 0.7;
    private static final double TAIL_LOCATION = 0.3;

    private KimlGraphitiUtil() {
    }

    public static KLabel createLabel(KLabeledGraphElement element, AbstractText abstractText, float offsetx, float offsety) {
        String labelText = abstractText.getValue();
        if (labelText != null) {
            KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)element);
            label.setText(labelText);
            IGaService gaService = Graphiti.getGaService();
            Font font = gaService.getFont(abstractText, true);
            IDimension textSize = null;
            try {
                textSize = GraphitiUi.getUiLayoutService().calculateTextSize(labelText, font);
            }
            catch (SWTException sWTException) {}
            int xpos = abstractText.getX();
            int ypos = abstractText.getY();
            int width = abstractText.getWidth();
            int height = abstractText.getHeight();
            if (textSize != null) {
                int diff;
                if (textSize.getWidth() < width) {
                    diff = width - textSize.getWidth();
                    switch (gaService.getHorizontalAlignment(abstractText, true)) {
                        case ALIGNMENT_CENTER: {
                            xpos += diff / 2;
                            break;
                        }
                        case ALIGNMENT_RIGHT: {
                            xpos += diff;
                            break;
                        }
                    }
                    width -= diff;
                }
                if (textSize.getHeight() < height) {
                    diff = height - textSize.getHeight();
                    switch (gaService.getVerticalAlignment(abstractText, true)) {
                        case ALIGNMENT_MIDDLE: {
                            ypos += diff / 2;
                            break;
                        }
                        case ALIGNMENT_BOTTOM: {
                            ypos += diff;
                            break;
                        }
                    }
                    height -= diff;
                }
            }
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            labelLayout.setPos((float)xpos + offsetx, (float)ypos + offsety);
            labelLayout.setSize((float)width, (float)height);
            ((KShapeLayoutImpl)labelLayout).resetModificationFlag();
            return label;
        }
        return null;
    }

    public static void createEdge(LayoutMapping<PictogramElement> mapping, Connection connection) {
        KNode sourceNode;
        KNode targetNode;
        KEdge edge = KimlUtil.createInitializedEdge();
        BiMap graphMap = mapping.getGraphMap();
        VolatileLayoutConfig staticConfig = (VolatileLayoutConfig)mapping.getProperty(STATIC_CONFIG);
        Anchor targetAnchor = connection.getEnd();
        KPort targetPort = (KPort)graphMap.inverse().get((Object)targetAnchor);
        if (targetPort != null) {
            edge.setTargetPort(targetPort);
            targetPort.getEdges().add((Object)edge);
            targetNode = targetPort.getNode();
        } else {
            targetNode = (KNode)graphMap.inverse().get((Object)targetAnchor.getParent());
        }
        edge.setTarget(targetNode);
        Anchor sourceAnchor = connection.getStart();
        KPort sourcePort = (KPort)graphMap.inverse().get((Object)sourceAnchor);
        if (sourcePort != null) {
            edge.setSourcePort(sourcePort);
            sourcePort.getEdges().add((Object)edge);
            sourceNode = sourcePort.getNode();
        } else {
            sourceNode = (KNode)graphMap.inverse().get((Object)sourceAnchor.getParent());
        }
        edge.setSource(sourceNode);
        if (sourceNode == null || targetNode == null) {
            return;
        }
        KNode referenceNode = sourceNode;
        if (!KimlUtil.isDescendant((KNode)targetNode, (KNode)sourceNode)) {
            referenceNode = sourceNode.getParent();
        }
        KVector offset = new KVector();
        KimlUtil.toAbsolute((KVector)offset, (KNode)referenceNode);
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        KVector sourcePoint = KimlGraphitiUtil.calculateAnchorEnds(sourceNode, sourcePort, referenceNode);
        edgeLayout.getSourcePoint().applyVector(sourcePoint);
        KVector targetPoint = KimlGraphitiUtil.calculateAnchorEnds(targetNode, targetPort, referenceNode);
        edgeLayout.getTargetPoint().applyVector(targetPoint);
        KVectorChain allPoints = new KVectorChain();
        allPoints.add((Object)sourcePoint);
        if (connection instanceof FreeFormConnection) {
            for (Point point : ((FreeFormConnection)connection).getBendpoints()) {
                KVector v = new KVector((double)point.getX(), (double)point.getY());
                v.sub(offset);
                allPoints.add((Object)v);
                KPoint kpoint = KLayoutDataFactory.eINSTANCE.createKPoint();
                kpoint.applyVector(v);
                edgeLayout.getBendPoints().add((Object)kpoint);
            }
        }
        allPoints.add((Object)targetPoint);
        ((KEdgeLayoutImpl)edgeLayout).resetModificationFlag();
        graphMap.put((Object)edge, (Object)connection);
        for (ConnectionDecorator decorator : connection.getConnectionDecorators()) {
            GraphicsAlgorithm ga = decorator.getGraphicsAlgorithm();
            if (!(ga instanceof AbstractText)) continue;
            AbstractText text = (AbstractText)ga;
            String labelText = text.getValue();
            KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)edge);
            label.setText(labelText);
            graphMap.put((Object)label, (Object)decorator);
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            EdgeLabelPlacement placement = EdgeLabelPlacement.CENTER;
            if (decorator.isLocationRelative()) {
                if (decorator.getLocation() >= 0.7) {
                    placement = EdgeLabelPlacement.HEAD;
                } else if (decorator.getLocation() <= 0.3) {
                    placement = EdgeLabelPlacement.TAIL;
                }
            }
            staticConfig.setValue(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)label, LayoutContext.GRAPH_ELEM, (Object)placement);
            KVector labelPos = decorator.isLocationRelative() ? allPoints.getPointOnLine(decorator.getLocation() * allPoints.getLength()) : allPoints.getPointOnLine(decorator.getLocation());
            labelPos.x += (double)ga.getX();
            labelPos.y += (double)ga.getY();
            labelLayout.applyVector(labelPos);
            IGaService gaService = Graphiti.getGaService();
            Font font = gaService.getFont(text, true);
            IDimension textSize = null;
            try {
                textSize = GraphitiUi.getUiLayoutService().calculateTextSize(labelText, font);
            }
            catch (SWTException sWTException) {}
            if (textSize != null) {
                labelLayout.setSize((float)textSize.getWidth(), (float)textSize.getHeight());
            }
            ((KShapeLayoutImpl)labelLayout).resetModificationFlag();
        }
    }

    public static KVector calculateAnchorEnds(KNode node, KPort port, KNode referenceNode) {
        KVector pos = new KVector();
        if (port != null) {
            KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
            pos.x = portLayout.getXpos() + portLayout.getWidth() / 2.0f;
            pos.y = portLayout.getYpos() + portLayout.getHeight() / 2.0f;
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            pos.x += (double)nodeLayout.getXpos();
            pos.y += (double)nodeLayout.getYpos();
        } else {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            pos.x = nodeLayout.getWidth() / 2.0f + nodeLayout.getXpos();
            pos.y = nodeLayout.getHeight() / 2.0f + nodeLayout.getYpos();
        }
        KimlUtil.toAbsolute((KVector)pos, (KNode)node.getParent());
        if (referenceNode != null) {
            KimlUtil.toRelative((KVector)pos, (KNode)referenceNode);
        }
        return pos;
    }

    public static GraphicsAlgorithm findVisibleGa(GraphicsAlgorithm graphicsAlgorithm) {
        if (graphicsAlgorithm.getLineVisible().booleanValue() || graphicsAlgorithm.getFilled().booleanValue()) {
            return graphicsAlgorithm;
        }
        for (GraphicsAlgorithm ga : graphicsAlgorithm.getGraphicsAlgorithmChildren()) {
            GraphicsAlgorithm result = KimlGraphitiUtil.findVisibleGa(ga);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static KInsets calcInsets(GraphicsAlgorithm graphicsAlgorithm) {
        GraphicsAlgorithm visibleGa = KimlGraphitiUtil.findVisibleGa(graphicsAlgorithm);
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        while (visibleGa != graphicsAlgorithm) {
            left += visibleGa.getX();
            top += visibleGa.getY();
            GraphicsAlgorithm parentGa = visibleGa.getParentGraphicsAlgorithm();
            right += parentGa.getWidth() - visibleGa.getX() - visibleGa.getWidth();
            bottom += parentGa.getHeight() - visibleGa.getY() - visibleGa.getHeight();
            visibleGa = parentGa;
        }
        KInsets insets = KLayoutDataFactory.eINSTANCE.createKInsets();
        insets.setLeft((float)left);
        insets.setRight((float)right);
        insets.setTop((float)top);
        insets.setBottom((float)bottom);
        return insets;
    }
}

