/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndirectedCycleAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.undirectedCycles";
    private Map<KGraphElement, Integer> dfsMark = new HashMap<KGraphElement, Integer>();

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Approximate undirected cycle count", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int cycleCount = 0;
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (!nodeQueue.isEmpty()) {
            KNode node = (KNode)nodeQueue.remove(0);
            if (!this.dfsMark.containsKey(node)) {
                cycleCount += this.dfs(node, hierarchy);
            }
            if (!hierarchy) continue;
            nodeQueue.addAll(node.getChildren());
        }
        this.dfsMark.clear();
        progressMonitor.done();
        return cycleCount;
    }

    private int dfs(KNode node, boolean hierarchy) {
        this.dfsMark.put((KGraphElement)node, 1);
        int backEdgeCount = 0;
        for (KEdge edge : Iterables.concat((Iterable)node.getOutgoingEdges(), (Iterable)node.getIncomingEdges())) {
            if (this.dfsMark.containsKey(edge) || !hierarchy && edge.getSource().getParent() != edge.getTarget().getParent()) continue;
            this.dfsMark.put((KGraphElement)edge, 1);
            KNode endpoint = edge.getTarget() == node ? edge.getSource() : edge.getTarget();
            Integer mark = this.dfsMark.get(endpoint);
            if (mark == null) {
                backEdgeCount += this.dfs(endpoint, hierarchy);
                continue;
            }
            ++backEdgeCount;
        }
        return backEdgeCount;
    }
}

