/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisFailed;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import de.cau.cs.kieler.kiml.service.grana.analyses.NodeSizeAnalysis;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageAnalysis
implements IAnalysis {
    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Node Coverage Analysis", 1.0f);
        Object areaResult = results.get("de.cau.cs.kieler.kiml.grana.area");
        Object nodeSizeResult = results.get("de.cau.cs.kieler.kiml.grana.nodeSize");
        if (areaResult == null || nodeSizeResult == null) {
            progressMonitor.done();
            return new AnalysisFailed(AnalysisFailed.Type.Dependency);
        }
        Object[] areaResultArray = (Object[])areaResult;
        Object[] nodeSizeResultArray = (Object[])nodeSizeResult;
        float area = (Integer)areaResultArray[0] * (Integer)areaResultArray[1];
        int nodes = (Integer)nodeSizeResultArray[3];
        float avgNodeSize = ((Float)nodeSizeResultArray[1]).floatValue();
        float compoundArea = this.computeCompoundArea(parentNode);
        float nodeCoverage = Math.min((avgNodeSize * (float)nodes + compoundArea) / area, 1.0f);
        progressMonitor.done();
        return Float.valueOf(nodeCoverage);
    }

    private float computeCompoundArea(KNode parentNode) {
        float compoundArea = 0.0f;
        EList children = parentNode.getChildren();
        if (!children.isEmpty()) {
            KShapeLayout layoutData = (KShapeLayout)parentNode.getData(KShapeLayout.class);
            KInsets insets = layoutData.getInsets();
            Rectangle2D.Float nodeRect = NodeSizeAnalysis.computeNodeRect(parentNode, true, true, true);
            float insetsArea = 0.0f;
            insetsArea += layoutData.getWidth() * (insets.getTop() + insets.getBottom());
            insetsArea += layoutData.getHeight() * (insets.getLeft() + insets.getRight());
            compoundArea = nodeRect.width * nodeRect.height - (layoutData.getWidth() * layoutData.getHeight() - (insetsArea -= insets.getTop() * (insets.getLeft() + insets.getRight()) + insets.getBottom() * (insets.getLeft() + insets.getRight())));
            for (KNode child : children) {
                compoundArea += this.computeCompoundArea(child);
            }
        }
        return compoundArea;
    }
}

