/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.util;

import de.cau.cs.kieler.core.alg.BasicProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMonitorAdapter
extends BasicProgressMonitor {
    private IProgressMonitor progressMonitor;
    private int submittedWork = 0;

    public ProgressMonitorAdapter(IProgressMonitor theprogressMonitor) {
        this.progressMonitor = theprogressMonitor;
    }

    public ProgressMonitorAdapter(IProgressMonitor theprogressMonitor, int maxLevels) {
        super(maxLevels);
        this.progressMonitor = theprogressMonitor;
    }

    protected void doBegin(String name, float totalWork, boolean topInstance, int maxHierarchyLevels) {
        if (topInstance) {
            this.progressMonitor.beginTask(name, (int)(totalWork <= 0.0f ? -1.0f : totalWork));
        } else if (maxHierarchyLevels != 0) {
            this.progressMonitor.subTask(name);
        }
    }

    protected void doDone(boolean topInstance, int maxHierarchyLevels) {
        if (topInstance) {
            this.progressMonitor.done();
        }
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    public BasicProgressMonitor doSubTask(float work, int maxHierarchyLevels) {
        if (maxHierarchyLevels > 0) {
            return new ProgressMonitorAdapter(this.progressMonitor, maxHierarchyLevels - 1);
        }
        return new ProgressMonitorAdapter(this.progressMonitor, maxHierarchyLevels);
    }

    protected void doWorked(float completedWork, float totalWork, boolean topInstance) {
        int newWork;
        if (topInstance && (newWork = (int)completedWork) > this.submittedWork) {
            this.progressMonitor.worked(newWork - this.submittedWork);
            this.submittedWork = newWork;
        }
    }
}

