/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public class PortPositionProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Port position processor", 1.0f);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                PortConstraints constraints = (PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS);
                if (constraints.isRatioFixed() || constraints.isPosFixed()) continue;
                if (((Boolean)node.getProperty(LayoutOptions.HYPERNODE)).booleanValue() || node.getSize().x == 0.0 && node.getSize().y == 0.0) {
                    this.placeHypernodePorts(node);
                    continue;
                }
                this.placeNodePorts(node);
            }
        }
        this.getMonitor().done();
    }

    private void placeNodePorts(LNode node) {
        double eastDelta;
        double northDelta;
        int northCount = 1;
        int eastCount = 1;
        int southCount = 1;
        int westCount = 1;
        for (LPort port : node.getPorts()) {
            switch (port.getSide()) {
                case NORTH: {
                    ++northCount;
                    break;
                }
                case EAST: {
                    ++eastCount;
                    break;
                }
                case SOUTH: {
                    ++southCount;
                    break;
                }
                default: {
                    ++westCount;
                }
            }
        }
        KVector nodeSize = node.getSize();
        double northX = northDelta = nodeSize.x / (double)northCount;
        double eastY = eastDelta = nodeSize.y / (double)eastCount;
        double southDelta = nodeSize.x / (double)southCount;
        double southX = nodeSize.x - southDelta;
        double westDelta = nodeSize.y / (double)westCount;
        double westY = nodeSize.y - westDelta;
        for (LPort port : node.getPorts()) {
            float portOffset = ((Float)port.getProperty(Properties.OFFSET)).floatValue();
            switch (port.getSide()) {
                case NORTH: {
                    port.getPosition().x = northX - port.getAnchor().x;
                    port.getPosition().y = -port.getSize().y - (double)portOffset;
                    northX += northDelta;
                    break;
                }
                case EAST: {
                    port.getPosition().x = nodeSize.x + (double)portOffset;
                    port.getPosition().y = eastY - port.getAnchor().y;
                    eastY += eastDelta;
                    break;
                }
                case SOUTH: {
                    port.getPosition().x = southX - port.getAnchor().x;
                    port.getPosition().y = nodeSize.y + (double)portOffset;
                    southX -= southDelta;
                    break;
                }
                case WEST: {
                    port.getPosition().x = -port.getSize().x - (double)portOffset;
                    port.getPosition().y = westY - port.getAnchor().y;
                    westY -= westDelta;
                }
            }
        }
    }

    private void placeHypernodePorts(LNode node) {
        for (LPort port : node.getPorts()) {
            switch (port.getSide()) {
                case NORTH: {
                    port.getPosition().x = node.getSize().x / 2.0;
                    port.getPosition().y = 0.0;
                    break;
                }
                case EAST: {
                    port.getPosition().x = node.getSize().x;
                    port.getPosition().y = node.getSize().y / 2.0;
                    break;
                }
                case SOUTH: {
                    port.getPosition().x = node.getSize().x / 2.0;
                    port.getPosition().y = node.getSize().y;
                    break;
                }
                case WEST: {
                    port.getPosition().x = 0.0;
                    port.getPosition().y = node.getSize().y / 2.0;
                }
            }
        }
    }
}

