/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NorthSouthPortPreprocessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Odd port side processing", 1.0f);
        LinkedList<LNode> northDummyNodes = new LinkedList<LNode>();
        LinkedList<LNode> southDummyNodes = new LinkedList<LNode>();
        for (Layer layer : layeredGraph) {
            LNode[] nodeArray;
            int pointer = -1;
            LNode[] lNodeArray = nodeArray = layer.getNodes().toArray(new LNode[0]);
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                ++pointer;
                if (((NodeType)((Object)node.getProperty(Properties.NODE_TYPE))).equals((Object)NodeType.NORMAL) || !((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                    node.setProperty(Properties.IN_LAYER_LAYOUT_UNIT, node);
                    northDummyNodes.clear();
                    southDummyNodes.clear();
                    LinkedList<LNode> barycenterAssociates = new LinkedList<LNode>();
                    LinkedList<LPort> portList = new LinkedList<LPort>();
                    for (LPort port : node.getPorts(PortSide.NORTH)) {
                        portList.add(port);
                    }
                    this.createDummyNodes(layeredGraph, portList, northDummyNodes, southDummyNodes, barycenterAssociates);
                    int insertPoint = pointer;
                    LNode successor = node;
                    for (LNode dummy : northDummyNodes) {
                        dummy.setLayer(insertPoint, layer);
                        ++pointer;
                        dummy.setProperty(Properties.IN_LAYER_LAYOUT_UNIT, node);
                        dummy.setProperty(Properties.IN_LAYER_SUCCESSOR_CONSTRAINT, successor);
                        successor = dummy;
                    }
                    portList.clear();
                    for (LPort port : node.getPorts(PortSide.SOUTH)) {
                        portList.add(0, port);
                    }
                    this.createDummyNodes(layeredGraph, portList, southDummyNodes, null, barycenterAssociates);
                    LNode predecessor = node;
                    for (LNode dummy : southDummyNodes) {
                        dummy.setLayer(++pointer, layer);
                        dummy.setProperty(Properties.IN_LAYER_LAYOUT_UNIT, node);
                        predecessor.setProperty(Properties.IN_LAYER_SUCCESSOR_CONSTRAINT, dummy);
                        predecessor = dummy;
                    }
                    if (!barycenterAssociates.isEmpty()) {
                        node.setProperty(Properties.BARYCENTER_ASSOCIATES, barycenterAssociates);
                    }
                }
                ++n2;
            }
        }
    }

    private void createDummyNodes(LGraph layeredGraph, List<LPort> ports, List<LNode> dummyNodes, List<LNode> opposingSideDummyNodes, List<LNode> barycenterAssociates) {
        ArrayList<LPort> inPorts = new ArrayList<LPort>(ports.size());
        ArrayList<LPort> outPorts = new ArrayList<LPort>(ports.size());
        ArrayList<LPort> inOutPorts = new ArrayList<LPort>(ports.size());
        ArrayList<LEdge> sameSideSelfLoopEdges = new ArrayList<LEdge>(ports.size());
        ArrayList<LEdge> northSouthSelfLoopEdges = new ArrayList<LEdge>(ports.size());
        for (LPort port : ports) {
            boolean out;
            for (LEdge edge : port.getOutgoingEdges()) {
                if (edge.getSource().getNode() != edge.getTarget().getNode()) continue;
                if (port.getSide() == edge.getTarget().getSide()) {
                    sameSideSelfLoopEdges.add(edge);
                    continue;
                }
                if (port.getSide() != PortSide.NORTH || edge.getTarget().getSide() != PortSide.SOUTH) continue;
                northSouthSelfLoopEdges.add(edge);
            }
            boolean in = !port.getIncomingEdges().isEmpty();
            boolean bl = out = !port.getOutgoingEdges().isEmpty();
            if (in && out) {
                inOutPorts.add(port);
                continue;
            }
            if (in) {
                inPorts.add(port);
                continue;
            }
            if (!out) continue;
            outPorts.add(port);
        }
        for (LEdge edge : northSouthSelfLoopEdges) {
            this.createDummyNode(layeredGraph, edge, dummyNodes, opposingSideDummyNodes, PortSide.EAST);
        }
        for (LEdge edge : sameSideSelfLoopEdges) {
            this.createDummyNode(layeredGraph, edge, dummyNodes);
        }
        int inPortsIndex = 0;
        int outPortsIndex = outPorts.size() - 1;
        while (inPortsIndex < inPorts.size() && outPortsIndex >= 0) {
            LPort inPort = (LPort)inPorts.get(inPortsIndex);
            LPort outPort = (LPort)outPorts.get(outPortsIndex);
            if (ports.indexOf(outPort) < ports.indexOf(inPort)) break;
            barycenterAssociates.add(this.createDummyNode(layeredGraph, inPort, outPort, dummyNodes));
            ++inPortsIndex;
            --outPortsIndex;
        }
        while (inPortsIndex < inPorts.size()) {
            barycenterAssociates.add(this.createDummyNode(layeredGraph, (LPort)inPorts.get(inPortsIndex), null, dummyNodes));
            ++inPortsIndex;
        }
        while (outPortsIndex >= 0) {
            barycenterAssociates.add(this.createDummyNode(layeredGraph, null, (LPort)outPorts.get(outPortsIndex), dummyNodes));
            --outPortsIndex;
        }
        for (LPort inOutPort : inOutPorts) {
            barycenterAssociates.add(this.createDummyNode(layeredGraph, inOutPort, inOutPort, dummyNodes));
        }
    }

    private LNode createDummyNode(LGraph layeredGraph, LPort inPort, LPort outPort, List<LNode> dummyNodes) {
        LEdge edge;
        int n;
        int n2;
        LEdge[] lEdgeArray;
        LEdge[] edgeArray;
        LNode dummy = new LNode(layeredGraph);
        dummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.NORTH_SOUTH_PORT);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        int crossingHint = 0;
        if (inPort != null) {
            LPort dummyInputPort = new LPort(layeredGraph);
            dummyInputPort.setProperty(Properties.ORIGIN, inPort);
            dummy.setProperty(Properties.ORIGIN, inPort.getNode());
            dummyInputPort.setSide(PortSide.WEST);
            dummyInputPort.setNode(dummy);
            lEdgeArray = edgeArray = inPort.getIncomingEdges().toArray(new LEdge[0]);
            n2 = edgeArray.length;
            n = 0;
            while (n < n2) {
                edge = lEdgeArray[n];
                edge.setTarget(dummyInputPort);
                ++n;
            }
            ++crossingHint;
        }
        if (outPort != null) {
            LPort dummyOutputPort = new LPort(layeredGraph);
            dummy.setProperty(Properties.ORIGIN, outPort.getNode());
            dummyOutputPort.setProperty(Properties.ORIGIN, outPort);
            dummyOutputPort.setSide(PortSide.EAST);
            dummyOutputPort.setNode(dummy);
            lEdgeArray = edgeArray = outPort.getOutgoingEdges().toArray(new LEdge[0]);
            n2 = edgeArray.length;
            n = 0;
            while (n < n2) {
                edge = lEdgeArray[n];
                edge.setSource(dummyOutputPort);
                ++n;
            }
            ++crossingHint;
        }
        dummy.setProperty(Properties.CROSSING_HINT, crossingHint);
        dummyNodes.add(dummy);
        return dummy;
    }

    private void createDummyNode(LGraph layeredGraph, LEdge selfLoop, List<LNode> dummyNodes) {
        LNode dummy = new LNode(layeredGraph);
        dummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.NORTH_SOUTH_PORT);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        dummy.setProperty(Properties.ORIGIN, selfLoop);
        LPort dummyInputPort = new LPort(layeredGraph);
        dummyInputPort.setProperty(Properties.ORIGIN, selfLoop.getTarget());
        dummyInputPort.setSide(PortSide.WEST);
        dummyInputPort.setNode(dummy);
        LPort dummyOutputPort = new LPort(layeredGraph);
        dummyOutputPort.setProperty(Properties.ORIGIN, selfLoop.getSource());
        dummyOutputPort.setSide(PortSide.EAST);
        dummyOutputPort.setNode(dummy);
        selfLoop.setSource(null);
        selfLoop.setTarget(null);
        dummyNodes.add(dummy);
        dummy.setProperty(Properties.CROSSING_HINT, 2);
    }

    private void createDummyNode(LGraph layeredGraph, LEdge selfLoop, List<LNode> northDummyNodes, List<LNode> southDummyNodes, PortSide portSide) {
        LNode northDummy = new LNode(layeredGraph);
        northDummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.NORTH_SOUTH_PORT);
        northDummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        LPort northDummyOutputPort = new LPort(layeredGraph);
        northDummyOutputPort.setProperty(Properties.ORIGIN, selfLoop.getSource());
        northDummyOutputPort.setSide(portSide);
        northDummyOutputPort.setNode(northDummy);
        LNode southDummy = new LNode(layeredGraph);
        southDummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.NORTH_SOUTH_PORT);
        southDummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        LPort southDummyInputPort = new LPort(layeredGraph);
        southDummyInputPort.setProperty(Properties.ORIGIN, selfLoop.getTarget());
        southDummyInputPort.setSide(portSide);
        southDummyInputPort.setNode(southDummy);
        selfLoop.setSource(northDummyOutputPort);
        selfLoop.setTarget(southDummyInputPort);
        northDummyNodes.add(0, northDummy);
        southDummyNodes.add(southDummy);
        northDummy.setProperty(Properties.CROSSING_HINT, 1);
        southDummy.setProperty(Properties.CROSSING_HINT, 1);
    }
}

