/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.EdgeType;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LGraph
extends LGraphElement
implements Iterable<Layer> {
    private static final long serialVersionUID = -8006835373897072852L;
    private final KVector size = new KVector();
    private final LInsets.Double insets = new LInsets.Double(0.0, 0.0, 0.0, 0.0);
    private final KVector offset = new KVector();
    private final List<LNode> layerlessNodes = new LinkedList<LNode>();
    private final List<Layer> layers = new LinkedList<Layer>();
    private final LGraphElement.HashCodeCounter hashCodeCounter;

    LGraphElement.HashCodeCounter hashCodeCounter() {
        return this.hashCodeCounter;
    }

    public LGraph() {
        super(new LGraphElement.HashCodeCounter());
        this.hashCodeCounter = new LGraphElement.HashCodeCounter();
    }

    public LGraph(LGraphElement.HashCodeCounter counter) {
        super(counter);
        this.hashCodeCounter = counter;
    }

    public LGraph(LGraph originalGraph) {
        super(originalGraph.hashCodeCounter);
        this.hashCodeCounter = originalGraph.hashCodeCounter;
    }

    public String toString() {
        if (this.layers.isEmpty()) {
            return "G-unlayered" + this.layerlessNodes.toString();
        }
        if (this.layerlessNodes.isEmpty()) {
            return "G-layered" + this.layers.toString();
        }
        return "G[layerless" + this.layerlessNodes.toString() + ", layers" + this.layers.toString() + "]";
    }

    public KVector getSize() {
        return this.size;
    }

    public KVector getActualSize() {
        float borderSpacing = ((Float)this.getProperty((IProperty)Properties.BORDER_SPACING)).floatValue();
        return new KVector(this.size.x + this.insets.left + this.insets.right + (double)(2.0f * borderSpacing), this.size.y + this.insets.top + this.insets.bottom + (double)(2.0f * borderSpacing));
    }

    public LInsets.Double getInsets() {
        return this.insets;
    }

    public KVector getOffset() {
        return this.offset;
    }

    public List<LNode> getLayerlessNodes() {
        return this.layerlessNodes;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.layers.iterator();
    }

    public void writeDotGraph(Writer writer) throws IOException {
        writer.write("digraph {\n");
        writer.write("    rankdir=LR;\n");
        this.writeLayer(writer, -1, this.layerlessNodes);
        int layerNumber = -1;
        for (Layer layer : this.layers) {
            this.writeLayer(writer, ++layerNumber, layer.getNodes());
        }
        writer.write("}\n");
        writer.close();
    }

    private void writeLayer(Writer writer, int layerNumber, List<LNode> nodes) throws IOException {
        if (nodes.isEmpty()) {
            return;
        }
        writer.write("    {\n");
        if (layerNumber != -1) {
            writer.write("        rank=same;\n");
        }
        int nodeNumber = -1;
        for (LNode node : nodes) {
            ++nodeNumber;
            writer.write("        " + node.hashCode());
            StringBuffer options = new StringBuffer();
            options.append("label=\"");
            if (node.getProperty(Properties.NODE_TYPE) == NodeType.NORMAL) {
                if (node.getName() != null) {
                    options.append(String.valueOf(node.getName().replace("\"", "\\\"")) + " ");
                }
            } else {
                Object origin;
                if (node.getName() != null) {
                    options.append(String.valueOf(node.getName().replace("\"", "\\\"")) + " ");
                } else {
                    options.append("n_" + node.id + " ");
                }
                if (node.getProperty(Properties.NODE_TYPE) == NodeType.NORTH_SOUTH_PORT && (origin = node.getProperty(Properties.ORIGIN)) instanceof LNode) {
                    options.append("(" + ((LNode)origin).toString() + ")");
                }
            }
            options.append("(" + layerNumber + "," + nodeNumber + ")\",");
            if (((NodeType)((Object)node.getProperty(Properties.NODE_TYPE))).equals((Object)NodeType.NORMAL)) {
                options.append("shape=box,");
            } else {
                options.append("shape=circle,style=filled,");
                String color = ((NodeType)((Object)node.getProperty(Properties.NODE_TYPE))).getColor();
                if (color != null) {
                    options.append("color=\"" + color + "\",");
                }
            }
            options.deleteCharAt(options.length() - 1);
            if (options.length() > 0) {
                writer.write("[" + options + "]");
            }
            writer.write(";\n");
        }
        if (layerNumber != -1) {
            writer.write("    }\n");
        }
        for (LNode node : nodes) {
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    writer.write("    " + node.hashCode() + " -> " + edge.getTarget().getNode().hashCode());
                    if (edge.getProperty(Properties.EDGE_TYPE) == EdgeType.COMPOUND_DUMMY) {
                        writer.write(" [style=\"dashed\"]");
                    }
                    if (edge.getProperty(Properties.EDGE_TYPE) == EdgeType.COMPOUND_SIDE) {
                        writer.write(" [style=\"dotted\"]");
                    }
                    writer.write(";\n");
                }
            }
        }
        if (layerNumber == -1) {
            writer.write("    }\n");
        }
    }
}

