/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.hover;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.ui.hover.IKeywordHoverContentProvider;
import org.eclipse.etrice.core.common.ui.internal.CommonActivator;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.util.Files;

public class KeywordHoverProvider
extends DefaultEObjectHoverProvider {
    public static final String STYLE_SHEET_KEY = "keywordHoverStyleSheetFileName";
    @Inject(optional=true)
    @Named(value="keywordHoverStyleSheetFileName")
    private String styleSheetFileName;
    @Inject
    protected AbstractUIPlugin plugin;
    @Inject
    protected ILabelProvider labelProvider;
    @Inject
    protected IKeywordHoverContentProvider contentProvider;
    private String styleSheet = null;

    protected XtextBrowserInformationControlInput getHoverInfo(EObject element, IRegion hoverRegion, XtextBrowserInformationControlInput previous) {
        Keyword keyword;
        String html;
        if (element instanceof Keyword && (html = this.contentProvider.getHTMLContent((keyword = (Keyword)element).getValue())) != null) {
            StringBuffer buffer = new StringBuffer(html);
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getKeywordStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new XtextBrowserInformationControlInput(previous, element, buffer.toString(), this.labelProvider);
        }
        return super.getHoverInfo(element, hoverRegion, previous);
    }

    protected String getKeywordStyleSheet() {
        String superStyle = super.getStyleSheet();
        if (this.styleSheet == null) {
            this.styleSheet = "";
            try {
                URL url = null;
                url = this.plugin != null && this.styleSheetFileName != null ? this.plugin.getBundle().getEntry(this.styleSheetFileName) : CommonActivator.getInstance().getBundle().getEntry("/eTriceKeywordHoverStyle.css");
                this.styleSheet = Files.readStreamIntoString((InputStream)url.openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(superStyle) + this.styleSheet;
    }
}

