/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats;

import com.google.common.collect.MapMaker;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.DateTime;
import com.google.gdata.util.ParseException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectConverter<T> {
    private static final ConcurrentMap<Class<?>, ObjectConverter<?>> CONVERTERS = new MapMaker().makeMap();

    public static <V> void addConverter(Class<V> type, ObjectConverter<V> converter) {
        CONVERTERS.put(type, converter);
    }

    public static <V> V getValue(Object value, Class<V> datatype) throws ParseException {
        if (value instanceof String) {
            return ObjectConverter.getValue((String)value, datatype);
        }
        if (value == null || datatype.isInstance(value)) {
            return datatype.cast(value);
        }
        throw new ParseException("Cannot convert value " + value + " of type " + value.getClass() + " to " + datatype);
    }

    public static <V> V getValue(String value, Class<V> datatype) throws ParseException {
        if (value == null || datatype.isInstance(value)) {
            return datatype.cast(value);
        }
        try {
            ObjectConverter<V> handler = ObjectConverter.getHandler(datatype);
            if (handler != null) {
                return handler.convertValue(value, datatype);
            }
            Constructor<V> cons = datatype.getConstructor(String.class);
            return cons.newInstance(value);
        }
        catch (NoSuchMethodException e) {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.missingConverter);
            pe.setInternalReason("No converter for type " + datatype);
            throw pe;
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e);
        }
        catch (InstantiationException e) {
            throw new ParseException(e);
        }
        catch (IllegalAccessException e) {
            throw new ParseException(e);
        }
        catch (InvocationTargetException e) {
            throw new ParseException(e.getTargetException());
        }
    }

    public abstract T convertValue(String var1, Class<? extends T> var2) throws ParseException;

    private static <V> ObjectConverter<V> getHandler(Class<? extends V> type) {
        ObjectConverter handler = (ObjectConverter)CONVERTERS.get(type);
        if (handler == null && type.isEnum()) {
            handler = (ObjectConverter)CONVERTERS.get(Enum.class);
        }
        return handler;
    }

    static {
        ObjectConverter.addConverter(DateTime.class, new DateTimeConverter());
        ObjectConverter.addConverter(Enum.class, new EnumConverter());
        ObjectConverter.addConverter(Boolean.class, new BooleanConverter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappedEnumConverter<T>
    extends ObjectConverter<T> {
        private final Map<String, T> map;

        public MappedEnumConverter(Map<String, T> map) {
            this.map = map;
        }

        @Override
        public T convertValue(String value, Class<? extends T> datatype) throws ParseException {
            T converted = this.map.get(value);
            if (converted == null) {
                throw new ParseException(CoreErrorDomain.ERR.invalidEnumValue.withInternalReason("No such pseudo enum value of type " + datatype + " named " + value));
            }
            return converted;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanConverter
    extends ObjectConverter<Boolean> {
        private BooleanConverter() {
        }

        @Override
        public Boolean convertValue(String value, Class<? extends Boolean> datatype) throws ParseException {
            if (value == null) {
                return null;
            }
            if ("true".equals(value) || "1".equals(value) || "ture".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value) || "0".equals(value)) {
                return Boolean.FALSE;
            }
            throw new ParseException(CoreErrorDomain.ERR.invalidBooleanAttribute.withInternalReason("Invalid boolean value: '" + value + "'"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumConverter
    extends ObjectConverter<Enum> {
        private EnumConverter() {
        }

        @Override
        public Enum<?> convertValue(String value, Class<? extends Enum> datatype) throws ParseException {
            if (value == null) {
                return null;
            }
            Enum result = Enum.valueOf(datatype, value.toUpperCase());
            if (result == null) {
                throw new ParseException(CoreErrorDomain.ERR.invalidEnumValue.withInternalReason("No such enum of type " + datatype + " named " + value.toUpperCase()));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeConverter
    extends ObjectConverter<DateTime> {
        private DateTimeConverter() {
        }

        @Override
        public DateTime convertValue(String value, Class<? extends DateTime> datatype) throws ParseException {
            try {
                return DateTime.parseDateTimeChoice(value);
            }
            catch (NumberFormatException e) {
                throw new ParseException(CoreErrorDomain.ERR.invalidDatetime, (Throwable)e);
            }
        }
    }
}

