/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.BidirectionalMap;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.rule.reporting.LeafConditionDMRResolutionFailedReport;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.DomainModelReferenceChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.SettingPath;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.impl.Activator;
import org.eclipse.emf.ecp.view.spi.rule.model.AndCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.OrCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Rule;
import org.eclipse.emf.ecp.view.spi.rule.model.impl.LeafConditionSettingIterator;
import org.eclipse.emfforms.spi.common.report.AbstractReport;

public class RuleRegistry<T extends Rule> {
    private final Map<UniqueSetting, BidirectionalMap<Condition, T>> settingToRules;
    private final BidirectionalMap<T, VElement> rulesToRenderables;
    private final Map<Condition, Set<UniqueSetting>> conditionToSettings;
    private final ViewModelContext context;
    private final Map<Rule, Set<VDomainModelReference>> rulesToDMRs;

    public RuleRegistry(ViewModelContext context) {
        this.context = context;
        this.settingToRules = new LinkedHashMap<UniqueSetting, BidirectionalMap<Condition, T>>();
        this.rulesToRenderables = new BidirectionalMap();
        this.conditionToSettings = new LinkedHashMap<Condition, Set<UniqueSetting>>();
        this.rulesToDMRs = new LinkedHashMap<Rule, Set<VDomainModelReference>>();
    }

    public Set<UniqueSetting> register(VElement renderable, T rule, Condition condition, EObject domainModel) {
        LinkedHashSet<UniqueSetting> registeredSettings;
        block7: {
            block8: {
                block6: {
                    registeredSettings = new LinkedHashSet<UniqueSetting>();
                    if (!(condition instanceof LeafCondition)) break block6;
                    LeafCondition leafCondition = (LeafCondition)condition;
                    VDomainModelReference domainModelReference = leafCondition.getDomainModelReference();
                    if (domainModelReference == null) {
                        return registeredSettings;
                    }
                    boolean initSuccessful = domainModelReference.init(domainModel);
                    this.mapDomainToDMRs(rule, Collections.singleton(domainModelReference));
                    if (!initSuccessful) {
                        if (Activator.getDefault() != null) {
                            Activator.getDefault().getReportService().report((AbstractReport)new LeafConditionDMRResolutionFailedReport(leafCondition, false));
                        }
                        return this.registerLegacySupport(renderable, rule, registeredSettings, leafCondition, domainModelReference);
                    }
                    LeafConditionSettingIterator iterator = new LeafConditionSettingIterator(leafCondition, true);
                    while (iterator.hasNext()) {
                        EStructuralFeature.Setting setting = iterator.next();
                        UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)setting);
                        this.mapSettingToRule(uniqueSetting, (Condition)leafCondition, rule);
                        registeredSettings.add(uniqueSetting);
                    }
                    this.mapDomainToDMRs(rule, iterator.getUsedValueDomainModelReferences());
                    this.rulesToRenderables.put(rule, (Object)renderable);
                    break block7;
                }
                if (!(condition instanceof OrCondition)) break block8;
                OrCondition orCondition = (OrCondition)condition;
                for (Condition cond : orCondition.getConditions()) {
                    registeredSettings.addAll(this.register(renderable, rule, cond, domainModel));
                }
                break block7;
            }
            if (!(condition instanceof AndCondition)) break block7;
            AndCondition andCondition = (AndCondition)condition;
            for (Condition cond : andCondition.getConditions()) {
                registeredSettings.addAll(this.register(renderable, rule, cond, domainModel));
            }
        }
        return registeredSettings;
    }

    private Set<UniqueSetting> registerLegacySupport(VElement renderable, T rule, Set<UniqueSetting> registeredSettings, LeafCondition leafCondition, VDomainModelReference domainModelReference) {
        Iterator fullPathIterator = domainModelReference.getFullPathIterator();
        while (fullPathIterator.hasNext()) {
            SettingPath path = (SettingPath)fullPathIterator.next();
            Iterator pathIterator = path.getPath();
            boolean validIterator = pathIterator.hasNext();
            while (pathIterator.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)pathIterator.next();
                UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)setting);
                this.mapSettingToRule(uniqueSetting, (Condition)leafCondition, rule);
                registeredSettings.add(uniqueSetting);
            }
            if (!validIterator) continue;
            this.rulesToRenderables.put(rule, (Object)renderable);
        }
        return registeredSettings;
    }

    public VElement removeRule(T rule) {
        this.removeDMRListeners(rule);
        Condition condition = rule.getCondition();
        if (condition != null) {
            return this.removeCondition(condition);
        }
        Collection<BidirectionalMap<Condition, T>> values = this.settingToRules.values();
        for (BidirectionalMap<Condition, T> bidirectionalMap : values) {
            if (bidirectionalMap.removeByValue(rule) != null) break;
        }
        VElement renderable = (VElement)this.rulesToRenderables.getValue(rule);
        this.rulesToRenderables.removeByKey(rule);
        return renderable;
    }

    private void removeDMRListeners(T rule) {
        Set<VDomainModelReference> dmrs = this.rulesToDMRs.remove(rule);
        if (dmrs != null) {
            for (VDomainModelReference dmr : dmrs) {
                this.context.unregisterDomainChangeListener((ModelChangeListener)dmr);
                Iterator iterator = dmr.getChangeListener().iterator();
                while (iterator.hasNext()) {
                    DomainModelReferenceChangeListener next = (DomainModelReferenceChangeListener)iterator.next();
                    if (!DMRChangeListener.class.isInstance(next)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public void removeRenderable(VElement renderable) {
        Rule rule = (Rule)this.rulesToRenderables.removeByValue((Object)renderable);
        this.removeDMRListeners(rule);
    }

    public VElement removeCondition(Condition condition) {
        VElement ret = null;
        Rule rule = null;
        if (LeafCondition.class.isInstance(condition)) {
            Set<UniqueSetting> settings = this.conditionToSettings.remove(condition);
            if (settings == null) {
                return ret;
            }
            for (UniqueSetting setting : settings) {
                BidirectionalMap<Condition, T> rules = this.settingToRules.get(setting);
                if (rules.keys().contains(condition)) {
                    rule = (Rule)rules.removeByKey((Object)condition);
                }
                if (!rules.keys().isEmpty()) continue;
                this.settingToRules.remove(setting);
            }
        }
        this.conditionToSettings.remove(condition);
        if (rule != null) {
            this.removeDMRListeners(rule);
            ret = (VElement)this.rulesToRenderables.removeByKey(rule);
        }
        return ret;
    }

    private void mapSettingToRule(UniqueSetting uniqueSetting, Condition condition, T rule) {
        if (!this.settingToRules.containsKey(uniqueSetting)) {
            this.settingToRules.put(uniqueSetting, new BidirectionalMap());
        }
        this.settingToRules.get(uniqueSetting).put((Object)condition, rule);
        if (!this.conditionToSettings.containsKey(condition)) {
            this.conditionToSettings.put(condition, new LinkedHashSet());
        }
        this.conditionToSettings.get(condition).add(uniqueSetting);
    }

    public Set<UniqueSetting> getSettings() {
        return this.settingToRules.keySet();
    }

    public Map<T, VElement> getAffectedRenderables(UniqueSetting setting) {
        LinkedHashMap<Rule, VElement> result = new LinkedHashMap<Rule, VElement>();
        BidirectionalMap<Condition, T> bidirectionalMap = this.settingToRules.get(setting);
        if (bidirectionalMap == null) {
            return Collections.emptyMap();
        }
        for (Rule rule : bidirectionalMap.values()) {
            VElement renderable = (VElement)this.rulesToRenderables.getValue((Object)rule);
            result.put(rule, renderable);
        }
        return result;
    }

    private void mapDomainToDMRs(T rule, Set<VDomainModelReference> references) {
        if (!this.rulesToDMRs.containsKey(rule)) {
            this.rulesToDMRs.put((Rule)rule, new LinkedHashSet());
        }
        this.rulesToDMRs.get(rule).addAll(references);
        for (VDomainModelReference reference : references) {
            reference.getChangeListener().add((Object)new DMRChangeListener(this, rule));
            this.context.registerDomainChangeListener((ModelChangeListener)reference);
        }
    }

    private static class DMRChangeListener
    implements DomainModelReferenceChangeListener {
        private final T rule;
        final /* synthetic */ RuleRegistry this$0;

        public DMRChangeListener(T rule) {
            this.this$0 = var1_1;
            this.rule = rule;
        }

        public void notifyChange() {
            Set dmrs = (Set)this.this$0.rulesToDMRs.remove(this.rule);
            if (dmrs == null) {
                return;
            }
            for (VDomainModelReference dmr : dmrs) {
                this.this$0.context.unregisterDomainChangeListener((ModelChangeListener)dmr);
                dmr.getChangeListener().remove((Object)this);
            }
            VElement element = this.this$0.removeRule(this.rule);
            if (element == null) {
                return;
            }
            this.this$0.register(element, this.rule, this.rule.getCondition(), this.this$0.context.getDomainModel());
        }
    }
}

