/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.l10n.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.l10n.nLSDsl.Message;
import org.eclipse.fx.ide.l10n.nLSDsl.MessageEntry;
import org.eclipse.fx.ide.l10n.nLSDsl.MessageParam;
import org.eclipse.fx.ide.l10n.nLSDsl.NLS;
import org.eclipse.fx.ide.l10n.nLSDsl.NLSBundle;
import org.eclipse.fx.ide.l10n.nLSDsl.NLSFormatter;
import org.eclipse.fx.ide.l10n.nLSDsl.PackageDeclaration;
import org.eclipse.fx.ide.l10n.nLSDsl.PredefinedTypes;
import org.eclipse.fx.ide.l10n.nLSDsl.RichString;
import org.eclipse.fx.ide.l10n.nLSDsl.RichStringLiteral;
import org.eclipse.fx.ide.l10n.nLSDsl.RichStringLiteralEnd;
import org.eclipse.fx.ide.l10n.nLSDsl.RichStringLiteralInbetween;
import org.eclipse.fx.ide.l10n.nLSDsl.RichStringLiteralStart;
import org.eclipse.fx.ide.l10n.nLSDsl.RichVarPart;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class NLSDslGenerator
implements IGenerator {
    public void doGenerate(Resource resource, final IFileSystemAccess fsa) {
        EList _contents = resource.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        final NLS root = (NLS)_head;
        EList<NLSBundle> _bundleList = root.getBundleList();
        Consumer<NLSBundle> _function = new Consumer<NLSBundle>(){

            @Override
            public void accept(NLSBundle b) {
                NLSDslGenerator.this.handleBundle(root, b, fsa);
            }
        };
        _bundleList.forEach((Consumer)_function);
    }

    public void handleBundle(final NLS root, final NLSBundle b, final IFileSystemAccess fsa) {
        PackageDeclaration _package = root.getPackage();
        String _name = _package.getName();
        String _replace = _name.replace(".", "/");
        String _plus = String.valueOf(_replace) + "/";
        String _name_1 = b.getName();
        String _plus_1 = String.valueOf(_plus) + _name_1;
        String _plus_2 = String.valueOf(_plus_1) + ".properties";
        String _lang = b.getLang();
        CharSequence _genPropertyFile = this.genPropertyFile(b, _lang);
        fsa.generateFile(_plus_2, _genPropertyFile);
        PackageDeclaration _package_1 = root.getPackage();
        String _name_2 = _package_1.getName();
        String _replace_1 = _name_2.replace(".", "/");
        String _plus_3 = String.valueOf(_replace_1) + "/";
        String _name_3 = b.getName();
        String _plus_4 = String.valueOf(_plus_3) + _name_3;
        String _plus_5 = String.valueOf(_plus_4) + ".java";
        CharSequence _genClass = this.genClass(b, root);
        fsa.generateFile(_plus_5, _genClass);
        PackageDeclaration _package_2 = root.getPackage();
        String _name_4 = _package_2.getName();
        String _replace_2 = _name_4.replace(".", "/");
        String _plus_6 = String.valueOf(_replace_2) + "/";
        String _name_5 = b.getName();
        String _plus_7 = String.valueOf(_plus_6) + _name_5;
        String _plus_8 = String.valueOf(_plus_7) + "Registry.java";
        CharSequence _genRegistryClass = this.genRegistryClass(b, root);
        fsa.generateFile(_plus_8, _genRegistryClass);
        HashSet set = new HashSet();
        EList<MessageEntry> _messageEntryList = b.getMessageEntryList();
        Functions.Function2<HashSet<String>, MessageEntry, HashSet<String>> _function = new Functions.Function2<HashSet<String>, MessageEntry, HashSet<String>>(){

            public HashSet<String> apply(HashSet<String> r, MessageEntry s) {
                EList<Message> _messageList = s.getMessageList();
                Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

                    public Boolean apply(Message m) {
                        String _name = m.getName();
                        return !Objects.equal((Object)_name, null);
                    }
                };
                Iterable _filter = IterableExtensions.filter(_messageList, (Functions.Function1)_function);
                Functions.Function1<Message, String> _function_1 = new Functions.Function1<Message, String>(){

                    public String apply(Message m) {
                        return m.getName();
                    }
                };
                Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
                Iterables.addAll(r, (Iterable)_map);
                return r;
            }
        };
        HashSet _fold = (HashSet)IterableExtensions.fold(_messageEntryList, set, (Functions.Function2)_function);
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String lang) {
                PackageDeclaration _package = root.getPackage();
                String _name = _package.getName();
                String _replace = _name.replace(".", "/");
                String _plus = String.valueOf(_replace) + "/";
                String _name_1 = b.getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + "_";
                String _plus_3 = String.valueOf(_plus_2) + lang;
                String _plus_4 = String.valueOf(_plus_3) + ".properties";
                CharSequence _genPropertyFile = NLSDslGenerator.this.genPropertyFile(b, lang);
                fsa.generateFile(_plus_4, _genPropertyFile);
            }
        };
        _fold.forEach(_function_1);
    }

    public CharSequence genClass(NLSBundle nls, NLS root) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        PackageDeclaration _package = root.getPackage();
        String _name = _package.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Do not modify - Auto generated from ");
        Resource _eResource = root.eResource();
        URI _uRI = _eResource.getURI();
        String _lastSegment = _uRI.lastSegment();
        _builder.append((Object)_lastSegment, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = nls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        EList<MessageEntry> _messageEntryList = nls.getMessageEntryList();
        Functions.Function1<MessageEntry, Boolean> _function = new Functions.Function1<MessageEntry, Boolean>(){

            public Boolean apply(MessageEntry m) {
                MessageEntry _entryRef = m.getEntryRef();
                return Objects.equal((Object)_entryRef, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(_messageEntryList, (Functions.Function1)_function);
        for (MessageEntry me : _filter) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public String ");
            String _name_2 = me.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence genRegistryClass(NLSBundle nls, NLS root) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        PackageDeclaration _package = root.getPackage();
        String _name = _package.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Do not modify - Auto generated from ");
        Resource _eResource = root.eResource();
        URI _uRI = _eResource.getURI();
        String _lastSegment = _uRI.lastSegment();
        _builder.append((Object)_lastSegment, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@org.eclipse.e4.core.di.annotations.Creatable");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = nls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"Registry extends org.eclipse.fx.core.text.AbstractTextRegistry<");
        String _name_2 = nls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"> {");
        _builder.newLineIfNotEmpty();
        TreeIterator _eAllContents = nls.eAllContents();
        UnmodifiableIterator _filter = Iterators.filter((Iterator)_eAllContents, RichVarPart.class);
        Functions.Function1<RichVarPart, Boolean> _function = new Functions.Function1<RichVarPart, Boolean>(){

            public Boolean apply(RichVarPart p) {
                String _findFormatter = NLSDslGenerator.this.findFormatter(p);
                return Objects.equal((Object)_findFormatter, (Object)"-number");
            }
        };
        RichVarPart _findFirst = (RichVarPart)IteratorExtensions.findFirst((Iterator)_filter, (Functions.Function1)_function);
        boolean bl = _notEquals = !Objects.equal((Object)_findFirst, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@javax.inject.Inject");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private org.eclipse.fx.core.text.NumberFormatter _number;");
            _builder.newLine();
        }
        _builder.newLine();
        TreeIterator _eAllContents_1 = nls.eAllContents();
        UnmodifiableIterator _filter_1 = Iterators.filter((Iterator)_eAllContents_1, RichVarPart.class);
        Functions.Function1<RichVarPart, Boolean> _function_1 = new Functions.Function1<RichVarPart, Boolean>(){

            public Boolean apply(RichVarPart p) {
                String _findFormatter = NLSDslGenerator.this.findFormatter(p);
                return Objects.equal((Object)_findFormatter, (Object)"-date");
            }
        };
        RichVarPart _findFirst_1 = (RichVarPart)IteratorExtensions.findFirst((Iterator)_filter_1, (Functions.Function1)_function_1);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_findFirst_1, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@javax.inject.Inject");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private org.eclipse.fx.core.text.DateFormatter _date;");
            _builder.newLine();
        }
        _builder.newLine();
        TreeIterator _eAllContents_2 = nls.eAllContents();
        UnmodifiableIterator _filter_2 = Iterators.filter((Iterator)_eAllContents_2, RichVarPart.class);
        Functions.Function1<RichVarPart, Boolean> _function_2 = new Functions.Function1<RichVarPart, Boolean>(){

            public Boolean apply(RichVarPart p) {
                String _findFormatter = NLSDslGenerator.this.findFormatter(p);
                return Objects.equal((Object)_findFormatter, (Object)"-temporal");
            }
        };
        RichVarPart _findFirst_2 = (RichVarPart)IteratorExtensions.findFirst((Iterator)_filter_2, (Functions.Function1)_function_2);
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_findFirst_2, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@javax.inject.Inject");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private org.eclipse.fx.core.text.TemporalAccessorFormatter _temporal;");
            _builder.newLine();
        }
        _builder.newLine();
        EList<NLSFormatter> _formatterList = nls.getFormatterList();
        for (NLSFormatter f : _formatterList) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@javax.inject.Inject");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private ");
            String _classRef = f.getClassRef();
            _builder.append((Object)_classRef, "\t");
            _builder.append((Object)" cust_");
            String _name_3 = f.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList<MessageEntry> _messageEntryList = nls.getMessageEntryList();
        Functions.Function1<MessageEntry, Boolean> _function_3 = new Functions.Function1<MessageEntry, Boolean>(){

            public Boolean apply(MessageEntry m) {
                MessageEntry _entryRef = m.getEntryRef();
                return !Objects.equal((Object)_entryRef, null);
            }
        };
        Iterable _filter_3 = IterableExtensions.filter(_messageEntryList, (Functions.Function1)_function_3);
        HashSet _hashSet = new HashSet();
        Functions.Function2<HashSet<NLSBundle>, MessageEntry, HashSet<NLSBundle>> _function_4 = new Functions.Function2<HashSet<NLSBundle>, MessageEntry, HashSet<NLSBundle>>(){

            public HashSet<NLSBundle> apply(HashSet<NLSBundle> s, MessageEntry e) {
                MessageEntry _entryRef = e.getEntryRef();
                NLSBundle _findNLSBundle = NLSDslGenerator.this.findNLSBundle(_entryRef);
                s.add(_findNLSBundle);
                return s;
            }
        };
        HashSet _fold = (HashSet)IterableExtensions.fold((Iterable)_filter_3, _hashSet, (Functions.Function2)_function_4);
        for (NLSBundle b : _fold) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@javax.inject.Inject");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private ");
            EObject _eContainer = b.eContainer();
            PackageDeclaration _package_1 = ((NLS)_eContainer).getPackage();
            String _name_4 = _package_1.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)".");
            String _name_5 = b.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)"Registry bundle_");
            String _name_6 = b.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@javax.inject.Inject");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void updateMessages(@org.eclipse.e4.core.services.nls.Translation ");
        String _name_7 = nls.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)" messages) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super.updateMessages(messages);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public java.util.function.Supplier<String> getSupplierByKey(String key, Object... values) {");
        _builder.newLine();
        EList<MessageEntry> _messageEntryList_1 = nls.getMessageEntryList();
        for (final MessageEntry me : _messageEntryList_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"switch(key) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"case \"");
            String _name_8 = me.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)"\":");
            _builder.newLineIfNotEmpty();
            EList<MessageParam> _paramList = me.getParamList();
            boolean _isEmpty = _paramList.isEmpty();
            if (_isEmpty) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return this::");
                String _name_9 = me.getName();
                _builder.append((Object)_name_9, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return ");
                String _name_10 = me.getName();
                _builder.append((Object)_name_10, "\t\t\t");
                _builder.append((Object)"_supplier(");
                EList<MessageParam> _paramList_1 = me.getParamList();
                Functions.Function1<MessageParam, String> _function_5 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        PredefinedTypes _predefined = p.getPredefined();
                        String _sourceString = NLSDslGenerator.this.toSourceString(_predefined);
                        String _plus = "(" + _sourceString;
                        String _plus_1 = String.valueOf(_plus) + ") values[";
                        EList<MessageParam> _paramList = me.getParamList();
                        int _indexOf = _paramList.indexOf((Object)p);
                        String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_indexOf);
                        return String.valueOf(_plus_2) + "]";
                    }
                };
                List _map = ListExtensions.map(_paramList_1, (Functions.Function1)_function_5);
                String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
                _builder.append((Object)_join, "\t\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"Key '\"+key+\"' is unknown\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList<MessageEntry> _messageEntryList_2 = nls.getMessageEntryList();
        for (MessageEntry me_1 : _messageEntryList_2) {
            boolean _not;
            boolean _notEquals_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"public String ");
            String _name_11 = me_1.getName();
            _builder.append((Object)_name_11, "\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            MessageEntry _entryRef = me_1.getEntryRef();
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)_entryRef, null);
            if (_notEquals_3) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return bundle_");
                MessageEntry _entryRef_1 = me_1.getEntryRef();
                NLSBundle _findNLSBundle = this.findNLSBundle(_entryRef_1);
                String _name_12 = _findNLSBundle.getName();
                _builder.append((Object)_name_12, "\t\t");
                _builder.append((Object)".");
                MessageEntry _entryRef_2 = me_1.getEntryRef();
                String _name_13 = _entryRef_2.getName();
                _builder.append((Object)_name_13, "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return getMessages().");
                String _name_14 = me_1.getName();
                _builder.append((Object)_name_14, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            EList<MessageParam> _paramList_2 = me_1.getParamList();
            boolean _isEmpty_1 = _paramList_2.isEmpty();
            boolean bl5 = _not = !_isEmpty_1;
            if (_not) {
                boolean _notEquals_4;
                _builder.append((Object)"\t");
                _builder.append((Object)"public String ");
                String _name_15 = me_1.getName();
                _builder.append((Object)_name_15, "\t");
                _builder.append((Object)"(");
                EList<MessageParam> _paramList_3 = me_1.getParamList();
                Functions.Function1<MessageParam, String> _function_6 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        PredefinedTypes _predefined = p.getPredefined();
                        String _sourceString = NLSDslGenerator.this.toSourceString(_predefined);
                        String _plus = String.valueOf(_sourceString) + " ";
                        String _var = p.getVar();
                        return String.valueOf(_plus) + _var;
                    }
                };
                List _map_1 = ListExtensions.map(_paramList_3, (Functions.Function1)_function_6);
                String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)", ");
                _builder.append((Object)_join_1, "\t");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                MessageEntry _entryRef_3 = me_1.getEntryRef();
                boolean bl6 = _notEquals_4 = !Objects.equal((Object)_entryRef_3, null);
                if (_notEquals_4) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return bundle_");
                    MessageEntry _entryRef_4 = me_1.getEntryRef();
                    NLSBundle _findNLSBundle_1 = this.findNLSBundle(_entryRef_4);
                    String _name_16 = _findNLSBundle_1.getName();
                    _builder.append((Object)_name_16, "\t\t");
                    _builder.append((Object)".");
                    MessageEntry _entryRef_5 = me_1.getEntryRef();
                    String _name_17 = _entryRef_5.getName();
                    _builder.append((Object)_name_17, "\t\t");
                    _builder.append((Object)"(");
                    EList<MessageParam> _paramList_4 = me_1.getParamList();
                    Functions.Function1<MessageParam, String> _function_7 = new Functions.Function1<MessageParam, String>(){

                        public String apply(MessageParam p) {
                            return p.getVar();
                        }
                    };
                    List _map_2 = ListExtensions.map(_paramList_4, (Functions.Function1)_function_7);
                    String _join_2 = IterableExtensions.join((Iterable)_map_2, (CharSequence)", ");
                    _builder.append((Object)_join_2, "\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _notEquals_5;
                    Functions.Function1<RichVarPart, Boolean> _function_8;
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"java.util.Map<String,Object> dataMap = new java.util.HashMap<>();");
                    _builder.newLine();
                    EList<MessageParam> _paramList_5 = me_1.getParamList();
                    for (MessageParam p : _paramList_5) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"dataMap.put(\"");
                        String _var = p.getVar();
                        _builder.append((Object)_var, "\t\t");
                        _builder.append((Object)"\",");
                        String _var_1 = p.getVar();
                        _builder.append((Object)_var_1, "\t\t");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                    }
                    EList<Message> _messageList = me_1.getMessageList();
                    Message _head = (Message)IterableExtensions.head(_messageList);
                    RichString _message = _head.getMessage();
                    EList<EObject> _expressions = _message.getExpressions();
                    Iterable _filter_4 = Iterables.filter(_expressions, RichVarPart.class);
                    RichVarPart _findFirst_3 = (RichVarPart)IterableExtensions.findFirst((Iterable)_filter_4, (Functions.Function1)(_function_8 = new Functions.Function1<RichVarPart, Boolean>(){

                        public Boolean apply(RichVarPart p) {
                            String _format = p.getFormat();
                            return !Objects.equal((Object)_format, null);
                        }
                    }));
                    boolean bl7 = _notEquals_5 = !Objects.equal((Object)_findFirst_3, null);
                    if (_notEquals_5) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"java.util.Map<String,org.eclipse.fx.core.text.Formatter<?>> formatterMap = new java.util.HashMap<>();");
                        _builder.newLine();
                        EList<Message> _messageList_1 = me_1.getMessageList();
                        Message _head_1 = (Message)IterableExtensions.head(_messageList_1);
                        RichString _message_1 = _head_1.getMessage();
                        EList<EObject> _expressions_1 = _message_1.getExpressions();
                        Iterable _filter_5 = Iterables.filter(_expressions_1, RichVarPart.class);
                        Functions.Function1<RichVarPart, Boolean> _function_9 = new Functions.Function1<RichVarPart, Boolean>(){

                            public Boolean apply(RichVarPart p) {
                                String _format = p.getFormat();
                                return !Objects.equal((Object)_format, null);
                            }
                        };
                        Iterable _filter_6 = IterableExtensions.filter((Iterable)_filter_5, (Functions.Function1)_function_9);
                        Functions.Function1<RichVarPart, String> _function_10 = new Functions.Function1<RichVarPart, String>(){

                            public String apply(RichVarPart it) {
                                return NLSDslGenerator.this.findFormatter(it);
                            }
                        };
                        Iterable _map_3 = IterableExtensions.map((Iterable)_filter_6, (Functions.Function1)_function_10);
                        HashSet _hashSet_1 = new HashSet();
                        Functions.Function2<HashSet<String>, String, HashSet<String>> _function_11 = new Functions.Function2<HashSet<String>, String, HashSet<String>>(){

                            public HashSet<String> apply(HashSet<String> s, String p) {
                                s.add(p);
                                return s;
                            }
                        };
                        HashSet _fold_1 = (HashSet)IterableExtensions.fold((Iterable)_map_3, _hashSet_1, (Functions.Function2)_function_11);
                        for (String o : _fold_1) {
                            boolean _equals = Objects.equal((Object)o, (Object)"-default");
                            if (_equals) {
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"formatterMap.put(\"");
                                _builder.append((Object)o, "\t\t");
                                _builder.append((Object)"\",org.eclipse.fx.core.text.Formatter.TO_STRING);");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            boolean _equals_1 = Objects.equal((Object)o, (Object)"-date");
                            if (_equals_1) {
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"formatterMap.put(\"");
                                _builder.append((Object)o, "\t\t");
                                _builder.append((Object)"\",_date);");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            boolean _equals_2 = Objects.equal((Object)o, (Object)"-number");
                            if (_equals_2) {
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"formatterMap.put(\"");
                                _builder.append((Object)o, "\t\t");
                                _builder.append((Object)"\",_number);");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            boolean _equals_3 = Objects.equal((Object)o, (Object)"-temporal");
                            if (_equals_3) {
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"formatterMap.put(\"");
                                _builder.append((Object)o, "\t\t");
                                _builder.append((Object)"\",_temporal);");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"formatterMap.put(\"");
                            _builder.append((Object)o, "\t\t");
                            _builder.append((Object)"\",cust_");
                            _builder.append((Object)o, "\t\t");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return org.eclipse.fx.core.text.MessageFormatter.create(dataMap::get,formatterMap::get).apply( ");
                        String _name_18 = me_1.getName();
                        _builder.append((Object)_name_18, "\t\t");
                        _builder.append((Object)"() );");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return org.apache.commons.lang.text.StrSubstitutor.replace( ");
                        String _name_19 = me_1.getName();
                        _builder.append((Object)_name_19, "\t\t");
                        _builder.append((Object)"(), dataMap);");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public java.util.function.Supplier<String> ");
                String _name_20 = me_1.getName();
                _builder.append((Object)_name_20, "\t");
                _builder.append((Object)"_supplier(");
                EList<MessageParam> _paramList_6 = me_1.getParamList();
                Functions.Function1<MessageParam, String> _function_12 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        PredefinedTypes _predefined = p.getPredefined();
                        String _sourceString = NLSDslGenerator.this.toSourceString(_predefined);
                        String _plus = String.valueOf(_sourceString) + " ";
                        String _var = p.getVar();
                        return String.valueOf(_plus) + _var;
                    }
                };
                List _map_4 = ListExtensions.map(_paramList_6, (Functions.Function1)_function_12);
                String _join_3 = IterableExtensions.join((Iterable)_map_4, (CharSequence)", ");
                _builder.append((Object)_join_3, "\t");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return () -> ");
                String _name_21 = me_1.getName();
                _builder.append((Object)_name_21, "\t\t");
                _builder.append((Object)"(");
                EList<MessageParam> _paramList_7 = me_1.getParamList();
                Functions.Function1<MessageParam, String> _function_13 = new Functions.Function1<MessageParam, String>(){

                    public String apply(MessageParam p) {
                        return p.getVar();
                    }
                };
                List _map_5 = ListExtensions.map(_paramList_7, (Functions.Function1)_function_13);
                String _join_4 = IterableExtensions.join((Iterable)_map_5, (CharSequence)", ");
                _builder.append((Object)_join_4, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public String toSourceString(PredefinedTypes t) {
        boolean _equals = Objects.equal((Object)((Object)t), (Object)((Object)PredefinedTypes.ANY));
        if (_equals) {
            return "Object";
        }
        boolean _equals_1 = Objects.equal((Object)((Object)t), (Object)((Object)PredefinedTypes.DATE));
        if (_equals_1) {
            return "java.util.Date";
        }
        boolean _equals_2 = Objects.equal((Object)((Object)t), (Object)((Object)PredefinedTypes.TEMPORAL));
        if (_equals_2) {
            return "java.time.temporal.TemporalAccessor";
        }
        return "Number";
    }

    public CharSequence genPropertyFile(NLSBundle nls, final String lang) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#");
        _builder.newLine();
        _builder.append((Object)"# Do not modify - Auto generated from ");
        Resource _eResource = nls.eResource();
        URI _uRI = _eResource.getURI();
        String _lastSegment = _uRI.lastSegment();
        _builder.append((Object)_lastSegment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#");
        _builder.newLine();
        EList<MessageEntry> _messageEntryList = nls.getMessageEntryList();
        Functions.Function1<MessageEntry, Boolean> _function = new Functions.Function1<MessageEntry, Boolean>(){

            public Boolean apply(MessageEntry m) {
                Functions.Function1<Message, Boolean> _function;
                EList<Message> _messageList = m.getMessageList();
                Message _findFirst = (Message)IterableExtensions.findFirst(_messageList, (Functions.Function1)(_function = new Functions.Function1<Message, Boolean>(){

                    public Boolean apply(Message mm) {
                        String _name = mm.getName();
                        return Objects.equal((Object)_name, (Object)lang);
                    }
                }));
                return !Objects.equal((Object)_findFirst, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(_messageEntryList, (Functions.Function1)_function);
        for (MessageEntry e : _filter) {
            String _name = e.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" = ");
            EList<Message> _messageList = e.getMessageList();
            Functions.Function1<Message, Boolean> _function_1 = new Functions.Function1<Message, Boolean>(){

                public Boolean apply(Message m) {
                    String _name = m.getName();
                    return Objects.equal((Object)_name, (Object)lang);
                }
            };
            Message _findFirst = (Message)IterableExtensions.findFirst(_messageList, (Functions.Function1)_function_1);
            RichString _message = _findFirst.getMessage();
            String _text = this.toText(_message);
            _builder.append((Object)_text, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String toText(RichString r) {
        EList<EObject> _expressions = r.getExpressions();
        Functions.Function1<EObject, String> _function = new Functions.Function1<EObject, String>(){

            public String apply(EObject e) {
                if (e instanceof RichStringLiteral) {
                    String _value = ((RichStringLiteral)e).getValue();
                    String _value_1 = ((RichStringLiteral)e).getValue();
                    int _length = _value_1.length();
                    int _minus = _length - 3;
                    return _value.substring(3, _minus);
                }
                if (e instanceof RichStringLiteralStart) {
                    String _value_2 = ((RichStringLiteralStart)e).getValue();
                    String _value_3 = ((RichStringLiteralStart)e).getValue();
                    int _length_1 = _value_3.length();
                    int _minus_1 = _length_1 - 1;
                    return _value_2.substring(3, _minus_1);
                }
                if (e instanceof RichStringLiteralEnd) {
                    String _value_4 = ((RichStringLiteralEnd)e).getValue();
                    String _value_5 = ((RichStringLiteralEnd)e).getValue();
                    int _length_2 = _value_5.length();
                    int _minus_2 = _length_2 - 3;
                    return _value_4.substring(1, _minus_2);
                }
                if (e instanceof RichVarPart) {
                    String _key = ((RichVarPart)e).getKey();
                    String _plus = "${" + _key;
                    String _xifexpression = null;
                    String _format = ((RichVarPart)e).getFormat();
                    boolean _notEquals = !Objects.equal((Object)_format, null);
                    _xifexpression = _notEquals ? "," + NLSDslGenerator.this.findFormatter((RichVarPart)e) + "," + ((RichVarPart)e).getFormat() + "}" : "}";
                    return String.valueOf(_plus) + _xifexpression;
                }
                if (e instanceof RichStringLiteralInbetween) {
                    String _value_6 = ((RichStringLiteralInbetween)e).getValue();
                    String _value_7 = ((RichStringLiteralInbetween)e).getValue();
                    int _length_3 = _value_7.length();
                    int _minus_3 = _length_3 - 1;
                    return _value_6.substring(1, _minus_3);
                }
                return e.toString();
            }
        };
        List _map = ListExtensions.map(_expressions, (Functions.Function1)_function);
        return IterableExtensions.join((Iterable)_map);
    }

    public String findFormatter(final RichVarPart p) {
        Functions.Function1<MessageParam, Boolean> _function;
        boolean _notEquals;
        NLSFormatter _formatterClass = p.getFormatterClass();
        boolean bl = _notEquals = !Objects.equal((Object)_formatterClass, null);
        if (_notEquals) {
            NLSFormatter _formatterClass_1 = p.getFormatterClass();
            return _formatterClass_1.getName();
        }
        MessageEntry _findMessageEntry = this.findMessageEntry(p);
        EList<MessageParam> _paramList = _findMessageEntry.getParamList();
        MessageParam _findFirst = (MessageParam)IterableExtensions.findFirst(_paramList, (Functions.Function1)(_function = new Functions.Function1<MessageParam, Boolean>(){

            public Boolean apply(MessageParam param) {
                String _var = param.getVar();
                String _key = p.getKey();
                return Objects.equal((Object)_var, (Object)_key);
            }
        }));
        PredefinedTypes _predefined = _findFirst.getPredefined();
        if (_predefined != null) {
            switch (_predefined) {
                case DATE: {
                    return "-date";
                }
                case NUMBER: {
                    return "-number";
                }
                case TEMPORAL: {
                    return "-temporal";
                }
            }
            return "-default";
        }
        return "-default";
    }

    public NLSBundle findNLSBundle(EObject e) {
        EObject _eContainer = e.eContainer();
        if (_eContainer instanceof NLSBundle) {
            EObject _eContainer_1 = e.eContainer();
            return (NLSBundle)_eContainer_1;
        }
        EObject _eContainer_2 = e.eContainer();
        NLSBundle _findNLSBundle = null;
        if (_eContainer_2 != null) {
            _findNLSBundle = this.findNLSBundle(_eContainer_2);
        }
        return _findNLSBundle;
    }

    public MessageEntry findMessageEntry(EObject e) {
        EObject _eContainer = e.eContainer();
        if (_eContainer instanceof MessageEntry) {
            EObject _eContainer_1 = e.eContainer();
            return (MessageEntry)_eContainer_1;
        }
        EObject _eContainer_2 = e.eContainer();
        MessageEntry _findMessageEntry = null;
        if (_eContainer_2 != null) {
            _findMessageEntry = this.findMessageEntry(_eContainer_2);
        }
        return _findMessageEntry;
    }
}

