/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.internal.registry.osgi.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.fx.ide.fxml.editors.FXMLCompletionProposal;
import org.eclipse.fx.ide.fxml.editors.Util;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXCollectionProperty;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.fx.ide.model.IFXCtrlField;
import org.eclipse.fx.ide.model.IFXEnumProperty;
import org.eclipse.fx.ide.model.IFXEventHandlerProperty;
import org.eclipse.fx.ide.model.IFXObjectProperty;
import org.eclipse.fx.ide.model.IFXPrimitiveProperty;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.fx.ide.ui.editor.IValueOfContributor;
import org.eclipse.fx.ide.ui.editor.ValueOfContributionCollector;
import org.eclipse.fx.ide.ui.util.IconKeys;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractXMLCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.xtext.common.types.xtext.ui.IntersectingJavaSearchScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.FQNPrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FXMLCompletionProposalComputer
extends AbstractXMLCompletionProposalComputer
implements ICompletionProposalComputer {
    private static final PrefixMatcher.CamelCase MATCHER = new PrefixMatcher.CamelCase();
    private static final PrefixMatcher ATTRIBUTE_MATCHER = new PrefixMatcher.CamelCase(){

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            return super.isCandidateMatchingPrefix(name.startsWith("\"") ? name.substring(1) : name, prefix.startsWith("\"") ? prefix.substring(1) : prefix);
        }
    };
    private static final PrefixMatcher STATIC_ELEMENT_MATCHER = new PrefixMatcher.CamelCase(){

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            String n = name;
            n = n.substring(n.indexOf(46) + 1, n.indexOf(62)).trim();
            return super.isCandidateMatchingPrefix(n, prefix);
        }
    };
    private static final PrefixMatcher STATIC_ATTRIBUTE_MATCHER = new PrefixMatcher.CamelCase(){

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            String n = name.substring(name.indexOf(46) + 1);
            String p = prefix.startsWith("\"") ? prefix.substring(1) : prefix;
            return super.isCandidateMatchingPrefix(n, p);
        }
    };
    static final PrefixMatcher CLASS_ATTRIBUTE_MATCHER = new PrefixMatcher(){

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            String n = name.startsWith("\"") ? name.substring(1) : name;
            String p = prefix.startsWith("\"") ? prefix.substring(1) : prefix;
            return FQN_MATCHER.isCandidateMatchingPrefix(n, p);
        }
    };
    private static final PrefixMatcher EVENT_ATTRIBUTE_MATCHER = new PrefixMatcher.CamelCase(){

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            return super.isCandidateMatchingPrefix(this.normalize(name), this.normalize(prefix));
        }

        private String normalize(String value) {
            String v = value.startsWith("\"") ? value.substring(1) : value;
            v = v.startsWith("#") ? v.substring(1) : v;
            return v;
        }
    };
    static final FQNPrefixMatcher FQN_MATCHER = new FQNPrefixMatcher();
    private static final int DEFAULT_PRIORITY = 200;
    private static final int PRIORITY_LOWER_1 = 100;
    private ValueOfContributionCollector valueOfCollector;

    public FXMLCompletionProposalComputer() {
        FQN_MATCHER.setLastSegmentFinder((FQNPrefixMatcher.LastSegmentFinder)new FQNPrefixMatcher.DefaultLastSegmentFinder());
        FQN_MATCHER.setDelegate((PrefixMatcher.IgnoreCase)MATCHER);
        ServiceReference ref = Activator.getContext().getServiceReference(ValueOfContributionCollector.class);
        this.valueOfCollector = (ValueOfContributionCollector)Activator.getContext().getService(ref);
    }

    public void sessionStarted() {
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        String typeName = null;
        Node parent = contentAssistRequest.getParent();
        HashSet<String> existingAttributes = new HashSet<String>();
        if (parent.getNodeType() == 1) {
            typeName = parent.getNodeName();
            Element e = (Element)parent;
            int i = 0;
            while (i < e.getAttributes().getLength()) {
                existingAttributes.add(e.getAttributes().item(i).getNodeName());
                ++i;
            }
        }
        if ("fx:root".equals(typeName)) {
            typeName = parent.getAttributes().getNamedItem("type").getNodeValue();
        }
        if (typeName != null) {
            if (Character.isLowerCase(typeName.charAt(0)) || typeName.contains(".")) {
                return;
            }
            IType type = FXMLCompletionProposalComputer.findType(typeName, contentAssistRequest, context);
            if (type != null) {
                FXMLCompletionProposal cp;
                IFXClass fxClass = FXPlugin.getClassmodel().findClass(type.getJavaProject(), type);
                if (fxClass.getValueOf() != null && (cp = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, "fx:value=\"\"", new StyledString("fx:valueOf").append(" - " + fxClass.getSimpleName(), StyledString.QUALIFIER_STYLER), IconKeys.getIcon((String)IconKeys.FIELD_KEY), 210, (PrefixMatcher)MATCHER)) != null) {
                    cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
                    cp.setHover(new HoverImpl((IJavaElement)fxClass.getValueOf()));
                    contentAssistRequest.addProposal((ICompletionProposal)cp);
                }
                for (IFXProperty property : fxClass.getAllProperties().values()) {
                    if (existingAttributes.contains(property.getName())) continue;
                    FXMLCompletionProposalComputer.createAttributeNameProposal(contentAssistRequest, context, property);
                }
                if (parent.getParentNode() != null) {
                    Node n = null;
                    if (Character.isUpperCase(parent.getParentNode().getNodeName().charAt(0)) || "fx:root".equals(parent.getParentNode().getNodeName())) {
                        n = parent.getParentNode();
                    } else if (parent.getParentNode().getParentNode() != null && (Character.isUpperCase(parent.getParentNode().getParentNode().getNodeName().charAt(0)) || "fx:root".equals(parent.getParentNode().getParentNode().getNodeName()))) {
                        n = parent.getParentNode().getParentNode();
                    }
                    if (n != null) {
                        IFXClass fxclass;
                        IType containerType = "fx:root".equals(n.getNodeName()) ? Util.findType(n.getAttributes().getNamedItem("type").getNodeValue(), parent.getOwnerDocument()) : Util.findType(n.getNodeName(), parent.getOwnerDocument());
                        if (containerType != null && (fxclass = FXPlugin.getClassmodel().findClass(type.getJavaProject(), containerType)) != null) {
                            for (IFXProperty property : fxclass.getAllStaticProperties().values()) {
                                if (existingAttributes.contains(String.valueOf(property.getFXClass().getSimpleName()) + "." + property.getName())) continue;
                                FXMLCompletionProposalComputer.createAttributeNameProposal(contentAssistRequest, context, property);
                            }
                        }
                    } else {
                        FXMLCompletionProposal cp2 = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, "fx:controller=\"\"", new StyledString("fx:controller").append(" - FXML built-in", StyledString.QUALIFIER_STYLER), IconKeys.getIcon((String)IconKeys.CLASS_KEY), 210, (PrefixMatcher)MATCHER);
                        if (cp2 != null) {
                            contentAssistRequest.addProposal((ICompletionProposal)cp2);
                        }
                    }
                }
            }
        }
    }

    private static void createAttributeNameProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXProperty fxProperty) {
        if (fxProperty.isSetable()) {
            if (fxProperty instanceof IFXPrimitiveProperty) {
                FXMLCompletionProposalComputer.createPrimitivePropnameProposal(contentAssistRequest, context, (IFXPrimitiveProperty)fxProperty);
            } else if (fxProperty instanceof IFXEnumProperty) {
                FXMLCompletionProposalComputer.createEnumPropnameProposals(contentAssistRequest, context, (IFXEnumProperty)fxProperty);
            } else if (fxProperty instanceof IFXEventHandlerProperty) {
                FXMLCompletionProposalComputer.createEventHandlerPropnameProposals(contentAssistRequest, context, (IFXEventHandlerProperty)fxProperty);
            } else if (fxProperty instanceof IFXObjectProperty) {
                FXMLCompletionProposalComputer.createObjectPropnameProposals(contentAssistRequest, context, (IFXObjectProperty)fxProperty);
            }
        }
    }

    private static void createEnumPropnameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXEnumProperty prop) {
        FXMLCompletionProposal cp;
        if (prop.isStatic()) {
            StyledString s = new StyledString();
            s.append("(static) ", StyledString.COUNTER_STYLER);
            s.append(String.valueOf(prop.getFXClass().getSimpleName()) + "." + prop.getName() + " : " + prop.getEnumTypeAsString(false));
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            String proposalValue = String.valueOf(prop.getFXClass().getSimpleName()) + "." + prop.getName() + "=\"\"";
            cp = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, proposalValue, s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), 190, STATIC_ATTRIBUTE_MATCHER);
        } else {
            StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getEnumTypeAsString(false));
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            String propValue = String.valueOf(prop.getName()) + "=\"\"";
            cp = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, propValue, s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), 200, (PrefixMatcher)MATCHER);
        }
        if (cp != null) {
            cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
            cp.setHover(new HoverImpl(prop.getJavaElement()));
            contentAssistRequest.addProposal((ICompletionProposal)cp);
        }
    }

    private static void createEventHandlerPropnameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXEventHandlerProperty prop) {
        if (!prop.isStatic()) {
            StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getEventTypeAsString(false));
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            String propValue = String.valueOf(prop.getName()) + "=\"#\"";
            FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, propValue, s, IconKeys.getIcon((String)IconKeys.EVENT_KEY), 200, (PrefixMatcher)MATCHER);
            if (cp != null) {
                cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
                cp.setHover(new HoverImpl(prop.getJavaElement()));
                contentAssistRequest.addProposal((ICompletionProposal)cp);
            }
        }
    }

    private static void createObjectPropnameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXObjectProperty prop) {
        String type = prop.getElementTypeAsString(true);
        if ("java.lang.Boolean".equals(type) || FXMLCompletionProposalComputer.isIntegerType(type) || FXMLCompletionProposalComputer.isDoubleType(type) || prop.hasValueOf()) {
            FXMLCompletionProposal cp;
            if (prop.isStatic()) {
                StyledString s = new StyledString();
                s.append("(static) ", StyledString.COUNTER_STYLER);
                s.append(String.valueOf(prop.getFXClass().getSimpleName()) + "." + prop.getName() + " : " + prop.getElementTypeAsString(false));
                s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
                String proposalValue = String.valueOf(prop.getFXClass().getSimpleName()) + "." + prop.getName() + "=\"\"";
                cp = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, proposalValue, s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), 190, STATIC_ATTRIBUTE_MATCHER);
            } else {
                StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getElementTypeAsString(false));
                s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
                String propValue = String.valueOf(prop.getName()) + "=\"\"";
                cp = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, propValue, s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), 200, (PrefixMatcher)MATCHER);
            }
            if (cp != null) {
                cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
                cp.setHover(new HoverImpl(prop.getJavaElement()));
                contentAssistRequest.addProposal((ICompletionProposal)cp);
            }
        }
    }

    private static void createPrimitivePropnameProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXPrimitiveProperty fxProperty) {
        FXMLCompletionProposal cp;
        String typeName;
        switch (fxProperty.getType()) {
            case BOOLEAN: {
                typeName = "boolean";
                break;
            }
            case BYTE: {
                typeName = "byte";
                break;
            }
            case CHAR: {
                typeName = "char";
                break;
            }
            case DOUBLE: {
                typeName = "double";
                break;
            }
            case FLOAT: {
                typeName = "float";
                break;
            }
            case INTEGER: {
                typeName = "integer";
                break;
            }
            case LONG: {
                typeName = "long";
                break;
            }
            case SHORT: {
                typeName = "short";
                break;
            }
            default: {
                typeName = "String";
            }
        }
        if (fxProperty.isStatic()) {
            StyledString s = new StyledString();
            s.append("(static) ", StyledString.COUNTER_STYLER);
            s.append(String.valueOf(fxProperty.getFXClass().getSimpleName()) + "." + fxProperty.getName() + " : " + typeName);
            s.append(" - " + fxProperty.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            String proposalValue = String.valueOf(fxProperty.getFXClass().getSimpleName()) + "." + fxProperty.getName() + "=\"\"";
            cp = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, proposalValue, s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), 190, STATIC_ATTRIBUTE_MATCHER);
        } else {
            StyledString s = new StyledString(String.valueOf(fxProperty.getName()) + " : " + typeName);
            s.append(" - " + fxProperty.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            String proposalValue = String.valueOf(fxProperty.getName()) + "=\"\"";
            cp = FXMLCompletionProposalComputer.createAttributeProposal(contentAssistRequest, context, proposalValue, s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), 200, (PrefixMatcher)MATCHER);
        }
        if (cp != null) {
            cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
            cp.setHover(new HoverImpl(fxProperty.getJavaElement()));
            contentAssistRequest.addProposal((ICompletionProposal)cp);
        }
    }

    private static FXMLCompletionProposal createAttributeProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, String proposalValue, StyledString s, Image image, int priority, PrefixMatcher matcher) {
        if (matcher.isCandidateMatchingPrefix(proposalValue, contentAssistRequest.getMatchString())) {
            FXMLCompletionProposal cp = new FXMLCompletionProposal(proposalValue, context.getInvocationOffset() - contentAssistRequest.getMatchString().length(), proposalValue.length(), proposalValue.length() - 1, image, s, null);
            cp.setMatcher(matcher);
            cp.setPriority(priority);
            return cp;
        }
        return null;
    }

    static FXMLCompletionProposal createProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, String proposalValue, StyledString s, Image img, PrefixMatcher matcher) {
        if (matcher.isCandidateMatchingPrefix(proposalValue, contentAssistRequest.getMatchString())) {
            FXMLCompletionProposal cp = new FXMLCompletionProposal(proposalValue, context.getInvocationOffset() - contentAssistRequest.getMatchString().length(), proposalValue.length(), proposalValue.length(), img, s, null);
            cp.setMatcher(matcher);
            return cp;
        }
        return null;
    }

    static FXMLCompletionProposal createElementProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, String proposalValue, StyledString s, boolean withEnd, int priority, Image img, PrefixMatcher m) {
        if (m.isCandidateMatchingPrefix(proposalValue, contentAssistRequest.getMatchString())) {
            FXMLCompletionProposal cp = new FXMLCompletionProposal(proposalValue, context.getInvocationOffset() - contentAssistRequest.getMatchString().length(), proposalValue.length(), withEnd ? proposalValue.length() / 2 - 1 : proposalValue.length(), img, s, null);
            cp.setPriority(priority);
            cp.setMatcher(m);
            return cp;
        }
        return null;
    }

    protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        Node parent = contentAssistRequest.getParent();
        if (parent.getNodeType() == 1) {
            if (parent.getNodeName().contains(".")) {
                IFXProperty p;
                IFXClass fxClass;
                String[] parts = parent.getNodeName().split("\\.");
                IType ownerType = Util.findType(parts[0], parent.getOwnerDocument());
                if (ownerType != null && (fxClass = FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType)) != null && (p = fxClass.getStaticProperty(parts[1])) != null) {
                    if (p instanceof IFXObjectProperty) {
                        IFXObjectProperty op = (IFXObjectProperty)p;
                        FXMLCompletionProposalComputer.createSubtypeProposals(contentAssistRequest, context, op.getElementType());
                    } else if (p instanceof IFXCollectionProperty) {
                        IFXCollectionProperty cp = (IFXCollectionProperty)p;
                        FXMLCompletionProposalComputer.createSubtypeProposals(contentAssistRequest, context, cp.getElementType());
                    }
                }
            } else if (Character.isUpperCase(parent.getNodeName().charAt(0)) || "fx:root".equals(parent.getNodeName())) {
                IFXClass fxClass;
                IType type;
                if (contentAssistRequest.getMatchString().isEmpty() || !Character.isUpperCase(contentAssistRequest.getMatchString().charAt(0))) {
                    if (parent.getParentNode() != null) {
                        IFXClass fxclass;
                        IType type2;
                        Node n = null;
                        if ("fx:root".equals(parent.getNodeName())) {
                            n = parent;
                        } else if (Character.isUpperCase(parent.getParentNode().getNodeName().charAt(0)) || "fx:root".equals(parent.getParentNode().getNodeName())) {
                            n = parent.getParentNode();
                        } else if (parent.getParentNode().getParentNode() != null && (Character.isUpperCase(parent.getParentNode().getParentNode().getNodeName().charAt(0)) || "fx:root".equals(parent.getParentNode().getParentNode().getNodeName()))) {
                            n = parent.getParentNode().getParentNode();
                        }
                        if (n != null && (type2 = "fx:root".equals(n.getNodeName()) ? Util.findType(n.getAttributes().getNamedItem("type").getNodeValue(), parent.getOwnerDocument()) : Util.findType(n.getNodeName(), parent.getOwnerDocument())) != null && (fxclass = FXPlugin.getClassmodel().findClass(type2.getJavaProject(), type2)) != null) {
                            for (IFXProperty p : fxclass.getAllStaticProperties().values()) {
                                String sType;
                                String proposalValue = String.valueOf(fxclass.getSimpleName()) + "." + p.getName() + ">" + "</" + fxclass.getSimpleName() + "." + p.getName() + ">";
                                if (p instanceof IFXPrimitiveProperty) {
                                    IFXPrimitiveProperty pp = (IFXPrimitiveProperty)p;
                                    sType = pp.getType() == IFXPrimitiveProperty.Type.STRING ? "String" : pp.getType().jvmType();
                                } else if (p instanceof IFXObjectProperty) {
                                    IFXObjectProperty op = (IFXObjectProperty)p;
                                    sType = op.getElementTypeAsString(false);
                                } else if (p instanceof IFXEnumProperty) {
                                    IFXEnumProperty ep = (IFXEnumProperty)p;
                                    sType = ep.getEnumTypeAsString(false);
                                } else {
                                    sType = "<unknown>";
                                }
                                FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createElementProposal(contentAssistRequest, context, proposalValue, new StyledString().append("(static) ", StyledString.COUNTER_STYLER).append(String.valueOf(p.getFXClass().getSimpleName()) + "." + p.getName()).append(" - " + sType, StyledString.QUALIFIER_STYLER), true, 100, null, STATIC_ELEMENT_MATCHER);
                                if (cp == null) continue;
                                cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
                                cp.setHover(new HoverImpl(p.getJavaElement()));
                                contentAssistRequest.addProposal((ICompletionProposal)cp);
                            }
                        }
                    }
                    if ((type = "fx:root".equals(parent.getNodeName()) ? Util.findType(parent.getAttributes().getNamedItem("type").getNodeValue(), parent.getOwnerDocument()) : Util.findType(parent.getNodeName(), parent.getOwnerDocument())) != null && (fxClass = FXPlugin.getClassmodel().findClass(type.getJavaProject(), type)) != null) {
                        for (IFXProperty property : fxClass.getAllProperties().values()) {
                            FXMLCompletionProposalComputer.createPropertyElementNameProposal(contentAssistRequest, context, property);
                        }
                    }
                }
                if ((type = "fx:root".equals(parent.getNodeName()) ? Util.findType(parent.getAttributes().getNamedItem("type").getNodeValue(), parent.getOwnerDocument()) : Util.findType(parent.getNodeName(), parent.getOwnerDocument())) != null && (fxClass = FXPlugin.getClassmodel().findClass(type.getJavaProject(), type)) != null) {
                    IFXProperty p = fxClass.getDefaultProperty();
                    if (p instanceof IFXObjectProperty) {
                        FXMLCompletionProposalComputer.createSubtypeProposals(contentAssistRequest, context, ((IFXObjectProperty)p).getElementType());
                    } else if (p instanceof IFXCollectionProperty) {
                        FXMLCompletionProposalComputer.createSubtypeProposals(contentAssistRequest, context, ((IFXCollectionProperty)p).getElementType());
                    }
                }
            } else {
                FXMLCompletionProposalComputer.createClassElementNameProposal(contentAssistRequest, context);
            }
        }
    }

    private static void createClassElementNameProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        IFXClass fxClass;
        Node propertyType = contentAssistRequest.getParent();
        Node elementType = propertyType.getParentNode();
        IType type = "fx:root".equals(elementType.getNodeName()) ? Util.findType(elementType.getAttributes().getNamedItem("type").getNodeValue(), elementType.getOwnerDocument()) : FXMLCompletionProposalComputer.findType(elementType.getNodeName(), contentAssistRequest, context);
        if (type != null && (fxClass = FXPlugin.getClassmodel().findClass(type.getJavaProject(), type)) != null) {
            IFXProperty p = fxClass.getProperty(propertyType.getNodeName());
            if (p instanceof IFXObjectProperty) {
                IFXObjectProperty op = (IFXObjectProperty)p;
                FXMLCompletionProposalComputer.createSubtypeProposals(contentAssistRequest, context, op.getElementType());
            } else if (p instanceof IFXCollectionProperty) {
                IFXCollectionProperty cp = (IFXCollectionProperty)p;
                FXMLCompletionProposalComputer.createSubtypeProposals(contentAssistRequest, context, cp.getElementType());
            }
        }
    }

    private static void createPropertyElementNameProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXProperty fxProperty) {
        if (fxProperty instanceof IFXCollectionProperty) {
            FXMLCompletionProposalComputer.createListPropertyElementProposal(contentAssistRequest, context, (IFXCollectionProperty)fxProperty);
        } else if (fxProperty instanceof IFXObjectProperty) {
            FXMLCompletionProposalComputer.createObjectPropertyElementProposal(contentAssistRequest, context, (IFXObjectProperty)fxProperty);
        }
    }

    private static void createListPropertyElementProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXCollectionProperty prop) {
        StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getCollectionAsString());
        s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
        String propValue = String.valueOf(prop.getName()) + "></" + prop.getName() + ">";
        FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createElementProposal(contentAssistRequest, context, propValue, s, true, 200, IconKeys.getIcon((String)IconKeys.FIELD_KEY), (PrefixMatcher)MATCHER);
        if (cp != null) {
            cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
            cp.setHover(new HoverImpl(prop.getJavaElement()));
            contentAssistRequest.addProposal((ICompletionProposal)cp);
        }
    }

    private static void createObjectPropertyElementProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXObjectProperty prop) {
        StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getElementTypeAsString(false));
        s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
        String propValue = String.valueOf(prop.getName()) + "></" + prop.getName() + ">";
        FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createElementProposal(contentAssistRequest, context, propValue, s, true, 200, IconKeys.getIcon((String)IconKeys.FIELD_KEY), (PrefixMatcher)MATCHER);
        if (cp != null) {
            cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
            cp.setHover(new HoverImpl(prop.getJavaElement()));
            contentAssistRequest.addProposal((ICompletionProposal)cp);
        }
    }

    private static void createSubtypeProposals(final ContentAssistRequest contentAssistRequest, final CompletionProposalInvocationContext context, IType superType) {
        IJavaProject jproject = FXMLCompletionProposalComputer.findProject(contentAssistRequest);
        try {
            IJavaSearchScope hierarchyScope = SearchEngine.createHierarchyScope((IType)superType);
            IJavaSearchScope projectScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jproject});
            IntersectingJavaSearchScope scope = new IntersectingJavaSearchScope(new IJavaSearchScope[]{projectScope, hierarchyScope});
            SearchEngine searchEngine = new SearchEngine();
            char[] typeName = null;
            char[] packageName = null;
            if (!contentAssistRequest.getMatchString().isEmpty()) {
                typeName = contentAssistRequest.getMatchString().toCharArray();
            }
            searchEngine.searchAllTypeNames(packageName, 2, typeName, 129, 5, (IJavaSearchScope)scope, new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    String sPackageName = new String(packageName);
                    int priority = 100;
                    if (sPackageName.startsWith("com.sun.javafx")) {
                        priority -= 10;
                    }
                    StyledString s = new StyledString(new String(simpleTypeName));
                    s.append(" - " + sPackageName, StyledString.QUALIFIER_STYLER);
                    FXMLCompletionProposal prop = FXMLCompletionProposalComputer.createElementProposal(contentAssistRequest, context, String.valueOf(sPackageName) + "." + new String(simpleTypeName) + " ", s, false, priority, IconKeys.getIcon((String)IconKeys.CLASS_KEY), (PrefixMatcher)FQN_MATCHER);
                    if (prop != null) {
                        prop.setMatcher((PrefixMatcher)FQN_MATCHER);
                        prop.setTextApplier(new ConfigurableCompletionProposal.IReplacementTextApplier(){

                            public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
                                String proposalReplacementString = proposal.getReplacementString();
                                List<String> s = FXMLCompletionProposalComputer.getImportedTypes(contentAssistRequest);
                                String shortened = proposalReplacementString.substring(proposalReplacementString.lastIndexOf(46) + 1);
                                if (s.contains(proposalReplacementString.trim())) {
                                    proposal.setCursorPosition(shortened.length());
                                    document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), shortened);
                                } else {
                                    DocumentRewriteSession rewriteSession = null;
                                    try {
                                        if (document instanceof IDocumentExtension4) {
                                            rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                                        }
                                    }
                                    finally {
                                        if (rewriteSession != null) {
                                            ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
                                        }
                                    }
                                    boolean startWithLineBreak = true;
                                    boolean endWithLineBreak = false;
                                    Document xmlDoc = contentAssistRequest.getNode().getOwnerDocument();
                                    NodeList list = xmlDoc.getChildNodes();
                                    int offset = 0;
                                    ArrayList<Node> prs = new ArrayList<Node>();
                                    int i = 0;
                                    while (i < list.getLength()) {
                                        Node n = list.item(i);
                                        if (n.getNodeType() == 7) {
                                            prs.add(n);
                                        }
                                        ++i;
                                    }
                                    if (!prs.isEmpty()) {
                                        offset = ((IDOMNode)prs.get(prs.size() - 1)).getEndOffset();
                                    }
                                    offset = Math.min(proposal.getReplacementOffset(), offset);
                                    proposal.setCursorPosition(shortened.length());
                                    document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), shortened);
                                    String importStatement = String.valueOf(startWithLineBreak ? "\n<?import " : "import ") + proposalReplacementString.trim();
                                    importStatement = String.valueOf(importStatement) + "?>";
                                    if (endWithLineBreak) {
                                        importStatement = String.valueOf(importStatement) + "\n\n";
                                    }
                                    document.replace(offset, 0, importStatement.toString());
                                    proposal.setCursorPosition(proposal.getCursorPosition() + importStatement.length());
                                }
                            }
                        });
                        contentAssistRequest.addProposal((ICompletionProposal)prop);
                    }
                }
            }, 3, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected void addStartDocumentProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        FXMLCompletionProposal proposal = new FXMLCompletionProposal("<?scenebuilder-stylesheet ?>", context.getInvocationOffset() - contentAssistRequest.getMatchString().length(), "<?scenebuilder-stylesheet ?>".length(), "<?scenebuilder-stylesheet ?>".length() - 2);
        proposal.setMatcher((PrefixMatcher)MATCHER);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
        proposal = new FXMLCompletionProposal("<?scenebuilder-preview-i18n-resource ?>", context.getInvocationOffset() - contentAssistRequest.getMatchString().length(), "<?scenebuilder-preview-i18n-resource ?>".length(), "<?scenebuilder-preview-i18n-resource ?>".length() - 2);
        proposal.setMatcher((PrefixMatcher)MATCHER);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
        IJavaProject jproject = FXMLCompletionProposalComputer.findProject(contentAssistRequest);
        try {
            IType superType = jproject.findType("javafx.scene.Parent");
            if (superType != null) {
                FXMLCompletionProposalComputer.createSubtypeProposals(contentAssistRequest, context, superType);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected void addAttributeValueProposals(final ContentAssistRequest contentAssistRequest, final CompletionProposalInvocationContext context) {
        IDOMNode n = (IDOMNode)contentAssistRequest.getNode();
        if (Character.isUpperCase(n.getNodeName().charAt(0))) {
            NamedNodeMap m = n.getAttributes();
            IDOMNode attribute = null;
            int i = 0;
            while (i < m.getLength()) {
                IDOMNode a = (IDOMNode)m.item(i);
                if (a.contains(contentAssistRequest.getStartOffset())) {
                    attribute = a;
                }
                ++i;
            }
            if (attribute != null) {
                if ("http://javafx.com/fxml".equals(attribute.getNamespaceURI())) {
                    IType fromType;
                    IFXCtrlClass ctrlClass;
                    IType t;
                    Document d;
                    Element e;
                    Attr a;
                    if ("constant".equals(attribute.getLocalName())) {
                        IType type = FXMLCompletionProposalComputer.findType(n.getNodeName(), contentAssistRequest, context);
                        if (type != null) {
                            try {
                                ArrayList<IField> fields = new ArrayList<IField>();
                                this.collectStaticFields(fields, type);
                                for (IField f : fields) {
                                    StyledString s = new StyledString(String.valueOf(f.getElementName()) + " : " + Signature.getSimpleName((String)Signature.toString((String)f.getTypeSignature())));
                                    String owner = ((IType)f.getAncestor(7)).getElementName();
                                    s.append(" - " + Signature.getSimpleName((String)owner), StyledString.QUALIFIER_STYLER);
                                    FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createProposal(contentAssistRequest, context, "\"" + f.getElementName(), s, IconKeys.getIcon((String)IconKeys.CLASS_KEY), CLASS_ATTRIBUTE_MATCHER);
                                    if (cp == null) continue;
                                    contentAssistRequest.addProposal((ICompletionProposal)cp);
                                }
                            }
                            catch (JavaModelException e2) {
                                e2.printStackTrace();
                            }
                        }
                    } else if ("controller".equals(attribute.getLocalName())) {
                        IJavaProject jproject = FXMLCompletionProposalComputer.findProject(contentAssistRequest);
                        char[] typeName = null;
                        char[] packageName = null;
                        if (!contentAssistRequest.getMatchString().isEmpty()) {
                            typeName = contentAssistRequest.getMatchString().startsWith("\"") ? contentAssistRequest.getMatchString().substring(1).toCharArray() : contentAssistRequest.getMatchString().toCharArray();
                        }
                        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jproject});
                        SearchEngine searchEngine = new SearchEngine();
                        try {
                            searchEngine.searchAllTypeNames(packageName, 2, typeName, 129, 0, searchScope, new TypeNameRequestor(){

                                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                                    String sPackageName = new String(packageName);
                                    StyledString s = new StyledString(new String(simpleTypeName));
                                    s.append(" - " + sPackageName, StyledString.QUALIFIER_STYLER);
                                    FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createProposal(contentAssistRequest, context, "\"" + sPackageName + "." + new String(simpleTypeName), s, IconKeys.getIcon((String)IconKeys.CLASS_KEY), CLASS_ATTRIBUTE_MATCHER);
                                    if (cp != null) {
                                        contentAssistRequest.addProposal((ICompletionProposal)cp);
                                    }
                                }
                            }, 3, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (JavaModelException e3) {
                            e3.printStackTrace();
                        }
                    } else if ("id".equals(attribute.getLocalName()) && (a = (e = (d = contentAssistRequest.getNode().getOwnerDocument()).getDocumentElement()).getAttributeNodeNS("http://javafx.com/fxml", "controller")) != null && (t = Util.findType(a.getValue(), d)) != null && (ctrlClass = FXPlugin.getClassmodel().findCtrlClass(t.getJavaProject(), t)) != null && (fromType = FXMLCompletionProposalComputer.findType(n.getNodeName(), contentAssistRequest, context)) != null) {
                        for (Map.Entry ef : ctrlClass.getAllFields().entrySet()) {
                            Image img;
                            IFXCtrlField f = (IFXCtrlField)ef.getValue();
                            if (!org.eclipse.fx.ide.model.Util.assignable((IType)fromType, (IType)f.getType())) continue;
                            StyledString s = new StyledString(f.getName());
                            s.append(" - " + ctrlClass.getSimpleName(), StyledString.QUALIFIER_STYLER);
                            switch (f.getVisibility()) {
                                case PUBLIC: {
                                    img = IconKeys.getIcon((String)IconKeys.METHOD_PUBLIC_KEY);
                                    break;
                                }
                                case PACKAGE: {
                                    img = IconKeys.getIcon((String)IconKeys.METHOD_DEFAULT_KEY);
                                    break;
                                }
                                case PROTECTED: {
                                    img = IconKeys.getIcon((String)IconKeys.METHOD_PROTECTED_KEY);
                                    break;
                                }
                                default: {
                                    img = IconKeys.getIcon((String)IconKeys.METHOD_PRIVATE_KEY);
                                }
                            }
                            FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createProposal(contentAssistRequest, context, "\"" + f.getName(), s, img, CLASS_ATTRIBUTE_MATCHER);
                            if (cp == null) continue;
                            contentAssistRequest.addProposal((ICompletionProposal)cp);
                        }
                    }
                } else if (attribute.getNodeName().contains(".")) {
                    IFXClass fxClass;
                    String[] parts = attribute.getNodeName().split("\\.");
                    IType type = FXMLCompletionProposalComputer.findType(parts[0], contentAssistRequest, context);
                    if (type != null && (fxClass = FXPlugin.getClassmodel().findClass(type.getJavaProject(), type)) != null) {
                        IFXProperty p = fxClass.getStaticProperty(parts[1]);
                        if (p instanceof IFXPrimitiveProperty) {
                            FXMLCompletionProposalComputer.createAttributeValuePrimitiveProposals(contentAssistRequest, context, (IFXPrimitiveProperty)p);
                        } else if (p instanceof IFXEnumProperty) {
                            FXMLCompletionProposalComputer.createAttributeValueEnumProposals(contentAssistRequest, context, (IFXEnumProperty)p);
                        } else if (p instanceof IFXObjectProperty) {
                            this.createAttributeValueObjectProposals(contentAssistRequest, context, (IFXObjectProperty)p);
                        }
                    }
                } else {
                    IFXClass fxClass;
                    IType type = FXMLCompletionProposalComputer.findType(n.getNodeName(), contentAssistRequest, context);
                    if (type != null && (fxClass = FXPlugin.getClassmodel().findClass(type.getJavaProject(), type)) != null) {
                        IFXProperty p = fxClass.getProperty(attribute.getNodeName());
                        if (p instanceof IFXPrimitiveProperty) {
                            FXMLCompletionProposalComputer.createAttributeValuePrimitiveProposals(contentAssistRequest, context, (IFXPrimitiveProperty)p);
                        } else if (p instanceof IFXEnumProperty) {
                            FXMLCompletionProposalComputer.createAttributeValueEnumProposals(contentAssistRequest, context, (IFXEnumProperty)p);
                        } else if (p instanceof IFXObjectProperty) {
                            this.createAttributeValueObjectProposals(contentAssistRequest, context, (IFXObjectProperty)p);
                        } else if (p instanceof IFXEventHandlerProperty) {
                            FXMLCompletionProposalComputer.createAttributeValueEventHandlerProposals(contentAssistRequest, context, (IFXEventHandlerProperty)p);
                        }
                    }
                }
            }
        }
    }

    private void collectStaticFields(List<IField> fields, IType type) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField f = iFieldArray[n2];
            if (Flags.isStatic((int)f.getFlags())) {
                fields.add(f);
            }
            ++n2;
        }
        String s = type.getSuperclassName();
        if (s != null) {
            String fqn = org.eclipse.fx.ide.model.internal.utils.Util.getFQNType((IType)type, (String)Signature.getTypeErasure((String)s));
            this.collectStaticFields(fields, type.getJavaProject().findType(fqn));
        }
    }

    private static void createAttributeValueEventHandlerProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXEventHandlerProperty p) {
        IFXCtrlClass ctrlClass;
        IType t;
        Document d = contentAssistRequest.getNode().getOwnerDocument();
        Element e = d.getDocumentElement();
        Attr a = e.getAttributeNodeNS("http://javafx.com/fxml", "controller");
        if (a != null && (t = Util.findType(a.getValue(), d)) != null && (ctrlClass = FXPlugin.getClassmodel().findCtrlClass(t.getJavaProject(), t)) != null) {
            for (IFXCtrlEventMethod ctrlMethod : ctrlClass.getAllEventMethods().values()) {
                StyledString s = null;
                if (!ctrlMethod.hasArgument()) {
                    s = new StyledString(String.valueOf(ctrlMethod.getName()) + "()");
                } else if (org.eclipse.fx.ide.model.Util.assignable((IType)p.getEventType(), (IType)ctrlMethod.getArgumentType())) {
                    s = new StyledString(String.valueOf(ctrlMethod.getName()) + "(" + p.getEventTypeAsString(false) + ")");
                }
                if (s == null) continue;
                s.append(" - " + ctrlClass.getSimpleName(), StyledString.QUALIFIER_STYLER);
                Image img = null;
                switch (ctrlMethod.getVisibility()) {
                    case PUBLIC: {
                        img = IconKeys.getIcon((String)IconKeys.METHOD_PUBLIC_KEY);
                        break;
                    }
                    case PACKAGE: {
                        img = IconKeys.getIcon((String)IconKeys.METHOD_DEFAULT_KEY);
                        break;
                    }
                    case PROTECTED: {
                        img = IconKeys.getIcon((String)IconKeys.METHOD_PROTECTED_KEY);
                        break;
                    }
                    default: {
                        img = IconKeys.getIcon((String)IconKeys.METHOD_PRIVATE_KEY);
                    }
                }
                FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createProposal(contentAssistRequest, context, "\"#" + ctrlMethod.getName(), s, img, EVENT_ATTRIBUTE_MATCHER);
                if (cp == null) continue;
                contentAssistRequest.addProposal((ICompletionProposal)cp);
            }
        }
    }

    private static void createAttributeValuePrimitiveProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXPrimitiveProperty p) {
        switch (p.getType()) {
            case BOOLEAN: {
                FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createProposal(contentAssistRequest, context, "\"true", new StyledString("true"), null, ATTRIBUTE_MATCHER);
                if (cp != null) {
                    cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
                    cp.setHover(new HoverImpl(p.getJavaElement()));
                    contentAssistRequest.addProposal((ICompletionProposal)cp);
                }
                if ((cp = FXMLCompletionProposalComputer.createProposal(contentAssistRequest, context, "\"false", new StyledString("false"), null, ATTRIBUTE_MATCHER)) == null) break;
                cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
                cp.setHover(new HoverImpl(p.getJavaElement()));
                contentAssistRequest.addProposal((ICompletionProposal)cp);
                break;
            }
        }
    }

    private static void createAttributeValueEnumProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXEnumProperty p) {
        IType t = p.getEnumType();
        if (t != null) {
            try {
                IField[] iFieldArray = t.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FXMLCompletionProposal cp;
                    IField f = iFieldArray[n2];
                    if (Flags.isEnum((int)f.getFlags()) && (cp = FXMLCompletionProposalComputer.createProposal(contentAssistRequest, context, "\"" + f.getElementName(), new StyledString(f.getElementName()).append(" - " + p.getEnumTypeAsString(false), StyledString.QUALIFIER_STYLER), IconKeys.getIcon((String)IconKeys.ENUM_KEY), ATTRIBUTE_MATCHER)) != null) {
                        cp.setAdditionalProposalInfo(EcoreFactory.eINSTANCE.createEClass());
                        cp.setHover(new HoverImpl((IJavaElement)f));
                        contentAssistRequest.addProposal((ICompletionProposal)cp);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private void createAttributeValueObjectProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, IFXObjectProperty p) {
        if (p.hasValueOf()) {
            for (IValueOfContributor c : this.valueOfCollector.getContributors(p.getElementTypeAsString(true))) {
                for (IValueOfContributor.Proposal vProp : c.getProposals()) {
                    FXMLCompletionProposal cp = FXMLCompletionProposalComputer.createProposal(contentAssistRequest, context, "\"" + vProp.getValue(), new StyledString(vProp.getValue()), IconKeys.getIcon((String)IconKeys.VALUE_OF_KEY), ATTRIBUTE_MATCHER);
                    if (cp == null) continue;
                    cp.setPriority(cp.getPriority() + vProp.getPriority() + 1);
                    if (vProp instanceof IValueOfContributor.DialogProposal) {
                        final IValueOfContributor.DialogProposal dProp = (IValueOfContributor.DialogProposal)vProp;
                        cp.setTextApplier((ConfigurableCompletionProposal.IReplacementTextApplier)new ReplacementTextApplier(){

                            public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
                                return "\"" + dProp.openDialogValue();
                            }
                        });
                    }
                    contentAssistRequest.addProposal((ICompletionProposal)cp);
                }
            }
        }
    }

    private static boolean isIntegerType(String fqnType) {
        if ("java.lang.Integer".equals(fqnType)) {
            return true;
        }
        if ("java.lang.Long".equals(fqnType)) {
            return true;
        }
        if ("java.lang.Short".equals(fqnType)) {
            return true;
        }
        return "java.lang.Byte".equals(fqnType);
    }

    private static boolean isDoubleType(String fqnType) {
        if ("java.lang.Float".equals(fqnType)) {
            return true;
        }
        return "java.lang.Double".equals(fqnType);
    }

    private static IJavaProject findProject(ContentAssistRequest contentAssistRequest) {
        Document xmlDoc = contentAssistRequest.getNode().getOwnerDocument();
        return Util.findProject(xmlDoc);
    }

    private static IType findType(String name, ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        return Util.findType(name, contentAssistRequest.getNode().getOwnerDocument());
    }

    static List<String> getImportedTypes(ContentAssistRequest contentAssistRequest) {
        Document xmlDoc = contentAssistRequest.getNode().getOwnerDocument();
        return Util.getImportedTypes(xmlDoc);
    }

    protected void addCommentProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    protected void addEndTagNameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    protected void addEndTagProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    protected void addPCDATAProposal(String nodeName, ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    protected void addTagCloseProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
    }

    protected void addEntityProposals(ContentAssistRequest contentAssistRequest, ITextRegion completionRegion, IDOMNode treeNode, CompletionProposalInvocationContext context) {
    }

    protected void addEntityProposals(Vector proposals, Properties map, String key, int nodeOffset, IStructuredDocumentRegion sdRegion, ITextRegion completionRegion, CompletionProposalInvocationContext context) {
    }

    static abstract class Filter {
        Filter() {
        }

        public abstract boolean select(String var1);
    }

    static class HoverImpl
    implements IEObjectHover,
    ITextHoverExtension {
        private JavadocHoverWrapper javadocWrapper = new JavadocHoverWrapper();
        private IJavaElement currentElement;

        public HoverImpl(IJavaElement currentElement) {
            this.currentElement = currentElement;
        }

        public IInformationControlCreator getHoverControlCreator() {
            this.javadocWrapper.setJavaElement(this.currentElement);
            return this.javadocWrapper.getHoverControlCreator();
        }

        public Object getHoverInfo(EObject eObject, ITextViewer textViewer, IRegion hoverRegion) {
            this.javadocWrapper.setJavaElement(this.currentElement);
            return this.javadocWrapper.getHoverInfo2(textViewer, hoverRegion);
        }
    }

    static class JavadocHoverWrapper
    extends JavadocHover {
        private IJavaElement currentElement;

        JavadocHoverWrapper() {
        }

        public void setJavaElement(IJavaElement element) {
            this.currentElement = element;
        }

        protected IJavaElement[] getJavaElementsAt(ITextViewer textViewer, IRegion hoverRegion) {
            return new IJavaElement[]{this.currentElement};
        }
    }
}

