/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx.services;

import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.eclipse.fx.code.editor.services.CompletionProposal;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.StyledString;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.jface.text.IDocument;

public class FXCompletionProposal<T extends CompletionProposal>
implements ICompletionProposal {
    private final T proposal;
    private Node graphicNode;
    private Function<T, Node> graphicComputer;
    private final Function<T, CharSequence> labelComputer;
    private CharSequence label;
    private CharSequence fHoverInfo;
    private final Function<T, CharSequence> hoverInfoComputer;
    private final IContextInformation fContextInformation;

    public FXCompletionProposal(T proposal, Supplier<Node> graphicSupplier, IContextInformation contextInformation, CharSequence hoverInfo) {
        this(proposal, proposal.getLabel(), graphicSupplier, contextInformation, hoverInfo);
    }

    public FXCompletionProposal(T proposal, CharSequence label, Supplier<Node> graphicSupplier, IContextInformation contextInformation, CharSequence hoverInfo) {
        this((CompletionProposal)proposal, (T p) -> label, (T p) -> (Node)graphicSupplier.get(), contextInformation, (T p) -> hoverInfo);
    }

    public FXCompletionProposal(T proposal, Function<T, CharSequence> labelComputer, Function<T, Node> graphicComputer, IContextInformation contextInformation, Function<T, CharSequence> hoverInfoComputer) {
        this.proposal = proposal;
        this.label = null;
        this.labelComputer = labelComputer;
        this.graphicNode = null;
        this.graphicComputer = graphicComputer;
        this.fContextInformation = contextInformation;
        this.fHoverInfo = null;
        this.hoverInfoComputer = hoverInfoComputer;
    }

    public Node getGraphic() {
        if (this.graphicNode == null) {
            this.graphicNode = this.graphicComputer.apply(this.proposal);
        }
        return this.graphicNode;
    }

    public Node getContentNode() {
        CharSequence v = this.getLabel();
        if (v instanceof StyledString) {
            return Util.toNode((StyledString)((StyledString)v));
        }
        return new Label(v != null ? v.toString() : "<unknown>");
    }

    public CharSequence getLabel() {
        if (this.label == null) {
            this.label = this.labelComputer.apply(this.proposal);
        }
        return this.label;
    }

    public void apply(IDocument document) {
        this.proposal.apply(document);
    }

    public TextSelection getSelection(IDocument document) {
        CompletionProposal.TextSelection selection = this.proposal.getSelection(document);
        return new TextSelection(selection.offset, selection.length);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public CharSequence getHoverInfo() {
        if (this.fHoverInfo == null) {
            this.fHoverInfo = this.hoverInfoComputer.apply(this.proposal);
        }
        return this.fHoverInfo;
    }
}

