/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.internal;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.fx.core.databinding.AdapterFactory;
import org.eclipse.fx.core.databinding.ObservableWritableValue;
import org.eclipse.jdt.annotation.NonNull;

public final class TextOnlyPropertyTableCell<S, T>
extends TableCell<S, T> {
    private IObservableValue currentObservable;
    private @NonNull IValueProperty textProperty;

    public TextOnlyPropertyTableCell(@NonNull IValueProperty textProperty) {
        this.textProperty = textProperty;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        IObservableValue oldObservable = this.currentObservable;
        this.textProperty().unbind();
        if (item != null && !empty) {
            this.currentObservable = this.textProperty.observe(item);
            ObservableWritableValue adapt = AdapterFactory.adapt((IObservableValue)this.currentObservable);
            this.textProperty().bind((ObservableValue)adapt);
        } else {
            this.setText(null);
        }
        if (oldObservable != null) {
            oldObservable.dispose();
        }
    }
}

