/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.eclipse.fx.ui.controls.styledtext.internal.ReuseCache;

public class NodeCachePane
extends Pane {
    protected final ReuseCache<Node> cache;

    public NodeCachePane(Supplier<Node> nodeFactory) {
        this.cache = new ReuseCache<Node>(nodeFactory);
        this.cache.addOnActivate(node -> {
            if (!this.getChildren().contains(node)) {
                this.getChildren().add(node);
            }
            node.setVisible(true);
        });
        this.cache.addOnRelease(node -> {
            boolean bl = this.getChildren().remove(node);
        });
        this.cache.addOnClear(node -> {
            boolean bl = this.getChildren().remove(node);
        });
    }

    protected Node getNode() {
        return this.cache.getElement();
    }

    protected void releaseNode(Node node) {
        this.cache.releaseElement(node);
    }

    protected void cleanup() {
        this.cache.clearFreeElements();
    }
}

