/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.animation.pagetransition.animation;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.util.Duration;
import org.eclipse.fx.ui.animation.pagetransition.CenterSwitchAnimation;

public class SlideAnimation
extends CenterSwitchAnimation {
    @Override
    protected Animation createAndPrepareAnimation(Node curNode, Node newNode) {
        newNode.setOpacity(1.0);
        double deltaX = -curNode.getBoundsInLocal().getWidth();
        newNode.setTranslateX(-deltaX);
        return new ParallelTransition(new Animation[]{SlideAnimation.createTransition(curNode, deltaX), SlideAnimation.createTransition(newNode, deltaX)});
    }

    private static TranslateTransition createTransition(Node n, double deltaX) {
        TranslateTransition t = new TranslateTransition(Duration.millis((double)1000.0), n);
        t.setInterpolator(Interpolator.EASE_BOTH);
        t.setByX(deltaX);
        return t;
    }

    @Override
    protected void resetProperties(Node curNode, Node newNode) {
        newNode.setTranslateX(0.0);
        curNode.setTranslateX(0.0);
    }
}

