/*******************************************************************************
 * Copyright (c) 2012 BestSolution.at and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tom Schindl<tom.schindl@bestsolution.at> - initial API and implementation
 *******************************************************************************/
package org.eclipse.fx.formats.svg.svg;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Marker Element</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getClass_ <em>Class</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getStyle <em>Style</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getExternalResourcesRequired <em>External Resources Required</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getViewBox <em>View Box</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getPreserveAspectRatio <em>Preserve Aspect Ratio</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getRefX <em>Ref X</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getRefY <em>Ref Y</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getMarkerUnits <em>Marker Units</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getMarkerWidth <em>Marker Width</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getMarkerHeight <em>Marker Height</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getOrient <em>Orient</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement()
 * @model
 * @generated
 */
public interface SvgMarkerElement extends SvgElement, CoreAttributes, PresentationAttributes, ContentElement<SvgElement> {
	/**
	 * Returns the value of the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Class</em>' attribute.
	 * @see #setClass(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_Class()
	 * @model
	 * @generated
	 */
	String getClass_();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getClass_ <em>Class</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Class</em>' attribute.
	 * @see #getClass_()
	 * @generated
	 */
	void setClass(String value);

	/**
	 * Returns the value of the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Style</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Style</em>' attribute.
	 * @see #setStyle(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_Style()
	 * @model
	 * @generated
	 */
	String getStyle();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getStyle <em>Style</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Style</em>' attribute.
	 * @see #getStyle()
	 * @generated
	 */
	void setStyle(String value);

	/**
	 * Returns the value of the '<em><b>External Resources Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>External Resources Required</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>External Resources Required</em>' attribute.
	 * @see #setExternalResourcesRequired(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_ExternalResourcesRequired()
	 * @model
	 * @generated
	 */
	String getExternalResourcesRequired();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getExternalResourcesRequired <em>External Resources Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>External Resources Required</em>' attribute.
	 * @see #getExternalResourcesRequired()
	 * @generated
	 */
	void setExternalResourcesRequired(String value);

	/**
	 * Returns the value of the '<em><b>View Box</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>View Box</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>View Box</em>' attribute.
	 * @see #setViewBox(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_ViewBox()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.ViewBox"
	 * @generated
	 */
	String getViewBox();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getViewBox <em>View Box</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>View Box</em>' attribute.
	 * @see #getViewBox()
	 * @generated
	 */
	void setViewBox(String value);

	/**
	 * Returns the value of the '<em><b>Preserve Aspect Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Preserve Aspect Ratio</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Preserve Aspect Ratio</em>' attribute.
	 * @see #setPreserveAspectRatio(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_PreserveAspectRatio()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.PreserveAspectRatio"
	 * @generated
	 */
	String getPreserveAspectRatio();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getPreserveAspectRatio <em>Preserve Aspect Ratio</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Preserve Aspect Ratio</em>' attribute.
	 * @see #getPreserveAspectRatio()
	 * @generated
	 */
	void setPreserveAspectRatio(String value);

	/**
	 * Returns the value of the '<em><b>Ref X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ref X</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ref X</em>' attribute.
	 * @see #setRefX(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_RefX()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Coordinate"
	 * @generated
	 */
	String getRefX();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getRefX <em>Ref X</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ref X</em>' attribute.
	 * @see #getRefX()
	 * @generated
	 */
	void setRefX(String value);

	/**
	 * Returns the value of the '<em><b>Ref Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ref Y</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ref Y</em>' attribute.
	 * @see #setRefY(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_RefY()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Coordinate"
	 * @generated
	 */
	String getRefY();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getRefY <em>Ref Y</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ref Y</em>' attribute.
	 * @see #getRefY()
	 * @generated
	 */
	void setRefY(String value);

	/**
	 * Returns the value of the '<em><b>Marker Units</b></em>' attribute.
	 * The default value is <code>"MarkerUnits.strokeWidth"</code>.
	 * The literals are from the enumeration {@link org.eclipse.fx.formats.svg.svg.MarkerUnits}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Marker Units</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Marker Units</em>' attribute.
	 * @see org.eclipse.fx.formats.svg.svg.MarkerUnits
	 * @see #setMarkerUnits(MarkerUnits)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_MarkerUnits()
	 * @model default="MarkerUnits.strokeWidth"
	 * @generated
	 */
	MarkerUnits getMarkerUnits();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getMarkerUnits <em>Marker Units</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Marker Units</em>' attribute.
	 * @see org.eclipse.fx.formats.svg.svg.MarkerUnits
	 * @see #getMarkerUnits()
	 * @generated
	 */
	void setMarkerUnits(MarkerUnits value);

	/**
	 * Returns the value of the '<em><b>Marker Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Marker Width</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Marker Width</em>' attribute.
	 * @see #setMarkerWidth(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_MarkerWidth()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Length"
	 * @generated
	 */
	String getMarkerWidth();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getMarkerWidth <em>Marker Width</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Marker Width</em>' attribute.
	 * @see #getMarkerWidth()
	 * @generated
	 */
	void setMarkerWidth(String value);

	/**
	 * Returns the value of the '<em><b>Marker Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Marker Height</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Marker Height</em>' attribute.
	 * @see #setMarkerHeight(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_MarkerHeight()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Length"
	 * @generated
	 */
	String getMarkerHeight();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getMarkerHeight <em>Marker Height</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Marker Height</em>' attribute.
	 * @see #getMarkerHeight()
	 * @generated
	 */
	void setMarkerHeight(String value);

	/**
	 * Returns the value of the '<em><b>Orient</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Orient</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Orient</em>' attribute.
	 * @see #setOrient(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgMarkerElement_Orient()
	 * @model
	 * @generated
	 */
	String getOrient();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgMarkerElement#getOrient <em>Orient</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Orient</em>' attribute.
	 * @see #getOrient()
	 * @generated
	 */
	void setOrient(String value);

} // SvgMarkerElement
